#region GNU General Public License
//
// NAntContrib
// Copyright (C) 2001-2003 Gerry Shaw
//
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
//

// Jason Reimer, Diversant Inc. (jason.reimer@diversant.net)
// William E. Caputo, ThoughtWorks Inc. (billc@thoughtworks.com)
#endregion

using System;
using System.Diagnostics;
using System.Text;

using NAnt.Core;
using NAnt.Core.Attributes;

namespace NAnt.Contrib.Tasks.Vault {

    /// <summary>
    /// Gets files from a SourceGear Vault repository.
    /// Author: Bart Read
    /// </summary>
    [TaskName("vaultget")]
    public sealed class GetTask : RetrievalTask {

        bool		_makeWriteable	= false;
        bool		_makeReadOnly	= true;
        bool		_noCloaks		= false;
        bool		_noRecursive	= false;
        string		_localPath;


        //  TODO: following two items should not both be allowed to be true,
        //  but I guess default is to take no action.
        
        /// <summary>
        /// Make all files writable after retrieval.
        /// Default is false.
        /// </summary>
        [TaskAttribute("makewriteable")]
        public bool MakeWriteable {
            get { return _makeWriteable; }
            set { _makeWriteable = value; }
        }

        /// <summary>
        /// Make all files read-only after retrieval.
        /// Default is true.
        /// </summary>
        [TaskAttribute("makereadonly")]
        public bool MakeReadOnly {
            get { return _makeReadOnly; }
            set { _makeReadOnly = value; }
        }

        /// <summary>
        /// Performs actions on all folders even if they
        /// were previously cloaked.  Default is false.
        /// </summary>
        [TaskAttribute("nocloaks")]
        public bool NoCloaks {
            get { return _noCloaks; }
            set { _noCloaks = value; }
        }

        /// <summary>
        /// Do not act recursively on folders.  Default is false.
        /// </summary>
        [TaskAttribute("norecursive")]
        public bool NoRecursive {
            get { return _noRecursive; }
            set { _noRecursive = value; }
        }

        /// <summary>
        /// Use local folder for actions instead of any existing
        /// working folder.
        /// </summary>
        [TaskAttribute("localpath")]
        public string LocalPath {
            get { return _localPath; }
            set { _localPath = value; }
        }

        protected override string CreateArguments() {
            StringBuilder arguments	= new StringBuilder("GET");

            arguments.Append( CreateCommonArguments() );

            arguments.Append(" -destpath ");
            arguments.Append("\"" + LocalPath + "\"");

            if (MakeWriteable) {
                arguments.Append(" -makewriteable");
            } else if (MakeReadOnly) {
                arguments.Append(" -makereadonly");
            }

            arguments.Append( CreateRetrievalArguments() );

            if (NoCloaks) {
                arguments.Append(" -nocloaks");
            }

            if (NoRecursive) {
                arguments.Append(" -norecursive");
            }

            arguments.Append(" ");
            arguments.Append("\"" + RepositoryPath + "\"");

            return arguments.ToString();
        }
    }
}
