#region GNU General Public License
//
// NAntContrib
// Copyright (C) 2001-2003 Gerry Shaw
//
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
//

// Jason Reimer, Diversant Inc. (jason.reimer@diversant.net)
// William E. Caputo, ThoughtWorks Inc. (billc@thoughtworks.com)
#endregion

using System;
using System.Diagnostics;
using System.Text;

using NAnt.Core;
using NAnt.Core.Attributes;

namespace NAnt.Contrib.Tasks.Vault {

    /// <summary>
    /// Generic properties for tasks that 'retrieve'
    /// files from the repository... although actually
    /// checking out doesn't physically retrieve anything.
    /// Author: Bart Read
    /// </summary>
    public abstract class RetrievalTask : VaultTask {

        Merge       _merge          = Merge.Automatic;
        FileTime    _setFileTime    = FileTime.Checkin;

        /// <summary>
        /// Merge action to take on modified files.
        /// </summary>
        [TaskAttribute("merge")]
        public Merge Merge {
            get { return _merge; }
            set { _merge = value; }
        }

        /// <summary>
        /// Set file modification time according to value
        /// of this property.
        /// </summary>
        [TaskAttribute("setfiletime")]
        public FileTime SetFileTime {
            get { return _setFileTime; }
            set { _setFileTime = value; }
        }

        protected string CreateRetrievalArguments() {
            StringBuilder arguments = new StringBuilder();

            arguments.Append(" -merge ");
            arguments.Append(Merge.ToString().ToLower());

            arguments.Append(" -setfiletime ");
            arguments.Append(SetFileTime);

            return arguments.ToString();
        }

    }

}