#region GNU General Public License
//
// NAntContrib
// Copyright (C) 2001-2003 Gerry Shaw
//
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
//

// Jason Reimer, Diversant Inc. (jason.reimer@diversant.net)
// William E. Caputo, ThoughtWorks Inc. (billc@thoughtworks.com)
#endregion

using System;
using System.Diagnostics;
using System.Text;

using NAnt.Core;
using NAnt.Core.Attributes;

namespace NAnt.Contrib.Tasks.Vault {

    /// <summary>
    /// Sets the working folder for a given repository path.
    /// Author: Bart Read
    /// </summary>
    [TaskName("vaultsetworkingfolder")]
    public sealed class SetWorkingFolderTask : VaultTask {

        string  _localPath;

        /// <summary>
        /// Local working folder.
        /// </summary>
        [TaskAttribute("localpath")]
        public string LocalPath {
            get { return _localPath; }
            set { _localPath = value; }
        }

        protected override string CreateArguments() {
            StringBuilder arguments = new StringBuilder( "SETWORKINGFOLDER" );

            arguments.Append( CreateCommonArguments() );

            arguments.Append( " \"" + RepositoryPath + "\"" );
            arguments.Append( " \"" + LocalPath + " \"" );

            return arguments.ToString();
        }

    }

}