#! /bin/sh
# Build Net-SNMP 5.1.1 using MinGW
# configures, builds, installs, strips binaries.

# experience has shown that changing the order
# of configure options may be necessary
# when those options are changed.
#
# It is not clear why that is.
#

## set the base directory for compiled-in values
BASEDIR=c:/progra~1/Net-SNMP
BASEDIR=c:/usr-mingw

./configure \
 --prefix="$BASEDIR" \
 --sysconfdir="$BASEDIR/etc" \
 --sbindir="$BASEDIR/bin" \
 --with-mibdirs="$BASEDIR/share/snmp/mibs" \
 --with-persistent-directory="$BASEDIR/var" \
 --with-default-snmp-version=3 \
 --with-sys-contact="contact" \
 --with-sys-location="location" \
 --with-mib-modules="disman/event-mib examples/example" \
 --with-logfile="$BASEDIR/snmpd.log" \
 --enable-developer \
 > cfg.out 2>&1

RC=$?
echo "Configure returns $RC"
if [ "$RC" -ne 0 ] ; then
    exit 1
fi


#BASEDIR=c:/progra~1/Net-SNMP

# the above configure options
## --prefix="$BASEDIR" \
#              everything starts from here
#
## --sysconfdir="$BASEDIR/etc" \
#		SNMPCONFPATH = this + "snmp"
#
## --sbindir="$BASEDIR/bin" \
#		keep the daemons with the applications
#
## --with-mibdirs="$BASEDIR/share/snmp/mibs" \
#		not setting this guarantees failure. See bugs
#
## --with-persistent-directory="$BASEDIR/var" \
#		PERSISTENT_DIRECTORY = this + "snmp/persist"
#
## --with-default-snmp-version=3 \
## --with-sys-contact="contact" \
## --with-sys-location="location" \
#
## --with-mib-modules="disman/event-mib examples/example" \
#
## --with-logfile="$BASEDIR/snmpd.log" \
#		There should be a better place for this
#
## --enable-ipv6 --with-transports="TCPIPv6 UDPIPv6" \
#		enable IPv6 base access and transports
#
## --enable-developer \
#		more compiler warnings

### Configure succeeded. ###
make > make.out 2>&1
RC=$?
echo "Make returns $RC"
if [ "$RC" -ne 0 ] ; then
    exit 2
fi
### Make succeeded. ###

make install > inst.out 2>&1
RC=$?
echo "Make install returns $RC"
if [ "$RC" -ne 0 ] ; then
    exit 3
fi
### Install succeeded. ###

(cd $BASEDIR/bin ; strip *.exe)
### Strip binaries is the last step. ###
exit 0

### no execution past here.  collect options if you like ###

 --enable-ipv6 --with-transports="TCPIPv6 UDPIPv6" \
 --with-mib-modules="disman/event-mib smux tunnel/tunnel examples/example" \

