#!/bin/sh
echo -n "clean..."
make distclean > /dev/null 2>&1
rm -f *.out configure.lineno
find /usr/local -name '*snmp*' | egrep -v "etc/snmp|nessus" | xargs rm -rf
find /usr/local -name '*ucd*' | egrep -v nessus | xargs rm -rf
echo -n "configure..."
./configure --enable-manuals --enable-mibs --enable-mib-loading \
 --enable-ucd-snmp-compatibility \
 --disable-privacy \
  --enable-ipv6 --with-transports="TCPIPv6 UDPIPv6" \
 --with-mib-modules="host mibII/mta_sendmail ucd-snmp/diskio agentx disman/event-mib examples/example examples/ucdDemoPublic" \
  --with-defaults \
  > cfg.out 2>&1
 

RC=$?
if [ $RC -ne 0 ] ; then
  grep -A 5 rror cfg.out
  echo "**FAIL** configure"
  exit 1
fi

echo -n "make..."
make > make.out 2>&1
RC=$?
if [ $RC -ne 0 ] ; then
  grep -A 5 rror make.out
  echo "**FAIL** make"
  exit 1
fi

echo -n "make test..."
make test > maketest.out 2>&1
RC=$?
if [ $RC -ne 0 ] ; then
  echo
  grep FAIL maketest.out
  echo -n "**FAIL** make test; Continuing..."
fi

echo -n "make install..."
make install > inst.out 2>&1
RC=$?
if [ $RC -ne 0 ] ; then
  grep -A 5 rror inst.out
  echo "**FAIL** make install"
  exit 1
fi

echo "Done."

exit 0

"make test" fails if next line is added to configure
31:testing AgentX trap sending support...FAIL
  --with-mib-modules="examples/example" \

snmpwalk halts on second IP6 TCP object
 because OID is not lexicographically increasing.
  --enable-ipv6 --with-transports="TCPIPv6 UDPIPv6" \
 --with-openssl --without-rpm \
