/*
 * Note: this file originally auto-generated by mib2c using
 *       version : 1.20 $ of : mfd-data-get.m2c,v $ 
 *
 * $Id:$
 */
/*
 * standard Net-SNMP includes 
 */
#include <net-snmp/net-snmp-config.h>
#include <net-snmp/net-snmp-includes.h>
#include <net-snmp/agent/net-snmp-agent-includes.h>

/*
 * include our parent header 
 */
#include "CCliCtrTable.h"


/** @defgroup data_get data_get: Routines to get data
 *
 * TODO:230:M: Implement CCliCtrTable get routines.
 * TODO:240:M: Implement CCliCtrTable mapping routines (if any).
 *
 * These routine are used to get the value for individual objects. The
 * row context is passed, along with a pointer to the memory where the
 * value should be copied.
 *
 * @{
 */
/**********************************************************************
 **********************************************************************
 ***
 *** Table CCliCtrTable
 ***
 **********************************************************************
 **********************************************************************/
/*
 * SNDA-SNMP-MIB::CCliCtrTable is subid 1 of cliCtr.
 * Its status is Current.
 * OID: .1.3.6.1.4.1.2021.13.5243.1.2.1, length: 12
 */

/*
 * ---------------------------------------------------------------------
 * * TODO:200:r: Implement CCliCtrTable data context functions.
 */


/**
 * set mib index(es)
 *
 * @param tbl_idx mib index structure
 *
 * @retval MFD_SUCCESS     : success.
 * @retval MFD_ERROR       : other error.
 *
 * @remark
 *  This convenience function is useful for setting all the MIB index
 *  components with a single function call. It is assume that the C values
 *  have already been mapped from their native/rawformat to the MIB format.
 */
int
CCliCtrTable_indexes_set_tbl_idx(CCliCtrTable_mib_index * tbl_idx,
                                 u_long SrvIp4CliCtr_val,
                                 long SrvPort4CliCtr_val,
                                 u_long GsIp4CliCtr_val,
                                 long GsPort4CliCtr_val)
{
    DEBUGMSGTL(("verbose:CCliCtrTable:CCliCtrTable_indexes_set_tbl_idx",
                "called\n"));

    /*
     * SrvIp4CliCtr(2)/IPADDR/ASN_IPADDRESS/u_long(u_long)//l/A/W/e/r/d/h 
     */
    tbl_idx->SrvIp4CliCtr = SrvIp4CliCtr_val;

    /*
     * SrvPort4CliCtr(3)/INTEGER/ASN_INTEGER/long(long)//l/A/W/e/r/d/h 
     */
    tbl_idx->SrvPort4CliCtr = SrvPort4CliCtr_val;

    /*
     * GsIp4CliCtr(4)/IPADDR/ASN_IPADDRESS/u_long(u_long)//l/A/W/e/r/d/h 
     */
    tbl_idx->GsIp4CliCtr = GsIp4CliCtr_val;

    /*
     * GsPort4CliCtr(5)/INTEGER/ASN_INTEGER/long(long)//l/A/W/e/r/d/h 
     */
    tbl_idx->GsPort4CliCtr = GsPort4CliCtr_val;


    return MFD_SUCCESS;
}                               /* CCliCtrTable_indexes_set_tbl_idx */

/**
 * @internal
 * set row context indexes
 *
 * @param reqreq_ctx the row context that needs updated indexes
 *
 * @retval MFD_SUCCESS     : success.
 * @retval MFD_ERROR       : other error.
 *
 * @remark
 *  This function sets the mib indexs, then updates the oid indexs
 *  from the mib index.
 */
int
CCliCtrTable_indexes_set(CCliCtrTable_rowreq_ctx * rowreq_ctx,
                         u_long SrvIp4CliCtr_val, long SrvPort4CliCtr_val,
                         u_long GsIp4CliCtr_val, long GsPort4CliCtr_val)
{
    DEBUGMSGTL(("verbose:CCliCtrTable:CCliCtrTable_indexes_set",
                "called\n"));

    if (MFD_SUCCESS !=
        CCliCtrTable_indexes_set_tbl_idx(&rowreq_ctx->tbl_idx,
                                         SrvIp4CliCtr_val,
                                         SrvPort4CliCtr_val,
                                         GsIp4CliCtr_val,
                                         GsPort4CliCtr_val))
        return MFD_ERROR;

    /*
     * convert mib index to oid index
     */
    rowreq_ctx->oid_idx.len = sizeof(rowreq_ctx->oid_tmp) / sizeof(oid);
    if (0 != CCliCtrTable_index_to_oid(&rowreq_ctx->oid_idx,
                                       &rowreq_ctx->tbl_idx)) {
        return MFD_ERROR;
    }

    return MFD_SUCCESS;
}                               /* CCliCtrTable_indexes_set */


/*---------------------------------------------------------------------
 * SNDA-SNMP-MIB::CCliCtrRow.Stat4CliCtr
 * Stat4CliCtr is subid 1 of CCliCtrRow.
 * Its status is Current, and its access level is WriteOnly.
 * OID: .1.3.6.1.4.1.2021.13.5243.1.2.1.1.1
 * Description:
xxx
 *
 * Attributes:
 *   accessible 1     isscalar 1     enums  1      hasdefval 0
 *   readable   0     iscolumn 0     ranges 0      hashint   0
 *   settable   1
 *
 * Enum range: 3/8. Values:  destroy(1), create(2), active(3)
 *
 * Its syntax is CCliCtrStat (based on perltype INTEGER)
 * The net-snmp type is ASN_INTEGER. The C type decl is long (u_long)
 */
/**
 * Extract the current value of the Stat4CliCtr data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param Stat4CliCtr_val_ptr
 *        Pointer to storage for a long variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
Stat4CliCtr_get(CCliCtrTable_rowreq_ctx * rowreq_ctx,
                u_long * Stat4CliCtr_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != Stat4CliCtr_val_ptr);


    DEBUGMSGTL(("verbose:CCliCtrTable:Stat4CliCtr_get", "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:231:o: |-> Extract the current value of the Stat4CliCtr data.
     * copy (* Stat4CliCtr_val_ptr ) from rowreq_ctx->data
     */
    (*Stat4CliCtr_val_ptr) = rowreq_ctx->data.Stat4CliCtr;

    return MFD_SUCCESS;
}                               /* Stat4CliCtr_get */



/** @} */
