--- agent/mibgroup/mibII/ipv6.c.orig	2007-05-25 00:01:04.000000000 +0200
+++ agent/mibgroup/mibII/ipv6.c	2009-06-10 12:46:17.000000000 +0200
@@ -8,10 +8,25 @@
 #define _KERNEL 1
 #define _I_DEFINED_KERNEL
 #endif
+
+/* make this source a wee bit more readable */
+#if defined(__NetBSD__) && __NetBSD_Version__ >= 106250000	/*1.6Y*/
+#define OS_NET_BSD_16_OR_LATER 1
+#endif
+#if !(defined(__FreeBSD__) && __FreeBSD__ >= 3) && !defined(darwin)
+#define OS_NOT_FREEBSD_NOR_DARWIN 1
+#endif
+#if (defined(__FreeBSD__) && __FreeBSD__ >= 3) || defined(darwin)
+#define OS_FREEBSD_OR_DARWIN 1
+#if !defined(INP_IPV6PROTO)
+#define	INP_IPV6PROTO	0x04
+#endif
+#endif
+
 #include <sys/types.h>
 #include <sys/param.h>
 #include <sys/socket.h>
-#if (defined(__FreeBSD__) && __FreeBSD__ >= 3) || defined(darwin)
+#if OS_FREEBSD_OR_DARWIN
 # if HAVE_SYS_SOCKETVAR_H
 #  include <sys/socketvar.h>
 # endif
@@ -80,7 +95,7 @@
 # include <netinet6/ip6_var.h>
 #endif
 #include <net/route.h>
-#if (defined(__FreeBSD__) && __FreeBSD__ >= 3) || defined(darwin)
+#if OS_FREEBSD_OR_DARWIN
 # if HAVE_NETINET_IN_PCB_H
 #  include <netinet/in_pcb.h>
 # endif
@@ -138,6 +153,11 @@
 #include "ipv6.h"
 #include "interfaces.h"
 
+#if (defined(__FreeBSD__) && __FreeBSD__ >= 3)
+#include <ifaddrs.h>
+#include <netinet/in_var.h>
+#endif
+
 static int header_ipv6
 (register struct variable *, oid *, size_t *, int, size_t *,
      WriteMethod **);
@@ -208,6 +228,12 @@
     {IPV6IFSTATSOUTMCASTPKTS, ASN_COUNTER, RONLY, var_ifv6Entry, 3,
      {6, 1, 20}},
 
+    {IPV6ADDRADDRESS, ASN_OCTET_STR, RONLY, var_ipv6AddrEntry, 3, {8, 1, 1}},
+    {IPV6ADDRPFXLEN, ASN_INTEGER, RONLY, var_ipv6AddrEntry, 3, {8, 1, 2}},
+    {IPV6ADDRTYPE, ASN_INTEGER, RONLY, var_ipv6AddrEntry, 3, {8, 1, 3}},
+    {IPV6ADDRANYCASTFLAG, ASN_INTEGER, RONLY, var_ipv6AddrEntry, 3, {8, 1, 4}},
+    {IPV6ADDRSTATUS, ASN_INTEGER, RONLY, var_ipv6AddrEntry, 3, {8, 1, 5}},
+
 #if 0
     {IPV6ADDRPREFIXONLINKFLG, INTEGER, RONLY, var_ipv6AddrEntry, 3,
      {7, 1, 3}},
@@ -218,10 +244,12 @@
     {IPV6ADDRPREFIXVALIDLIFE, UNSIGNED32, RONLY, var_ipv6AddrEntry, 3,
      {7, 1, 6}},
 
+#if (defined(__FreeBSD__) && __FreeBSD__ >= 3)
     {IPV6ADDRPFXLEN, INTEGER, RONLY, var_ipv6AddrEntry, 3, {8, 1, 2}},
     {IPV6ADDRTYPE, INTEGER, RONLY, var_ipv6AddrEntry, 3, {8, 1, 3}},
     {IPV6ADDRANYCASTFLAG, INTEGER, RONLY, var_ipv6AddrEntry, 3, {8, 1, 4}},
     {IPV6ADDRSTATUS, INTEGER, RONLY, var_ipv6AddrEntry, 3, {8, 1, 5}},
+#endif
 
     {IPV6ROUTEIFINDEX, IpV6IFINDEX, RONLY, var_ipv6RouteEntry, 3,
      {11, 1, 4}},
@@ -578,7 +606,7 @@
             memcpy(result, &tmp, sizeof(tmp));
             return 0;
         }
-#if (defined(__FreeBSD__) && __FreeBSD__ >= 3) || defined(darwin)
+#if OS_FREEBSD_OR_DARWIN
         q = (caddr_t) TAILQ_NEXT(&tmp, if_link);
 #else
 # if defined(__NetBSD__) || defined(__OpenBSD__)
@@ -727,6 +755,170 @@
     return NULL;
 }
 
+#if (defined(__FreeBSD__) && __FreeBSD__ >= 3)
+static struct ifaddrs *ifap = 0;
+static u_int ipv6_count = 0;
+
+static void get_ipv6_addresses() {
+  struct ifaddrs *ifa;
+
+  if (ifap) {
+    freeifaddrs(ifap);
+    ipv6_count = 0;
+  }
+  
+  if (getifaddrs(&ifap) != 0) {
+    syslog(LOG_WARNING, "getifaddrs() error");
+    ipv6_count = 0;
+  } else {
+    for (ifa = ifap; ifa; ifa = ifa->ifa_next) {
+      if ( ifa->ifa_addr->sa_family == AF_INET6 )
+	ipv6_count++;
+    }
+  }
+}
+
+static struct ifaddrs* get_ipv6_address_at_index(u_int idx) {
+  struct ifaddrs* ifa;
+  u_int ipv6_found = 0;
+
+  if (ifap == NULL)
+    get_ipv6_addresses();
+  if (ipv6_count == 0)
+    return NULL;
+  if (ipv6_count < idx)
+    return NULL;
+
+  for (ifa = ifap; ifa; ifa=ifa->ifa_next)
+  {
+    if ( ifa->ifa_addr->sa_family == AF_INET6 ) {
+      if ( ipv6_found == idx )
+	return ifa;
+      else
+	++ipv6_found;
+    }
+  }
+  return NULL;
+}
+
+// This code is inspirated from FREEBSD ifconfig (af_inet6.c)
+static int prefix(void *val, int size)
+{
+  u_char *name = (u_char *)val;
+  int byte, bit, plen = 0;
+
+  for (byte = 0; byte < size; byte++, plen += 8)
+    if (name[byte] != 0xff)
+      break;
+  if (byte == size)
+    return (plen);
+  for (bit = 7; bit != 0; bit--, plen++)
+    if (!(name[byte] & (1 << bit)))
+      break;
+  return (plen);
+}
+
+u_char         *
+var_ipv6AddrEntry(register struct variable * vp,
+         oid * name,
+         size_t * length,
+         int exact, size_t * var_len, WriteMethod ** write_method)
+{
+  int i;
+  int header = MATCH_FAILED;
+  oid newname[MAX_OID_LEN];
+  int result;
+  struct sockaddr_in6* s_in6;
+  struct ifaddrs* ifa;
+  int s6 = 0;
+  struct in6_ifreq ifr6;
+  u_int32_t flags6;  
+
+  get_ipv6_addresses();
+
+  memcpy((char *) newname, (char *) vp->name, (int) vp->namelen * sizeof(oid));
+  for (i = 0; i < ipv6_count; ++i)
+  {
+    newname[(int) vp->namelen] = i;
+    result = snmp_oid_compare(name, *length, newname, (int) vp->namelen + 1);
+    if ((exact && result == 0) || (!exact && result < 0)){
+	header = MATCH_SUCCEEDED;
+	break;
+    }
+  }
+  
+  if (header) // Not on a Leaf
+    return NULL;
+  else {
+    memcpy((char *) name, (char *) newname,
+           ((int) vp->namelen + 1) * sizeof(oid));
+    *length = vp->namelen + 1;
+    *write_method = 0;
+  }
+  
+  ifa = get_ipv6_address_at_index( name[*length - 1] );
+  if ( ifa == NULL )
+    return NULL;
+  *var_len = sizeof(long_return);
+  switch (vp->magic) {
+  case IPV6ADDRADDRESS:
+    s_in6 = (struct sockaddr_in6*) (ifa->ifa_addr);
+    *var_len = 16;
+    return (u_char*) (s_in6->sin6_addr.s6_addr);
+    break;
+
+  case IPV6ADDRPFXLEN:
+    s_in6 = (struct sockaddr_in6*) (ifa->ifa_netmask);
+    long_return = prefix(&s_in6->sin6_addr, sizeof(struct in6_addr) );
+    return (u_char *) &long_return;
+  
+  case IPV6ADDRTYPE:
+  case IPV6ADDRANYCASTFLAG:
+    s_in6 = (struct sockaddr_in6*) (ifa->ifa_addr);
+    if ((s6 = socket(AF_INET6, SOCK_DGRAM, 0)) < 0) {
+      //Error creating the Socket
+      perror("socket(AF_INET6,SOCK_DGRAM)");
+      if (vp->magic == IPV6ADDRTYPE)
+	long_return = 3;
+      else
+	long_return = 2;
+      return (u_char *) &long_return;
+    }
+    strncpy(ifr6.ifr_name, ifa->ifa_name, sizeof(ifr6.ifr_name));
+    ifr6.ifr_addr = *s_in6;
+    if (ioctl(s6, SIOCGIFAFLAG_IN6, (int)&ifr6) < 0) {
+      // Error with ioctl
+      perror("\tioctl(SIOCGIFAFLAG_IN6)");
+      close(s6);
+      if (vp->magic == IPV6ADDRTYPE)
+	long_return = 3;
+      else
+	long_return = 2;
+      return (u_char *) &long_return;
+    }
+    close(s6);
+    flags6 = ifr6.ifr_ifru.ifru_flags6;
+    switch (vp->magic) {
+    case IPV6ADDRTYPE:
+      long_return = flags6&IN6_IFF_AUTOCONF?1:2;
+      return (u_char *) &long_return;
+    case IPV6ADDRANYCASTFLAG:
+      long_return = flags6&IN6_IFF_ANYCAST?1:2;
+      return (u_char *) &long_return;
+    }
+    
+  case IPV6ADDRSTATUS:
+    //Can't have it
+    long_return = 5;
+    return (u_char *) &long_return;
+  
+  default:
+    break;
+  }
+  return NULL;
+}
+#endif
+
 u_char         *
 var_ifv6Entry(register struct variable * vp,
               oid * name,
@@ -809,7 +1001,7 @@
 
             if (if_getifnet(interface, &ifnet) < 0)
                 break;
-#if (defined(__FreeBSD__) && __FreeBSD__ >= 3) || defined(darwin)
+#if OS_FREEBSD_OR_DARWIN
             ifa = (caddr_t) TAILQ_FIRST(&ifnet.if_addrhead);
 #else
 # if defined(__NetBSD__) || defined(__OpenBSD__)
@@ -836,7 +1028,7 @@
                     *var_len = sdl.sdl_alen;
                     return (u_char *) (sdl.sdl_data + sdl.sdl_nlen);
                 }
-#if (defined(__FreeBSD__) && __FreeBSD__ >= 3) || defined(darwin)
+#if OS_FREEBSD_OR_DARWIN
                 ifa = (caddr_t) TAILQ_NEXT(&ifaddr, ifa_link);
 #else
 # if defined(__NetBSD__) || defined(__OpenBSD__)
@@ -1229,32 +1421,33 @@
          size_t * length,
          int exact, size_t * var_len, WriteMethod ** write_method)
 {
-    oid             newname[MAX_OID_LEN];
-    oid             savname[MAX_OID_LEN];
+    oid             newname[MAX_OID_LEN], savname[MAX_OID_LEN];
     int             result;
     int             i, j;
     caddr_t         p;
-    static struct in6pcb in6pcb, savpcb;
+    static struct in6pcb tstpcb, savpcb;
     int             found, savnameLen;
-#if defined(__NetBSD__) && __NetBSD_Version__ >= 106250000	/*1.6Y*/
+#if OS_NOT_FREEBSD_NOR_DARWIN
+    static struct in6pcb udb6;
+#endif
+#if OS_NET_BSD_16_OR_LATER
     struct inpcbtable udbtable;
     caddr_t	    first;
-#elif (defined(__FreeBSD__) && __FreeBSD__ >= 3) || defined(darwin)
+#endif
+#if OS_FREEBSD_OR_DARWIN
     char           *sysctl_buf;
     struct xinpgen *xig, *oxig;
-#else
-    static struct in6pcb udb6;
 #endif
 
     DEBUGMSGTL(("mibII/ipv6", "var_udp6: "));
     DEBUGMSGOID(("mibII/ipv6", name, *length));
     DEBUGMSG(("mibII/ipv6", " %d\n", exact));
 
-#if defined(__NetBSD__) && __NetBSD_Version__ >= 106250000	/*1.6Y*/
+#if OS_NET_BSD_16_OR_LATER
     if (!auto_nlist("udbtable", (char *) &udbtable, sizeof(udbtable)))
         return NULL;
     first = p = (caddr_t)udbtable.inpt_queue.cqh_first;
-#elif !(defined(__FreeBSD__) && __FreeBSD__ >= 3) && !defined(darwin)
+#elif OS_NOT_FREEBSD_NOR_DARWIN
     if (!auto_nlist("udb6", (char *) &udb6, sizeof(udb6)))
         return NULL;
     p = (caddr_t) udb6.in6p_next;
@@ -1283,9 +1476,10 @@
            (int) vp->namelen * sizeof(oid));
     DEBUGMSGTL(("mibII/ipv6", "start: p=%x\n", p));
     while (
-#if defined(__NetBSD__) && __NetBSD_Version__ >= 106250000	/*1.6Y*/
+#if OS_NET_BSD_16_OR_LATER
               p &&  p != first
-#elif !(defined(__FreeBSD__) && __FreeBSD__ >= 3) && !defined(darwin)
+#elif OS_NOT_FREEBSD_NOR_DARWIN
+
               p && (u_long) p != auto_nlist_value("udb6")
 #else
               xig->xig_len > sizeof(struct xinpgen)
@@ -1293,31 +1487,32 @@
         ) {
         DEBUGMSGTL(("mibII/ipv6", "looping: p=%x\n", p));
 
-#if !(defined(__FreeBSD__) && __FreeBSD__ >= 3) && !defined(darwin)
-        if (!NETSNMP_KLOOKUP(p, (char *) &in6pcb, sizeof(in6pcb))) {
+#if OS_NOT_FREEBSD_NOR_DARWIN
+        if (!NETSNMP_KLOOKUP(p, (char *) &tstpcb, sizeof(tstpcb))) {
             DEBUGMSGTL(("mibII/ipv6", "klookup fail for udb6 at %x\n",
                         p));
             found = 0;
             break;
         }
 #else
-        in6pcb = ((struct xinpcb *) xig)->xi_inp;
+        tstpcb = ((struct xinpcb *) xig)->xi_inp;
 #endif
-#if defined(__NetBSD__) && __NetBSD_Version__ >= 106250000	/*1.6Y*/
-        if (in6pcb.in6p_af != AF_INET6)
+#if OS_NET_BSD_16_OR_LATER
+        if (tstpcb.in6p_af != AF_INET6) {
+            p = (caddr_t)tstpcb.in6p_queue.cqe_next;
             goto skip;
-#elif (defined(__FreeBSD__) && __FreeBSD__ >= 3) || defined(darwin)
-        if (0 == (in6pcb.inp_vflag & INP_IPV6))
+#elif OS_FREEBSD_OR_DARWIN
+        if (0 == (tstpcb.inp_vflag & INP_IPV6PROTO))
             goto skip;
 #endif
 
         j = (int) vp->namelen;
         for (i = 0; i < sizeof(struct in6_addr); i++)
-            newname[j++] = in6pcb.in6p_laddr.s6_addr[i];
-        newname[j++] = ntohs(in6pcb.in6p_lport);
-        if (IN6_IS_ADDR_LINKLOCAL(&in6pcb.in6p_laddr))
+            newname[j++] = tstpcb.in6p_laddr.s6_addr[i];
+        newname[j++] = ntohs(tstpcb.inp_lport);
+        if (IN6_IS_ADDR_LINKLOCAL(&tstpcb.in6p_laddr))
             newname[j++] =
-                ntohs(*(uint16_t *) & in6pcb.in6p_laddr.s6_addr[2]);
+                ntohs(*(uint16_t *) & tstpcb.in6p_laddr.s6_addr[2]);
         else
             newname[j++] = 0;
         /*XXX*/
@@ -1328,7 +1523,7 @@
 
         result = snmp_oid_compare(name, *length, newname, j);
         if (exact && (result == 0)) {
-                memcpy(&savpcb, &in6pcb, sizeof(savpcb));
+                memcpy(&savpcb, &tstpcb, sizeof(savpcb));
                 savnameLen = j;
                 memcpy(savname, newname, j * sizeof(oid));
                 found++;
@@ -1339,7 +1534,7 @@
              */
             if ((savnameLen == 0) ||
               (snmp_oid_compare(savname, savnameLen, newname, j) > 0)) {
-                memcpy(&savpcb, &in6pcb, sizeof(savpcb));
+                memcpy(&savpcb, &tstpcb, sizeof(savpcb));
                 savnameLen = j;
                 memcpy(savname, newname, j * sizeof(oid));
                     found++;
@@ -1347,15 +1542,15 @@
         }
 
       skip:
-#if defined(__NetBSD__) && __NetBSD_Version__ >= 106250000	/*1.6Y*/
-        p = (caddr_t)in6pcb.in6p_queue.cqe_next;
-#elif !(defined(__FreeBSD__) && __FreeBSD__ >= 3) && !defined(darwin)
-        p = (caddr_t) in6pcb.in6p_next;
+#if OS_NET_BSD_16_OR_LATER
+        p = (caddr_t)tstpcb.in6p_queue.cqe_next;
+#elif OS_NOT_FREEBSD_NOR_DARWIN
+        p = (caddr_t) tstpcb.in6p_next;
 #else
         xig = (struct xinpgen *) ((char *) xig + xig->xig_len);
 #endif
     }
-#if (defined(__FreeBSD__) && __FreeBSD__ >= 3) || defined(darwin)
+#if OS_FREEBSD_OR_DARWIN
     free(sysctl_buf);
 #endif
     DEBUGMSGTL(("mibII/ipv6", "found=%d\n", found));
@@ -1363,7 +1558,7 @@
         return NULL;
     *length = savnameLen;
     memcpy((char *) name, (char *) savname, *length * sizeof(oid));
-    memcpy(&in6pcb, &savpcb, sizeof(savpcb));
+    memcpy(&tstpcb, &savpcb, sizeof(savpcb));
     *write_method = 0;
     *var_len = sizeof(long);    /* default to 'long' results */
 
@@ -1376,14 +1571,14 @@
     switch (vp->magic) {
     case IPV6UDPLOCALADDRESS:
         *var_len = sizeof(struct in6_addr);
-        return in6pcb.in6p_laddr.s6_addr;
+        return savpcb.in6p_laddr.s6_addr;
     case IPV6UDPLOCALPORT:
-        long_return = ntohs(in6pcb.in6p_lport);
+        long_return = ntohs(savpcb.inp_lport);
         return (u_char *) & long_return;
     case IPV6UDPIFINDEX:
-        if (IN6_IS_ADDR_LINKLOCAL(&in6pcb.in6p_laddr))
+        if (IN6_IS_ADDR_LINKLOCAL(&savpcb.in6p_laddr))
             long_return =
-                ntohs(*(uint16_t *) & in6pcb.in6p_laddr.s6_addr[2]);
+                ntohs(*(uint16_t *) & savpcb.in6p_laddr.s6_addr[2]);
         else
             long_return = 0;
         /*XXX*/ return (u_char *) & long_return;
@@ -1401,24 +1596,24 @@
          size_t * length,
          int exact, size_t * var_len, WriteMethod ** write_method)
 {
-    oid             newname[MAX_OID_LEN];
-    oid             savname[MAX_OID_LEN];
+    oid             newname[MAX_OID_LEN], savname[MAX_OID_LEN];
     int             result;
     int             i, j;
     caddr_t         p;
-    static struct in6pcb in6pcb, savpcb;
+    static struct in6pcb tstpcb, savpcb;
     struct tcp6cb   tcp6cb;
     int             found, savnameLen;
     static int      tcp6statemap[TCP6_NSTATES];
     static int      initialized = 0;
-#if defined(__NetBSD__) && __NetBSD_Version__ >= 106250000	/*1.6Y*/
+#if OS_NOT_FREEBSD_NOR_DARWIN
+    static struct in6pcb tcb6;
+#endif
+#if OS_NET_BSD_16_OR_LATER
     struct inpcbtable tcbtable;
     caddr_t	    first;
-#elif (defined(__FreeBSD__) && __FreeBSD__ >= 3) || defined(darwin)
+#elif OS_FREEBSD_OR_DARWIN
     char           *sysctl_buf;
     struct xinpgen *xig, *oxig;
-#else
-    static struct in6pcb tcb6;
 #endif
 
     if (!initialized) {
@@ -1440,11 +1635,11 @@
     DEBUGMSGOID(("mibII/ipv6", name, *length));
     DEBUGMSG(("mibII/ipv6", " %d\n", exact));
 
-#if defined(__NetBSD__) && __NetBSD_Version__ >= 106250000	/*1.6Y*/
+#if OS_NET_BSD_16_OR_LATER
     if (!auto_nlist("tcbtable", (char *) &tcbtable, sizeof(tcbtable)))
         return NULL;
     first = p = (caddr_t)tcbtable.inpt_queue.cqh_first;
-#elif !(defined(__FreeBSD__) && __FreeBSD__ >= 3) && !defined(darwin)
+#elif OS_NOT_FREEBSD_NOR_DARWIN
     if (!auto_nlist("tcb6", (char *) &tcb6, sizeof(tcb6)))
         return NULL;
     p = (caddr_t) tcb6.in6p_next;
@@ -1473,9 +1668,10 @@
            (int) vp->namelen * sizeof(oid));
     DEBUGMSGTL(("mibII/ipv6", "start: p=%x\n", p));
     while (
-#if defined(__NetBSD__) && __NetBSD_Version__ >= 106250000	/*1.6Y*/
+#if OS_NET_BSD_16_OR_LATER
               p &&  p != first
-#elif !(defined(__FreeBSD__) && __FreeBSD__ >= 3) && !defined(darwin)
+#elif OS_NOT_FREEBSD_NOR_DARWIN
+
               p && (u_long) p != auto_nlist_value("tcb6")
 #else
               xig->xig_len > sizeof(struct xinpgen)
@@ -1483,39 +1679,39 @@
         ) {
         DEBUGMSGTL(("mibII/ipv6", "looping: p=%x\n", p));
 
-#if !(defined(__FreeBSD__) && __FreeBSD__ >= 3) && !defined(darwin)
-        if (!NETSNMP_KLOOKUP(p, (char *) &in6pcb, sizeof(in6pcb))) {
+#if OS_NOT_FREEBSD_NOR_DARWIN
+        if (!NETSNMP_KLOOKUP(p, (char *) &tstpcb, sizeof(tstpcb))) {
             DEBUGMSGTL(("mibII/ipv6", "klookup fail for tcb6 at %x\n",
                         p));
             found = 0;
             break;
         }
 #else
-        in6pcb = ((struct xinpcb *) xig)->xi_inp;
+        tstpcb = ((struct xinpcb *) xig)->xi_inp;
 #endif
-#if defined(__NetBSD__) && __NetBSD_Version__ >= 106250000	/*1.6Y*/
-        if (in6pcb.in6p_af != AF_INET6)
+#if OS_NET_BSD_16_OR_LATER
+        if (tstpcb.in6p_af != AF_INET6)
             goto skip;
-#elif (defined(__FreeBSD__) && __FreeBSD__ >= 3) || defined(darwin)
-        if (0 == (in6pcb.inp_vflag & INP_IPV6))
+#elif OS_FREEBSD_OR_DARWIN
+        if (0 == (tstpcb.inp_vflag & INP_IPV6))
             goto skip;
 #endif
-        if (!NETSNMP_KLOOKUP(in6pcb.in6p_ppcb, (char *) &tcp6cb, sizeof(tcp6cb))) {
+        if (!NETSNMP_KLOOKUP(tstpcb.inp_ppcb, (char *) &tcp6cb, sizeof(tcp6cb))) {
             DEBUGMSGTL(("mibII/ipv6", "klookup fail for tcb6.tcp6cb at %x\n",
-                        in6pcb.in6p_ppcb));
+                        tstpcb.inp_ppcb));
             found = 0;
             break;
         }
         j = (int) vp->namelen;
         for (i = 0; i < sizeof(struct in6_addr); i++)
-            newname[j++] = in6pcb.in6p_laddr.s6_addr[i];
-        newname[j++] = ntohs(in6pcb.in6p_lport);
+            newname[j++] = tstpcb.in6p_laddr.s6_addr[i];
+        newname[j++] = ntohs(tstpcb.inp_lport);
         for (i = 0; i < sizeof(struct in6_addr); i++)
-            newname[j++] = in6pcb.in6p_faddr.s6_addr[i];
-        newname[j++] = ntohs(in6pcb.in6p_fport);
-        if (IN6_IS_ADDR_LINKLOCAL(&in6pcb.in6p_laddr))
+            newname[j++] = tstpcb.in6p_faddr.s6_addr[i];
+        newname[j++] = ntohs(tstpcb.inp_fport);
+        if (IN6_IS_ADDR_LINKLOCAL(&tstpcb.in6p_laddr))
             newname[j++] =
-                ntohs(*(uint16_t *) & in6pcb.in6p_laddr.s6_addr[2]);
+                ntohs(*(uint16_t *) & tstpcb.in6p_laddr.s6_addr[2]);
         else
             newname[j++] = 0;
         /*XXX*/ newname[j++] = tcp6statemap[tcp6cb.t_state];
@@ -1526,13 +1722,13 @@
         DEBUGMSG(("mibII/ipv6", " %d\n", exact));
 
 #if 1                           /* this is very odd but sometimes happen, and cause infinite loop */
-        if (ntohs(in6pcb.in6p_lport) == 0)
+        if (ntohs(tstpcb.inp_lport) == 0)
             goto skip;
 #endif
 
         result = snmp_oid_compare(name, *length, newname, j);
         if (exact && (result == 0)) {
-                memcpy(&savpcb, &in6pcb, sizeof(savpcb));
+                memcpy(&savpcb, &tstpcb, sizeof(savpcb));
                 savnameLen = j;
                 memcpy(savname, newname, j * sizeof(oid));
                 found++;
@@ -1543,7 +1739,7 @@
              */
             if ((savnameLen == 0) ||
               (snmp_oid_compare(savname, savnameLen, newname, j) > 0)) {
-                memcpy(&savpcb, &in6pcb, sizeof(savpcb));
+                memcpy(&savpcb, &tstpcb, sizeof(savpcb));
                 savnameLen = j;
                 memcpy(savname, newname, j * sizeof(oid));
                     found++;
@@ -1551,15 +1747,15 @@
         }
 
       skip:
-#if defined(__NetBSD__) && __NetBSD_Version__ >= 106250000	/*1.6Y*/
-        p = (caddr_t)in6pcb.in6p_queue.cqe_next;
-#elif !(defined(__FreeBSD__) && __FreeBSD__ >= 3) && !defined(darwin)
-        p = (caddr_t) in6pcb.in6p_next;
+#if OS_NET_BSD_16_OR_LATER
+        p = (caddr_t)tstpcb.in6p_queue.cqe_next;
+#elif OS_NOT_FREEBSD_NOR_DARWIN
+        p = (caddr_t) tstpcb.in6p_next;
 #else
         xig = (struct xinpgen *) ((char *) xig + xig->xig_len);
 #endif
     }
-#if (defined(__FreeBSD__) && __FreeBSD__ >= 3) || defined(darwin)
+#if OS_FREEBSD_OR_DARWIN
     free(sysctl_buf);
 #endif
     DEBUGMSGTL(("mibII/ipv6", "found=%d\n", found));
@@ -1580,20 +1776,20 @@
     switch (vp->magic) {
     case IPV6TCPLOCALADDR:
         *var_len = sizeof(struct in6_addr);
-        return (u_char *) & in6pcb.in6p_laddr.s6_addr[0];
+        return (u_char *) & savpcb.in6p_laddr.s6_addr[0];
     case IPV6TCPLOCALPORT:
-        long_return = ntohs(in6pcb.in6p_lport);
+        long_return = ntohs(savpcb.inp_lport);
         return (u_char *) & long_return;
     case IPV6TCPREMOTEADDR:
         *var_len = sizeof(struct in6_addr);
-        return (u_char *) & in6pcb.in6p_faddr.s6_addr[0];
+        return (u_char *) & savpcb.in6p_faddr.s6_addr[0];
     case IPV6TCPREMOTEPORT:
-        long_return = ntohs(in6pcb.in6p_fport);
+        long_return = ntohs(savpcb.inp_fport);
         return (u_char *) & long_return;
     case IPV6TCPIFINDEX:
-        if (IN6_IS_ADDR_LINKLOCAL(&in6pcb.in6p_laddr))
+        if (IN6_IS_ADDR_LINKLOCAL(&savpcb.in6p_laddr))
             long_return =
-                ntohs(*(uint16_t *) & in6pcb.in6p_laddr.s6_addr[2]);
+                ntohs(*(uint16_t *) & savpcb.in6p_laddr.s6_addr[2]);
         else
             long_return = 0;
         /*XXX*/ return (u_char *) & long_return;
@@ -1640,22 +1836,23 @@
          size_t * length,
          int exact, size_t * var_len, WriteMethod ** write_method)
 {
-    oid             newname[MAX_OID_LEN];
-    oid             savname[MAX_OID_LEN];
+    oid             newname[MAX_OID_LEN], savname[MAX_OID_LEN];
     int             result;
     int             i, j;
     caddr_t         p;
-    static struct in6pcb in6pcb, savpcb;
+    static struct in6pcb tstpcb, savpcb;
     struct tcpcb    tcpcb;
     int             found, savnameLen;
-#if defined(__NetBSD__) && __NetBSD_Version__ >= 106250000	/*1.6Y*/
+#if OS_NOT_FREEBSD_NOR_DARWIN
+    static struct in6pcb tcb6;
+#endif
+#if OS_NET_BSD_16_OR_LATER
     struct inpcbtable tcbtable;
     caddr_t	    first;
-#elif (defined(__FreeBSD__) && __FreeBSD__ >= 3) || defined(darwin)
+#endif
+#if OS_FREEBSD_OR_DARWIN
     char           *sysctl_buf;
     struct xinpgen *xig, *oxig;
-#else
-    static struct in6pcb tcb6;
 #endif
 
     DEBUGMSGTL(("mibII/ipv6", "var_tcp6: "));
@@ -1695,9 +1892,9 @@
            (int) vp->namelen * sizeof(oid));
     DEBUGMSGTL(("mibII/ipv6", "start: p=%x\n", p));
     while (
-#if defined(__NetBSD__) && __NetBSD_Version__ >= 106250000	/*1.6Y*/
+#if OS_NET_BSD_16_OR_LATER
               p && p != first
-#elif !(defined(__FreeBSD__) && __FreeBSD__ >= 3) && !defined(darwin)
+#elif OS_NOT_FREEBSD_NOR_DARWIN
               p && (u_long) p != auto_nlist_value("tcb6")
 #else
               xig->xig_len > sizeof(struct xinpgen)
@@ -1705,39 +1902,39 @@
         ) {
         DEBUGMSGTL(("mibII/ipv6", "looping: p=%x\n", p));
 
-#if !(defined(__FreeBSD__) && __FreeBSD__ >= 3) && !defined(darwin)
-        if (!NETSNMP_KLOOKUP(p, (char *) &in6pcb, sizeof(in6pcb))) {
+#if OS_NOT_FREEBSD_NOR_DARWIN
+        if (!NETSNMP_KLOOKUP(p, (char *) &tstpcb, sizeof(tstpcb))) {
             DEBUGMSGTL(("mibII/ipv6", "klookup fail for tcb6 at %x\n",
                         p));
             found = 0;
             break;
         }
 #else
-        in6pcb = ((struct xinpcb *) xig)->xi_inp;
+        tstpcb = ((struct xinpcb *) xig)->xi_inp;
 #endif
-#if defined(__NetBSD__) && __NetBSD_Version__ >= 106250000	/*1.6Y*/
-        if (in6pcb.in6p_af != AF_INET6)
+#if OS_NET_BSD_16_OR_LATER
+        if (tstpcb.in6p_af != AF_INET6)
             goto skip;
-#elif (defined(__FreeBSD__) && __FreeBSD__ >= 3) || defined(darwin)
-        if (0 == (in6pcb.inp_vflag & INP_IPV6))
+#elif OS_FREEBSD_OR_DARWIN
+        if (0 == (tstpcb.inp_vflag & INP_IPV6))
             goto skip;
 #endif
-        if (!NETSNMP_KLOOKUP(in6pcb.in6p_ppcb, (char *) &tcpcb, sizeof(tcpcb))) {
+        if (!NETSNMP_KLOOKUP(tstpcb.inp_ppcb, (char *) &tcpcb, sizeof(tcpcb))) {
             DEBUGMSGTL(("mibII/ipv6", "klookup fail for tcb6.tcpcb at %x\n",
-                        in6pcb.in6p_ppcb));
+                        tstpcb.inp_ppcb));
             found = 0;
             break;
         }
         j = (int) vp->namelen;
         for (i = 0; i < sizeof(struct in6_addr); i++)
-            newname[j++] = in6pcb.in6p_laddr.s6_addr[i];
-        newname[j++] = ntohs(in6pcb.in6p_lport);
+            newname[j++] = tstpcb.in6p_laddr.s6_addr[i];
+        newname[j++] = ntohs(tstpcb.inp_lport);
         for (i = 0; i < sizeof(struct in6_addr); i++)
-            newname[j++] = in6pcb.in6p_faddr.s6_addr[i];
-        newname[j++] = ntohs(in6pcb.in6p_fport);
-        if (IN6_IS_ADDR_LINKLOCAL(&in6pcb.in6p_laddr))
+            newname[j++] = tstpcb.in6p_faddr.s6_addr[i];
+        newname[j++] = ntohs(tstpcb.inp_fport);
+        if (IN6_IS_ADDR_LINKLOCAL(&tstpcb.in6p_laddr))
             newname[j++] =
-                ntohs(*(uint16_t *) & in6pcb.in6p_laddr.s6_addr[2]);
+                ntohs(*(uint16_t *) & tstpcb.in6p_laddr.s6_addr[2]);
         else
             newname[j++] = 0;
         /*XXX*/ newname[j++] = mapTcpState((int)tcpcb.t_state);
@@ -1748,12 +1945,12 @@
         DEBUGMSG(("mibII/ipv6", " %d\n", exact));
 
 #if 1                           /* this is very odd but sometimes happen, and cause infinite loop */
-        if (ntohs(in6pcb.in6p_lport) == 0)
+        if (ntohs(tstpcb.inp_lport) == 0)
             goto skip;
 #endif
         result = snmp_oid_compare(name, *length, newname, j);
         if (exact && (result == 0)) {
-                memcpy(&savpcb, &in6pcb, sizeof(savpcb));
+                memcpy(&savpcb, &tstpcb, sizeof(savpcb));
                 savnameLen = j;
                 memcpy(savname, newname, j * sizeof(oid));
                 found++;
@@ -1764,7 +1961,7 @@
              */
             if ((savnameLen == 0) ||
               (snmp_oid_compare(savname, savnameLen, newname, j) > 0)) {
-                memcpy(&savpcb, &in6pcb, sizeof(savpcb));
+                memcpy(&savpcb, &tstpcb, sizeof(savpcb));
                 savnameLen = j;
                 memcpy(savname, newname, j * sizeof(oid));
                     found++;
@@ -1772,15 +1969,15 @@
         }
 
       skip:
-#if defined(__NetBSD__) && __NetBSD_Version__ >= 106250000	/*1.6Y*/
-        p = (caddr_t)in6pcb.in6p_queue.cqe_next;
-#elif !(defined(__FreeBSD__) && __FreeBSD__ >= 3) && !defined(darwin)
-        p = (caddr_t) in6pcb.in6p_next;
+#if OS_NET_BSD_16_OR_LATER
+        p = (caddr_t)tstpcb.in6p_queue.cqe_next;
+#elif OS_NOT_FREEBSD_NOR_DARWIN
+        p = (caddr_t) tstpcb.in6p_next;
 #else
         xig = (struct xinpgen *) ((char *) xig + xig->xig_len);
 #endif
     }
-#if (defined(__FreeBSD__) && __FreeBSD__ >= 3) || defined(darwin)
+#if OS_FREEBSD_OR_DARWIN
     free(sysctl_buf);
 #endif
     DEBUGMSGTL(("mibII/ipv6", "found=%d\n", found));
@@ -1788,7 +1985,7 @@
         return NULL;
     *length = savnameLen;
     memcpy((char *) name, (char *) savname, *length * sizeof(oid));
-    memcpy(&in6pcb, &savpcb, sizeof(savpcb));
+    memcpy(&tstpcb, &savpcb, sizeof(savpcb));
     *write_method = 0;
     *var_len = sizeof(long);    /* default to 'long' results */
 
@@ -1801,20 +1998,20 @@
     switch (vp->magic) {
     case IPV6TCPLOCALADDR:
         *var_len = sizeof(struct in6_addr);
-        return (u_char *) & in6pcb.in6p_laddr.s6_addr[0];
+        return (u_char *) & savpcb.in6p_laddr.s6_addr[0];
     case IPV6TCPLOCALPORT:
-        long_return = ntohs(in6pcb.in6p_lport);
+        long_return = ntohs(savpcb.inp_lport);
         return (u_char *) & long_return;
     case IPV6TCPREMOTEADDR:
         *var_len = sizeof(struct in6_addr);
-        return (u_char *) & in6pcb.in6p_faddr.s6_addr[0];
+        return (u_char *) & savpcb.in6p_faddr.s6_addr[0];
     case IPV6TCPREMOTEPORT:
-        long_return = ntohs(in6pcb.in6p_fport);
+        long_return = ntohs(savpcb.inp_fport);
         return (u_char *) & long_return;
     case IPV6TCPIFINDEX:
-        if (IN6_IS_ADDR_LINKLOCAL(&in6pcb.in6p_laddr))
+        if (IN6_IS_ADDR_LINKLOCAL(&savpcb.in6p_laddr))
             long_return =
-                ntohs(*(uint16_t *) & in6pcb.in6p_laddr.s6_addr[2]);
+                ntohs(*(uint16_t *) & savpcb.in6p_laddr.s6_addr[2]);
         else
             long_return = 0;
         /*XXX*/ return (u_char *) & long_return;
