--- agent/mibgroup/mibII/ipv6.c.orig	2009-06-10 12:53:32.000000000 +0200
+++ agent/mibgroup/mibII/ipv6.c	2009-06-10 13:06:19.000000000 +0200
@@ -233,6 +233,22 @@
     {IPV6ADDRTYPE, ASN_INTEGER, RONLY, var_ipv6AddrEntry, 3, {8, 1, 3}},
     {IPV6ADDRANYCASTFLAG, ASN_INTEGER, RONLY, var_ipv6AddrEntry, 3, {8, 1, 4}},
     {IPV6ADDRSTATUS, ASN_INTEGER, RONLY, var_ipv6AddrEntry, 3, {8, 1, 5}},
+    
+    // ROUTE
+    {IPV6ROUTEDEST, ASN_OCTET_STR, RONLY, var_ipv6RouteEntry, 3, {11, 1, 1}},
+    {IPV6ROUTEPFXLENGTH, ASN_INTEGER, RONLY, var_ipv6RouteEntry, 3, {11, 1, 2}},
+    //{IPV6ROUTEINDEX, ASN_UNSIGNED, RONLY, var_ipv6RouteEntry, 3, {11, 1, 3}},
+    {IPV6ROUTEIFINDEX, ASN_INTEGER, RONLY, var_ipv6RouteEntry, 3, {11, 1, 4}},
+    {IPV6ROUTENEXTHOP, ASN_OCTET_STR, RONLY, var_ipv6RouteEntry, 3, {11, 1, 5}},
+    {IPV6ROUTETYPE, ASN_INTEGER, RONLY, var_ipv6RouteEntry, 3, {11, 1, 6}},
+    {IPV6ROUTEPROTOCOL, ASN_INTEGER, RONLY, var_ipv6RouteEntry, 3, {11, 1, 7}},
+    {IPV6ROUTEPOLICY, ASN_INTEGER, RONLY, var_ipv6RouteEntry, 3, {11, 1, 8}},
+    {IPV6ROUTEAGE, ASN_UNSIGNED, RONLY, var_ipv6RouteEntry, 3, {11, 1, 9}},
+    {IPV6ROUTENEXTHOPRDI, ASN_UNSIGNED, RONLY, var_ipv6RouteEntry, 3, {11, 1, 10}},
+    {IPV6ROUTEMETRIC, ASN_UNSIGNED, RONLY, var_ipv6RouteEntry, 3, {11, 1, 11}},
+    {IPV6ROUTEWEIGHT, ASN_UNSIGNED, RONLY, var_ipv6RouteEntry, 3, {11, 1, 12}}, 
+    {IPV6ROUTEINFO, ASN_OBJECT_ID, RONLY, var_ipv6RouteEntry, 3, {11, 1, 13}},
+    {IPV6ROUTEVALID, ASN_INTEGER, RONLY, var_ipv6RouteEntry, 3, {11, 1, 14}},
 
 #if 0
     {IPV6ADDRPREFIXONLINKFLG, INTEGER, RONLY, var_ipv6AddrEntry, 3,
@@ -759,6 +775,14 @@
 static struct ifaddrs *ifap = 0;
 static u_int ipv6_count = 0;
 
+static struct rt_msghdr* rts = 0;
+static u_int rt_size = 0;
+static u_int rt_count = 0;
+
+static struct in6_addrpolicy* rt_policies = 0;
+static size_t rt_policies_count = 0;
+static struct in6_addrpolicy* rt_default_policy = 0;
+
 static void get_ipv6_addresses() {
   struct ifaddrs *ifa;
 
@@ -818,6 +842,112 @@
   return (plen);
 }
 
+static void get_ipv6_routes() {
+  size_t needed;
+  int mib[6];
+  char *buff, *next, *lim;
+  struct rt_msghdr *rtm;
+  
+  if (rts) {
+    free(rts);
+    rts = 0;
+    rt_count = rt_size = 0;
+  }
+
+  mib[0] = CTL_NET;
+  mib[1] = PF_ROUTE;
+  mib[2] = 0;          // protocol number ( always 0 )
+  mib[3] = AF_INET6;   // address family
+  mib[4] = NET_RT_DUMP; 
+  mib[5] = 0;          // Always 0 with NET_RT_DUMP
+
+  if (sysctl(mib, 6, NULL, &needed, NULL, 0) < 0) {
+    perror("sysctl: net.route.0.0.dump estimate");
+    return;
+  }
+  
+  if ((buff = malloc(needed)) == 0) {
+    perror("malloc buffer");
+    return;
+  }
+  if (sysctl(mib, 6, buff, &needed, NULL, 0) < 0) {
+    perror("sysctl: net.route.0.0.dump");
+    return;
+  }
+  lim  = buff + needed;
+  rts = (struct rt_msghdr*) buff;
+  rt_size = needed;
+  
+  for (next = buff; next < lim; next += rtm->rtm_msglen, ++rt_count) {
+    rtm = (struct rt_msghdr*) next;
+  }
+}
+
+static struct rt_msghdr* get_ipv6_route_at_index(u_int idx) {
+  char* buff = (char*) rts;
+  char* next, *lim;
+  struct rt_msghdr* rtm;
+  u_int count = 0;
+  
+  if ( (!rts) || (rt_count < idx) ) {
+    if (rts == 0)
+      printf("Route not initialized\n");
+    else if ( rt_count < idx )
+      printf("Index too big (%u)\n", idx);
+    else
+      printf("Unknown error\n");
+    return NULL;
+  }
+  lim  = buff + rt_size;
+  
+  for (next = buff; next < lim; next += rtm->rtm_msglen, ++count) {
+    rtm = (struct rt_msghdr*) next;
+    if (count == idx)
+      return rtm;
+  }
+  printf("ROUTE NOT FOUND AT INDEX %u\n", idx);
+  return NULL;
+}
+
+static void get_ipv6_policies() {
+  int mib[] = { CTL_NET, PF_INET6, IPPROTO_IPV6, IPV6CTL_ADDRCTLPOLICY };
+  size_t l;
+  char *buf;
+  struct in6_addrpolicy *pol;
+  char str6[INET6_ADDRSTRLEN];
+  int i;
+   
+  if (rt_policies) {
+    free(rt_policies);
+    rt_policies_count = 0;
+    rt_default_policy = 0;
+  }
+ 
+  if (sysctl(mib, sizeof(mib) / sizeof(mib[0]), NULL, &l, NULL, 0) < 0) {
+    perror("sysctl(IPV6CTL_ADDRCTLWEIGHT)");
+  }
+  if (l == 0) {
+    return;
+  }
+  if ((buf = malloc(l)) == NULL) {
+    perror("malloc failed");
+  }
+  if (sysctl(mib, sizeof(mib) / sizeof(mib[0]), buf, &l, NULL, 0) < 0) {
+    perror("sysctl(IPV6CTL_ADDRCTLWEIGHT)");
+  }
+  
+  rt_policies_count = l/sizeof(struct in6_addrpolicy);
+  rt_policies = (struct in6_addrpolicy*) buf;
+  
+  for(i = 0; i < rt_policies_count; ++i) {
+    pol = rt_policies + i;
+    if ( IN6_ARE_ADDR_EQUAL( &pol->addr.sin6_addr , &in6addr_any ) ) {
+      rt_default_policy = pol;
+      break;
+    }
+  }
+}
+
 u_char         *
 var_ipv6AddrEntry(register struct variable * vp,
          oid * name,
@@ -917,8 +1047,194 @@
   }
   return NULL;
 }
+
+#define ROUNDUP(a)							\
+  ((a) > 0 ? (1 + (((a) - 1) | (sizeof(long) - 1))) : sizeof(long))
+
+u_char* var_ipv6RouteEntry(register struct variable * vp,
+			  oid * name,
+			  size_t * length,
+			  int exact, size_t * var_len, WriteMethod ** write_method)
+{
+  u_int i;
+  int header = MATCH_FAILED;
+  oid newname[MAX_OID_LEN];
+  int result;
+  struct rt_msghdr* rt = 0;
+  struct sockaddr_in6 *dest, *gate, *netmask;
+  char* offset = 0;
+  
+  dest = gate = netmask = 0;
+
+  get_ipv6_routes();
+
+  memcpy((char *) newname, (char *) vp->name, (int) vp->namelen * sizeof(oid));
+  for (i = 0; i < rt_count; ++i) {
+    newname[(int) vp->namelen] = i;
+    result = snmp_oid_compare(name, *length, newname, (int) vp->namelen + 1);
+    if ((exact && result == 0) || (!exact && result < 0)){
+      header = MATCH_SUCCEEDED;
+      rt = get_ipv6_route_at_index(i);
+      if (rt) {
+	offset = (char*) (rt + 1);
+	// DEST
+	if (rt->rtm_addrs & RTA_DST) {
+	  dest = (struct sockaddr_in6*)(offset);
+	  offset += ROUNDUP(dest->sin6_len);
+	}
+  
+	// GATEWAY
+	if (rt->rtm_addrs & RTA_GATEWAY) {
+	  gate = (struct sockaddr_in6*) (offset);
+	  offset += ROUNDUP(gate->sin6_len);
+	}
+
+	// NETMASK
+	if (rt->rtm_addrs & RTA_NETMASK) {
+	  netmask = (struct sockaddr_in6*)(offset);
+	  offset += ROUNDUP(netmask->sin6_len);
+	}
+  
+
+      } else
+	return NULL;
+      break;
+    }
+  }
+
+  if (header) // Not on a Leaf
+    return NULL;
+  else {
+    memcpy((char *) name, (char *) newname,
+           ((int) vp->namelen + 1) * sizeof(oid));
+    *length = vp->namelen + 1;
+    *write_method = 0;
+  }
+
+  
+  *var_len = sizeof(long_return);
+  switch (vp->magic) {
+  case IPV6ROUTEDEST:
+    *var_len = 16;
+    if (dest)
+      return (u_char*) (dest->sin6_addr.s6_addr);
+    else {
+      memset(return_buf, 0, sizeof(struct in6_addr) );
+      return (u_char *) &return_buf;
+    }
+    break;
+
+  case IPV6ROUTEPFXLENGTH:
+    *var_len = sizeof(long_return);
+    if (netmask) {
+      long_return = prefix(&netmask->sin6_addr, sizeof(struct in6_addr));
+    } else {
+      long_return = 128;
+    }
+    return (u_char*) &long_return;
+    break;
+
+  case IPV6ROUTEIFINDEX:
+    long_return = rt->rtm_index;
+    return (u_char *) &long_return;
+    break;
+
+  case IPV6ROUTENEXTHOP:
+    *var_len = 16;
+    if ( (rt->rtm_addrs & RTA_GATEWAY) && (gate->sin6_family == AF_INET6) ) {
+      return (u_char*) (gate->sin6_addr.s6_addr);
+    } else {
+      memset(return_buf, 0, sizeof(struct in6_addr) );
+      return (u_char *) return_buf;
+    }
+    break;
+    
+  case IPV6ROUTETYPE:
+    if (rt->rtm_flags & RTF_BLACKHOLE)
+      long_return = 2;
+    else if (rt->rtm_flags & RTF_LOCAL)
+      long_return = 3;
+    else if ( (rt->rtm_flags & RTF_BROADCAST) || (rt->rtm_flags & RTF_MULTICAST) )
+      long_return = 4;
+    else 
+      long_return = 1;
+    return (u_char *) &long_return;
+    break;
+    
+  case IPV6ROUTEPROTOCOL:
+    if (rt->rtm_flags & RTF_STATIC)
+      long_return = 3;
+    else if (rt->rtm_flags & RTF_LLINFO)
+      long_return = 4;
+    else
+      long_return = 1;
+    return (u_char *) &long_return;
+    break;
+
+  case IPV6ROUTEPOLICY:
+  case IPV6ROUTEWEIGHT:
+    get_ipv6_policies();
+    if (rt_default_policy == 0 || rt_policies == 0)
+      return NULL;
+    if ( !dest || !gate ) {
+      long_return = rt_default_policy->preced;
+      return (u_char *) &long_return;
+    } else {
+      int i;
+      struct in6_addrpolicy* pol;
+      
+      char str6[INET6_ADDRSTRLEN];
+      inet_ntop(AF_INET6, &(dest->sin6_addr), str6, INET6_ADDRSTRLEN);
+      
+      for(i = 0; i < rt_policies_count; ++i){
+	pol = rt_policies + i;
+	if ( IN6_ARE_ADDR_EQUAL(&dest->sin6_addr, &pol->addr.sin6_addr) ) {
+	  long_return = pol->preced;
+	  return (u_char *) &long_return;
+	}
+      }
+      // No route found -> use default route
+      long_return = rt_default_policy->preced;
+      return (u_char *) &long_return;
+    }
+    break;
+
+  case IPV6ROUTEAGE:
+    long_return = rt->rtm_rmx.rmx_expire;
+    return (u_char *) &long_return;
+    break;
+
+  case IPV6ROUTENEXTHOPRDI:
+    long_return = 0;
+    return (u_char *) &long_return;
+    break;
+    
+  case IPV6ROUTEMETRIC:
+    long_return = 4294967295;
+    return (u_char *) &long_return;
+    break;
+   
+  case IPV6ROUTEINFO:
+    memset(return_buf, 0, 2 * sizeof(u_int) );
+      return (u_char *) return_buf;
+      break;
+
+  case IPV6ROUTEVALID:
+    if (rt->rtm_addrs & RTF_UP)
+      long_return = 1;
+    else 
+      long_return = 0;
+    return (u_char*) &long_return;
+    break;
+ 
+  default:
+    return NULL;
+    break;
+  }
+}
 #endif
 
+
 u_char         *
 var_ifv6Entry(register struct variable * vp,
               oid * name,
