/*
 * Note: this file originally auto-generated by mib2c using
 *       version : 12088 $ of $ 
 *
 * $Id:$
 */
/* standard Net-SNMP includes */
#include <net-snmp/net-snmp-config.h>
#include <net-snmp/net-snmp-includes.h>
#include <net-snmp/agent/net-snmp-agent-includes.h>

/* include our parent header */
#include "simpleTable.h"


/** @defgroup data_get data_get: Routines to get data
 *
 * TODO:230:M: Implement simpleTable get routines.
 * TODO:240:M: Implement simpleTable mapping routines (if any).
 *
 * These routine are used to get the value for individual objects. The
 * row context is passed, along with a pointer to the memory where the
 * value should be copied.
 *
 * @{
 */
/**********************************************************************
 **********************************************************************
 ***
 *** Table simpleTable
 ***
 **********************************************************************
 **********************************************************************/
/*
 * SIMPLE-TABLE-MIB::simpleTable is subid 1 of simpleTableExample.
 * Its status is Current.
 * OID: .1.3.6.1.4.1.8072.9999.9999.111.1, length: 11
*/

/* ---------------------------------------------------------------------
 * TODO:200:r: Implement simpleTable data context functions.
 */


/**
 * set mib index(es)
 *
 * @param tbl_idx mib index structure
 * @param devNumber_val
 *
 * @retval MFD_SUCCESS     : success.
 * @retval MFD_ERROR       : other error.
 *
 * @remark
 *  This convenience function is useful for setting all the MIB index
 *  components with a single function call. It is assume that the C values
 *  have already been mapped from their native/rawformat to the MIB format.
 */
int
simpleTable_indexes_set_tbl_idx(simpleTable_mib_index *tbl_idx, u_long devNumber_val)
{
    DEBUGMSGTL(("verbose:simpleTable:simpleTable_indexes_set_tbl_idx","called\n"));

    /* devNumber(1)/UNSIGNED32/ASN_UNSIGNED/u_long(u_long)//l/a/w/e/r/d/h */
    tbl_idx->devNumber = devNumber_val;
    

    return MFD_SUCCESS;
} /* simpleTable_indexes_set_tbl_idx */

/**
 * @internal
 * set row context indexes
 *
 * @param reqreq_ctx the row context that needs updated indexes
 *
 * @retval MFD_SUCCESS     : success.
 * @retval MFD_ERROR       : other error.
 *
 * @remark
 *  This function sets the mib indexs, then updates the oid indexs
 *  from the mib index.
 */
int
simpleTable_indexes_set(simpleTable_rowreq_ctx *rowreq_ctx, u_long devNumber_val)
{
    DEBUGMSGTL(("verbose:simpleTable:simpleTable_indexes_set","called\n"));

    if(MFD_SUCCESS != simpleTable_indexes_set_tbl_idx(&rowreq_ctx->tbl_idx
                                   , devNumber_val
           ))
        return MFD_ERROR;

    /*
     * convert mib index to oid index
     */
    rowreq_ctx->oid_idx.len = sizeof(rowreq_ctx->oid_tmp) / sizeof(oid);
    if(0 != simpleTable_index_to_oid(&rowreq_ctx->oid_idx,
                                    &rowreq_ctx->tbl_idx)) {
        return MFD_ERROR;
    }

    return MFD_SUCCESS;
} /* simpleTable_indexes_set */


/*---------------------------------------------------------------------
 * SIMPLE-TABLE-MIB::simpleTableEntry.blocksRead
 * blocksRead is subid 2 of simpleTableEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.4.1.8072.9999.9999.111.1.1.2
 * Description:
The number of blocks read for the device.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   0
 *
 *
 * Its syntax is UNSIGNED32 (based on perltype UNSIGNED32)
 * The net-snmp type is ASN_UNSIGNED. The C type decl is u_long (u_long)
 */
/**
 * Extract the current value of the blocksRead data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param blocksRead_val_ptr
 *        Pointer to storage for a u_long variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
blocksRead_get( simpleTable_rowreq_ctx *rowreq_ctx, u_long * blocksRead_val_ptr )
{
   /** we should have a non-NULL pointer */
   netsnmp_assert( NULL != blocksRead_val_ptr );


    DEBUGMSGTL(("verbose:simpleTable:blocksRead_get","called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

/*
 * TODO:231:o: |-> Extract the current value of the blocksRead data.
 * copy (* blocksRead_val_ptr ) from rowreq_ctx->data
 */
    (* blocksRead_val_ptr ) = rowreq_ctx->data.blocksRead;

    return MFD_SUCCESS;
} /* blocksRead_get */

/*---------------------------------------------------------------------
 * SIMPLE-TABLE-MIB::simpleTableEntry.blocksWritten
 * blocksWritten is subid 3 of simpleTableEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.4.1.8072.9999.9999.111.1.1.3
 * Description:
The number of blocks written for the device.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   0
 *
 *
 * Its syntax is UNSIGNED32 (based on perltype UNSIGNED32)
 * The net-snmp type is ASN_UNSIGNED. The C type decl is u_long (u_long)
 */
/**
 * Extract the current value of the blocksWritten data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param blocksWritten_val_ptr
 *        Pointer to storage for a u_long variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
blocksWritten_get( simpleTable_rowreq_ctx *rowreq_ctx, u_long * blocksWritten_val_ptr )
{
   /** we should have a non-NULL pointer */
   netsnmp_assert( NULL != blocksWritten_val_ptr );


    DEBUGMSGTL(("verbose:simpleTable:blocksWritten_get","called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

/*
 * TODO:231:o: |-> Extract the current value of the blocksWritten data.
 * copy (* blocksWritten_val_ptr ) from rowreq_ctx->data
 */
    (* blocksWritten_val_ptr ) = rowreq_ctx->data.blocksWritten;

    return MFD_SUCCESS;
} /* blocksWritten_get */



/** @} */
