#include <sys/socket.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <linux/sctp.h>
#include <arpa/inet.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>
#include <netdb.h>

#define BUF_SIZE 4000

char *key_text = NULL;

int sctp_set_auth_key(int fd, sctp_assoc_t assoc_id, uint16_t keyid,
                      uint16_t keylen, uint8_t *keytext) {
        socklen_t len;
        struct sctp_authkey *akey;
        int result;

        len = sizeof(*akey) + keylen;
        akey = (struct sctp_authkey *)alloca(len);
        if (akey == NULL) {
                printf("could not get memory for akey\n");
                return (-1);
        }
        akey->sca_assoc_id = assoc_id;
        akey->sca_keynumber = keyid;
        akey->sca_keylength = keylen;
        bcopy(keytext, akey->sca_key, keylen);
        result = setsockopt(fd, IPPROTO_SCTP, SCTP_AUTH_KEY, akey, len);
        return (result);
}

int sctp_set_active_key(int fd, sctp_assoc_t assoc_id, uint16_t keyid) {
        socklen_t len;
        struct sctp_authkeyid akey;
        int result;

        len = sizeof(akey);
        akey.scact_assoc_id = assoc_id;
        akey.scact_keynumber = keyid;
        result = setsockopt(fd, IPPROTO_SCTP, SCTP_AUTH_ACTIVE_KEY,
                            &akey, len);
        return (result);
}

int sctp_set_auth_chunk_id(int fd, uint8_t chk)
{
        int result;
        socklen_t len;
        struct sctp_authchunk ch;

        len = sizeof(ch);
        ch.sauth_chunk = chk;
        result = setsockopt(fd, IPPROTO_SCTP, SCTP_AUTH_CHUNK,
                            &ch, len);
        return(result);

}

static int sn_do_setup_frag_interleave(int fd)
{
	int param, param_len;

	param = 1;
	param_len = sizeof(param);
	if (setsockopt(fd, IPPROTO_SCTP, SCTP_FRAGMENT_INTERLEAVE,
		       &param, sizeof(param))) {
		perror("setsockopt");
		exit(-1);
	}

	return 0;
}

static int sn_do_setup_strm_interleave(int fd)
{
	struct sctp_assoc_value param;

	param.assoc_id = 0;
	param.assoc_value = sizeof(param);

	if (setsockopt(fd, IPPROTO_SCTP, SCTP_INTERLEAVING_SUPPORTED,
		       &param, sizeof(param))) {
		perror("setsockopt");
	}

	return 0;
}


int main(int argc, char **argv)
{
	struct msghdr message;
	struct iovec iov[1];
	struct addrinfo *res;
	char content[BUF_SIZE];
	uint16_t keyid, keylen;
	int fd, chk = 0x40;

	if (argc != 3) {
		printf("Usage: %s remote_ip6_addr remote_port\n", argv[0]);
		return -1;
	}

	if (getaddrinfo(argv[1], argv[2], NULL, &res) != 0) {
		printf("getaddrinfo: address failed [%s]\n", strerror(errno));
		return -1;
	}

	/* open a SCTP4/6 socket */
	fd = socket(res->ai_family, SOCK_SEQPACKET, IPPROTO_SCTP);
	if (fd == -1) {
		printf("socket failed [%s]\n", strerror(errno));
		return -1;
	}
	printf("Created a socket with fd: %d\n", fd);

	sn_do_setup_frag_interleave(fd);
	sn_do_setup_strm_interleave(fd);

	key_text = "AUTHKEY1";
	keylen = strlen(key_text);
	keyid = 0;
	if (sctp_set_auth_key(fd, 0, keyid, keylen, (uint8_t *)key_text) != 0 ) {
		printf("Set Auth Key:%s error\n", key_text);
		return(1);
	}

	if (sctp_set_active_key(fd, 0, 0) != 0) {
		printf("set active key error\n");
		return(1);
	}

	if (sctp_set_auth_chunk_id(fd, chk) != 0) {
		printf("Set Auth Chunk:%u error\n", chk);
		return(1);
	}

	memset(content, 'A', sizeof(content));
	memset(&message, 0, sizeof(message));
	iov[0].iov_base = content;
	iov[0].iov_len = 1000;

	message.msg_name = res->ai_addr;
	message.msg_namelen = res->ai_addrlen;
	message.msg_iov = iov;
	message.msg_iovlen = 1;
	message.msg_control = 0;
	message.msg_controllen = 0;

	if (sendmsg(fd, &message, 0)==-1) {
		printf("sendmsg failed [%s]\n", strerror(errno));
		return -1;
	}

	close(fd);
	return 0;
}
