#! /usr/bin/python

from scapy.layers.sctp import _SCTPChunkGuessPayload
from scapy.layers.sctp import sctpchunkparamtypescls
from scapy.layers.sctp import sctpchunkparamtypes
from scapy.layers.sctp import _SCTPChunkParam
import sys, getopt, time, commands
from random import randint
from scapy.all import *


# Chunks or Params Class for scpay ext
sctpchunkparamtypescls[32776] = "SCTPParamSupport"
sctpchunkparamtypes[32776] = "support"

class SCTPParamSupport(_SCTPChunkGuessPayload, Packet):
	fields_desc = [ ShortEnumField("type", 32776, sctpchunkparamtypes),
			FieldLenField("len", None, length_of="types", adjust = lambda pkt,x:x+4),
			PadField(FieldListField("types", [], XByteField("type", None), count_from=lambda pkt:(pkt.len-8)/4),
				     4, padwith="\x00"),
			]

class SCTPChunkParamStreamInfo(_SCTPChunkParam, Packet):
    fields_desc = [ShortField("sid",   None),
                   ShortField("flags", None),
                   XIntField("mid",    None), ]

class SCTPChunkIFtsn(_SCTPChunkGuessPayload, Packet):
    fields_desc = [ ByteEnumField("type", 194, sctpchunktypes),
                    ByteField("flags", None),
                    FieldLenField("len", None, length_of="params", adjust = lambda pkt,x:x+8),
                    XIntField("new_ctsn", None),
                    ChunkParamField("params", None, length_from=lambda pkt:pkt.len-8)
                    ]

class SCTPChunkIData(_SCTPChunkGuessPayload, Packet):
    fields_desc = [ ByteEnumField("type", 64, sctpchunktypes),
                    BitField("reserved", None, 4),
                    BitField("delay_sack", 0, 1),
                    BitField("unordered", 0, 1),
                    BitField("beginning", 0, 1),
                    BitField("ending", 0, 1),
                    FieldLenField("len", None, length_of="data", adjust = lambda pkt,x:x+20),
                    XIntField("tsn", None),
                    XShortField("sid", None),
                    XShortField("reserved", None),
                    XIntField("mid", None),
                    XIntField("fsn", None),
                    PadField(StrLenField("data", None, length_from=lambda pkt: pkt.len-20),
                             4, padwith="\x00"),
                    ]

# Test Classs
class SctpStreamInterleaveTest():
	def __init__(self):
		self._tsn = 2017
		self._cnt = 15

		self._ip = None
		self._sctp = None
		self._header = None

	def set_addrs(self, target, local):
		self._target = target
		self._local = local
		return True

	# 4-shake hands connection
	def start_idata(self, target, local):
		target_host, target_port = target
		local_host,  local_port  = local
	
		# init snd
		SCTP_HEADER = (IP(dst=target_host, flags="DF") / SCTP(sport=local_port, dport=target_port, tag=0))
		INIT = (SCTP_HEADER / SCTPChunkInit(init_tag=1, a_rwnd=106496, n_out_streams=self._cnt, n_in_streams=self._cnt, init_tsn=self._tsn,
						    params=[SCTPParamSupport(types=[64]), SCTPChunkParamFwdTSN()]))
		INIT_ACK = sr1(INIT, timeout=3, verbose=0)
		if INIT_ACK == None or not INIT_ACK.haslayer(SCTPChunkInitAck):
			return False
	
		# cookie echo snd
		SCTP_HEADER[SCTP].tag = INIT_ACK[SCTPChunkInitAck].init_tag
		COOKIE_ECHO = (SCTP_HEADER / SCTPChunkCookieEcho(cookie=INIT_ACK[SCTPChunkParamStateCookie].cookie))
		COOKIE_ACK = sr1(COOKIE_ECHO, timeout=3, verbose=0)
		if COOKIE_ACK == None or not COOKIE_ACK.haslayer(SCTPChunkCookieAck):
			return False
	
		self._ip = SCTP_HEADER[IP]
		self._sctp = SCTP_HEADER[SCTP]
		self._header = SCTP_HEADER
		return True

	def start_data(self, target, local):
		target_host, target_port = target
		local_host,  local_port  = local
	
		# init snd
		SCTP_HEADER = (IP(dst=target_host, flags="DF") / SCTP(sport=local_port, dport=target_port, tag=0))
		INIT = (SCTP_HEADER / SCTPChunkInit(init_tag=1, a_rwnd=106496, n_out_streams=self._cnt, n_in_streams=self._cnt, init_tsn=self._tsn,
						    params=[SCTPChunkParamFwdTSN()]))
		INIT_ACK = sr1(INIT, timeout=3, verbose=0)
		if INIT_ACK == None or not INIT_ACK.haslayer(SCTPChunkInitAck):
			return False
	
		# cookie echo snd
		SCTP_HEADER[SCTP].tag = INIT_ACK[SCTPChunkInitAck].init_tag
		COOKIE_ECHO = (SCTP_HEADER / SCTPChunkCookieEcho(cookie=INIT_ACK[SCTPChunkParamStateCookie].cookie))
		COOKIE_ACK = sr1(COOKIE_ECHO, timeout=3, verbose=0)
		if COOKIE_ACK == None or not COOKIE_ACK.haslayer(SCTPChunkCookieAck):
			return False
	
		self._ip = SCTP_HEADER[IP]
		self._sctp = SCTP_HEADER[SCTP]
		self._header = SCTP_HEADER
		return True

	def stop(self):
		if self._header is None:
			return True
		ABORT = (self._header / SCTPChunkAbort())
		send(ABORT, verbose=0)


	# 3 types of chunks used in tests
	def send_iftsn(self, ntsn, ss):
		strinfo = []
		for s in ss:
			strinfo.append(SCTPChunkParamStreamInfo(sid=s[0], flags=s[2], mid=s[1]))
		IFTSN = (self._header / SCTPChunkIFtsn(new_ctsn = ntsn, params=strinfo))
		send(IFTSN, verbose=0)
		pass

	def send_idata(self, tsn, sid, mid, fsn, b, e, length, unordered=0):
		IDATA = (self._header / SCTPChunkIData(tsn = tsn, sid = sid, mid = mid, fsn = fsn, beginning = b, ending = e, data = "x" * length, unordered=unordered))
		send(IDATA, verbose=0)
		pass

	def send_data(self, tsn, sid, ssn, fsn, b, e, length):
		DATA = (self._header / SCTPChunkData(tsn = tsn, stream_id = sid, stream_seq = ssn, beginning = b, ending = e, data = "x" * length))
		send(DATA, verbose=0)
		pass

	# Test result check wth the 3 queue length
	def check(self, cmd, reasm_uo = None, reasm = None, lobby = None):
		time.sleep(2)
		if cmd == 1:
			ssh = "ip netns exec st-s"
			#ssh="ssh -o StrictHostKeyChecking=no -q "+self._target[0]
			commands.getoutput(ssh+" dmesg -C")
			commands.getoutput(ssh+" cat /proc/net/sctp/assocs")
			rets = commands.getoutput(ssh+" dmesg |grep reasm_uo")
			ret_list = rets.split("reasm_uo")[1].split(" ")
			if reasm_uo is not None and reasm_uo != int(ret_list[1]):
				print " == FAIL: reasm_uo "+ret_list[1]+" expected "+str(reasm_uo)
				return False
			if reasm is not None and reasm != int(ret_list[3]):
				print " == FAIL: reasm "+ret_list[3]+" expected "+str(reasm)
				return False
			if lobby is not None and lobby != int(ret_list[5]):
				print " == FAIL: lobby "+ret_list[5]+" expected "+str(lobby)
				return False
			print " -> PASS"
			return True
		else:
			print " -> PASS"
			return True


	# Test Cases
	def test_a1(self):
		# i-sock - data, got abort
		self.start_idata(self._target, self._local)
		self.send_data(self._tsn , 0, 0, 0, 1, 1, 1000)
		self.check(2)
		self.stop()
		return True

	def test_a2(self):
		# sock - idata, got abort
		self.start_data(self._target, self._local)
		self.send_idata(self._tsn , 0, 1, 0, 1, 1, 1000)
		self.check(2)
		self.stop()
		return True

	def test_a3(self):
		# isock - idata - wrong mid, got abort
		self.start_idata(self._target, self._local)
		self.send_idata(self._tsn ,   0, 0, 0, 1, 1, 1000)
		self.send_idata(self._tsn+1 , 0, 1, 0, 1, 1, 1000)
		self.send_idata(self._tsn+2 , 0, 2, 0, 1, 1, 1000)
		self.send_idata(self._tsn+3 , 0, 0, 0, 1, 1, 1000) # <--- mid = 0
		self.check(2)
		self.stop()
		return True

	def test_b1(self):
		# isock - idata - serial fsn, got assembled
		self.start_idata(self._target, self._local)
		self.send_idata(self._tsn+2, 0, 2, 0, 0, 0, 100)
		self.send_idata(self._tsn+3, 0, 2, 1, 0, 0, 100)
		self.send_idata(self._tsn+4, 0, 2, 2, 0, 0, 100)
		self.send_idata(self._tsn+5, 0, 1, 0, 0, 0, 100)
		self.send_idata(self._tsn+6, 0, 1, 1, 0, 0, 100)
		self.send_idata(self._tsn+7, 0, 1, 2, 0, 0, 100)
		self.check(1, 0, 6, 0) # <---- 6 reassem queue
		self.send_idata(self._tsn  , 0, 2, 0, 1, 0, 100)
		self.send_idata(self._tsn+1, 0, 1, 0, 1, 0, 100)
		self.check(1, 0, 8, 0) # <---- 8 reassem queue
		self.send_idata(self._tsn+8, 0, 2, 3, 0, 1, 100)
		self.send_idata(self._tsn+9, 0, 1, 3, 0, 1, 100)
		self.check(1, 0, 0, 2) # <---- 0 reassem queue, 2 lobby
		self.stop()
		return True

	def test_b2(self):
		# isock - idata - serial fsn, got assem pd
		self.start_idata(self._target, self._local)
		self.send_idata(self._tsn+2, 0, 1, 0, 0, 0, 300)
		self.send_idata(self._tsn+3, 0, 1, 1, 0, 0, 300)
		self.send_idata(self._tsn+4, 0, 1, 2, 0, 0, 300)

		self.send_idata(self._tsn+5, 0, 0, 0, 0, 0, 300)
		self.send_idata(self._tsn+6, 0, 0, 1, 0, 0, 300)
		self.send_idata(self._tsn+7, 0, 0, 2, 0, 0, 300)
		self.check(1, 0, 6, 0) # <---- 6 reassem queue
		self.send_idata(self._tsn  , 0, 1, 0, 1, 0, 300)
		self.send_idata(self._tsn+1, 0, 0, 0, 1, 0, 300)
		self.check(1, 0, 4, 0) # <---- 1 reassem queue, 0 lobby
		self.send_idata(self._tsn+8, 0, 1, 3, 0, 1, 300)
		self.check(1, 0, 0, 1) # <---- 0 reassem queue, 1 lobby
		self.send_idata(self._tsn+9, 0, 0, 3, 0, 1, 300)
		self.check(1, 0, 0, 0) # <---- 0 reassem queue, 0 lobby
		self.stop()
		return True

	def test_b3(self):
		# isock - idata - serial fsn, not got assem pd
		self.start_idata(self._target, self._local)
		self.send_idata(self._tsn+2, 0, 1, 0, 0, 0, 100)
		self.send_idata(self._tsn+3, 0, 1, 1, 0, 0, 100)
		self.send_idata(self._tsn+4, 0, 1, 2, 0, 0, 100)
		self.send_idata(self._tsn+5, 0, 0, 0, 0, 0, 100)
		self.send_idata(self._tsn+6, 0, 0, 1, 0, 0, 100)
		self.send_idata(self._tsn+7, 0, 0, 2, 0, 0, 100)
		self.check(1, 0, 6, 0) # <---- 6 reassem queue
		self.send_idata(self._tsn  , 0, 1, 0, 1, 0, 100)
		self.send_idata(self._tsn+1, 0, 0, 0, 1, 0, 100)
		self.check(1, 0, 8, 0) # <---- 8 reassem queue, 0 lobby
		self.send_idata(self._tsn+8, 0, 1, 3, 0, 1, 100)
		self.check(1, 0, 4, 1) # <---- 4 reassem queue, 1 lobby
		self.send_idata(self._tsn+9, 0, 0, 3, 0, 1, 100)
		self.check(1, 0, 0, 0) # <---- 0 reassem queue, 0 lobby
		self.stop()
		return True

	def test_c1(self):
		# isock - idata - serial fsn, got assembled un
		self.start_idata(self._target, self._local)
		self.send_idata(self._tsn+2, 0, 2, 0, 0, 0, 100, 1)
		self.send_idata(self._tsn+3, 0, 2, 1, 0, 0, 100, 1)
		self.send_idata(self._tsn+4, 0, 2, 2, 0, 0, 100, 1)
		self.send_idata(self._tsn+5, 0, 1, 0, 0, 0, 100, 1)
		self.send_idata(self._tsn+6, 0, 1, 1, 0, 0, 100, 1)
		self.send_idata(self._tsn+7, 0, 1, 2, 0, 0, 100, 1)
		self.check(1, 6, 0, 0) # <---- 6 reassem queue
		self.send_idata(self._tsn  , 0, 2, 0, 1, 0, 100, 1)
		self.send_idata(self._tsn+1, 0, 1, 0, 1, 0, 100, 1)
		self.check(1, 8, 0, 0) # <---- 8 reassem queue
		self.send_idata(self._tsn+8, 0, 2, 3, 0, 1, 100, 1)
		self.check(1, 4, 0, 0) # <---- 4 reassem queue
		self.send_idata(self._tsn+9, 0, 1, 3, 0, 1, 100, 1)
		self.check(1, 0, 0, 0) # <---- 0 reassem queue, 0 lobby
		self.stop()
		return True

	def test_c2(self):
		# isock - idata - serial fsn, got assem pd
		self.start_idata(self._target, self._local)
		self.send_idata(self._tsn+2, 0, 1, 0, 0, 0, 300, 1)
		self.send_idata(self._tsn+3, 0, 1, 1, 0, 0, 300, 1)
		self.send_idata(self._tsn+4, 0, 1, 2, 0, 0, 300, 1)
		self.send_idata(self._tsn+5, 0, 0, 0, 0, 0, 300, 1)
		self.send_idata(self._tsn+6, 0, 0, 1, 0, 0, 300, 1)
		self.send_idata(self._tsn+7, 0, 0, 2, 0, 0, 300, 1)
		self.check(1, 6, 0, 0) # <---- 6 reassem queue
		self.send_idata(self._tsn  , 0, 1, 0, 1, 0, 300, 1)
		self.send_idata(self._tsn+1, 0, 0, 0, 1, 0, 300, 1)
		self.check(1, 4, 0, 0) # <---- 4 reassem queue, 0 lobby
		self.send_idata(self._tsn+8, 0, 1, 3, 0, 1, 300, 1)
		self.check(1, 4, 0, 0) # <---- 4 reassem queue, 0 lobby
		self.send_idata(self._tsn+9, 0, 0, 3, 0, 1, 300, 1)
		self.check(1, 0, 0, 0) # <---- 0 reassem queue, 0 lobby
		self.stop()
		return True

	def test_d1(self):
		# isock - idata - serial fsn, got assem pd
		self.start_idata(self._target, self._local)
		self.send_idata(self._tsn+2, 0, 1, 0, 0, 0, 300)
		self.send_idata(self._tsn+3, 0, 1, 1, 0, 0, 300)
		self.send_idata(self._tsn+4, 0, 1, 2, 0, 0, 300)
		self.send_idata(self._tsn+5, 0, 0, 0, 0, 0, 300)
		self.send_idata(self._tsn+6, 0, 0, 1, 0, 0, 300)
		self.send_idata(self._tsn+7, 0, 0, 2, 0, 0, 300)
		self.check(1, 0, 6, 0) # <---- 6 reassem queue
		self.send_idata(self._tsn  , 0, 1, 0, 1, 0, 300)
		self.send_idata(self._tsn+1, 0, 0, 0, 1, 0, 300)
		self.check(1, 0, 4, 0) # <---- 4 reassem queue, 0 lobby

		self.send_idata(self._tsn+8, 3, 0, 0, 1, 1, 300)
		self.send_idata(self._tsn+9, 2, 0, 0, 1, 1, 300)
		self.check(1, 0, 4, 0) # <---- 4 reassem queue, 0 lobby
		self.send_idata(self._tsn+14,0, 3, 0, 1, 1, 300)
		self.send_idata(self._tsn+13,0, 2, 0, 1, 1, 300)
		self.send_idata(self._tsn+10,0, 1, 3, 0, 1, 300)
		self.check(1, 0, 0, 3) # <---- 0 reassem queue, 3 lobby
		self.send_idata(self._tsn+11,1, 0, 0, 1, 1, 300)
		self.check(1, 0, 0, 3) # <---- 0 reassem queue, 3 lobby
		self.send_idata(self._tsn+12,0, 0, 3, 0, 1, 300)
		self.send_idata(self._tsn+15,0, 4, 0, 1, 1, 300)
		self.check(1, 0, 0, 0) # <---- 0 reassem queue, 0 lobby
		self.stop()
		return True

	def test_d2(self):
		# isock - idata - serial fsn, got assem pd
		self.start_idata(self._target, self._local)
		self.send_idata(self._tsn+2, 0, 1, 0, 0, 0, 300, 1)
		self.send_idata(self._tsn+3, 0, 1, 1, 0, 0, 300, 1)
		self.send_idata(self._tsn+4, 0, 1, 2, 0, 0, 300, 1)
		self.send_idata(self._tsn+5, 0, 0, 0, 0, 0, 300, 1)
		self.send_idata(self._tsn+6, 0, 0, 1, 0, 0, 300, 1)
		self.send_idata(self._tsn+7, 0, 0, 2, 0, 0, 300, 1)
		self.check(1, 6, 0, 0) # <---- 6 reassem queue
		self.send_idata(self._tsn  , 0, 1, 0, 1, 0, 300, 1)
		self.send_idata(self._tsn+1, 0, 0, 0, 1, 0, 300, 1)
		self.check(1, 4, 0, 0) # <---- 4 reassem queue, 0 lobby

		self.send_idata(self._tsn+8, 3, 0, 0, 1, 1, 300, 1)
		self.send_idata(self._tsn+9, 2, 0, 0, 1, 1, 300, 1)
		self.check(1, 4, 0, 0) # <---- 4 reassem queue, 0 lobby

		self.send_idata(self._tsn+14,0, 3, 0, 1, 1, 300, 1)
		self.send_idata(self._tsn+13,0, 2, 0, 1, 1, 300, 1)
		self.send_idata(self._tsn+10,0, 1, 3, 0, 1, 300, 1)
		self.check(1, 4, 0, 0) # <---- 4 reassem queue, 0 lobby

		self.send_idata(self._tsn+11,1, 0, 0, 1, 1, 300, 1)
		self.check(1, 4, 0, 0) # <---- 4 reassem queue, 0 lobby
		self.send_idata(self._tsn+12,0, 0, 3, 0, 1, 300, 1)
		self.send_idata(self._tsn+15,0, 4, 0, 1, 1, 300, 1)
		self.check(1, 0, 0, 0) # <---- 0 reassem queue, 0 lobby
		self.stop()
		return True

	def test_e1(self):
		# isock - idata - serial fsn, got assem pd
		self.start_idata(self._target, self._local)
		for sid in range(4):
			j = 12*sid
			for i in range(12):
				mid = 1
				if i == 0:
					fsn = 0
					ending = 0
					beginning = 1
				elif i == 11:
					fsn = i-1
					ending = 1
					beginning = 0
				else:
					fsn = i-1
					ending = 0
					beginning = 0
				self.send_idata(self._tsn+i+j+24, sid, mid, fsn, beginning, ending, 1000)
		self.check(1, 0, 0, 4) # <---- 0 reassem queue, 4 lobby
		for sid in range(4):
			j = 5*sid
			for i in range(5):
				mid = 0
				if i == 0:
					fsn = 0
					beginning = 1
				else:
					fsn = i-1
					beginning = 0
				self.send_idata(self._tsn+i+j, sid, mid, fsn, beginning, 0, 100)
		self.check(1, 0, 0, 4) # <---- 0 reassem queue, 4 lobby
		for sid in range(4):
			i = 0
			j = sid
			mid = 0
			fsn = 5-1
			self.send_idata(self._tsn+i+j + 20, sid, mid, fsn, 0, 1, 100)
		self.check(1, 0, 0, 0) # <---- 0 reassem queue, 0 lobby
		self.stop()
		return True

	def test_e2(self):
		# isock - idata - serial fsn, got assem pd
		self.start_idata(self._target, self._local)
		for sid in range(4):
			j = 12*sid
			for i in range(12):
				mid = 1
				if i == 0:
					fsn = 0
					ending = 0
					beginning = 1
				elif i == 11:
					fsn = i-1
					ending = 1
					beginning = 0
				else:
					fsn = i-1
					ending = 0
					beginning = 0
				self.send_idata(self._tsn+i+j+24, sid, mid, fsn, beginning, ending, 1000)
		self.check(1, 0, 0, 4) # <---- 0 reassem queue, 4 lobby

		for sid in range(4):
			j = 5*sid
			for i in range(5):
				mid = 0
				if i == 0:
					fsn = 0
					beginning = 1
				else:
					fsn = i-1
					beginning = 0
				self.send_idata(self._tsn+i+j+24+48, sid, mid, fsn, beginning, 0, 100, 1)
		self.check(1, 0, 0, 4) # <---- 0 reassem queue uo, 4 lobby
		for sid in range(4):
			i = 0
			j = sid
			mid = 0
			fsn = 5-1
			self.send_idata(self._tsn+i+j + 24 + 48 + 16, sid, mid, fsn, 0, 1, 100, 1)
		self.check(1, 0, 0, 4) # <---- 0 reassem queue, 4 lobby

		for sid in range(4):
			j = 5*sid
			for i in range(5):
				mid = 0
				if i == 0:
					fsn = 0
					beginning = 1
				else:
					fsn = i-1
					beginning = 0
				self.send_idata(self._tsn+i+j, sid, mid, fsn, beginning, 0, 100)
		self.check(1, 0, 0, 4) # <---- 0 reassem queue, 4 lobby
		for sid in range(4):
			i = 0
			j = sid
			mid = 0
			fsn = 5-1
			self.send_idata(self._tsn+i+j + 20, sid, mid, fsn, 0, 1, 100)
		self.check(1, 0, 0, 0) # <---- 0 reassem queue, 0 lobby
		self.stop()
		return True

	def test_f1(self):
		# isock - idata - serial fsn, got assem pd
		self.start_idata(self._target, self._local)
		for sid in range(5):
			j = 10*sid
			for i in range(10):
				mid = 1
				if i == 0:
					fsn = 0
					ending = 0
					beginning = 1
				elif i == 9:
					fsn = i-1
					ending = 1
					beginning = 0
				else:
					fsn = i-1
					ending = 0
					beginning = 0
				self.send_idata(self._tsn+i+j+20+4+1, sid, mid, fsn, beginning, ending, 1000)
		self.check(1, 0, 0, 5) # <---- 0 reassem queue, 5 lobby
		for sid in range(4):
			j = 5*sid
			for i in range(5):
				mid = 0
				if i == 0:
					fsn = 0
					beginning = 1
				else:
					fsn = i-1
					beginning = 0
				self.send_idata(self._tsn+i+j, sid, mid, fsn, beginning, 0, 100)
		self.check(1, 0, 15, 4) # <---- 15 reassem queue, 4 lobby
		for sid in range(4):
			i = 0
			j = sid
			mid = 0
			fsn = 5-1
			self.send_idata(self._tsn+i+j + 20, sid, mid, fsn, 0, 1, 100)
		self.check(1, 0, 0, 0) # <---- 0 reassem queue, 0 lobby
		sid = 4
		j = 10*sid
		for i in range(10):
			mid = 1
			if i == 0:
				fsn = 0
				ending = 0
				beginning = 1
			elif i == 9:
				fsn = i-1
				ending = 1
				beginning = 0
			else:
				fsn = i-1
				ending = 0
				beginning = 0
			self.send_idata(self._tsn+i+j+20+4+1, sid, mid, fsn, beginning, ending, 1000)
		self.check(1, 0, 0, 1) # <---- 0 reassem queue, 1 lobby
		self.send_idata(self._tsn+20+4, 4, 0, 0, 1, 1, 1000)
		self.check(1, 0, 0, 0) # <---- 0 reassem queue, 0 lobby
		self.stop()
		return True

	def test_f2(self):
		# isock - idata - serial fsn, got assem pd
		self.start_idata(self._target, self._local)
		for sid in range(5):
			j = 10*sid
			for i in range(10):
				mid = 1
				if i == 0:
					fsn = 0
					ending = 0
					beginning = 1
				elif i == 9:
					fsn = i-1
					ending = 0 
					beginning = 0
				else:
					fsn = i-1
					ending = 0
					beginning = 0
				self.send_idata(self._tsn+i+j+20+4+1, sid, mid, fsn, beginning, ending, 1000)
		self.check(1, 0, 50, 0) # <---- 50 reassem queue, 0 lobby
		for sid in range(4):
			j = 5*sid
			for i in range(5):
				mid = 0
				if i == 0:
					fsn = 0
					beginning = 1
				else:
					fsn = i-1
					beginning = 0
				self.send_idata(self._tsn+i+j, sid, mid, fsn, beginning, 0, 10)
		self.check(1, 0, 64, 0) # <---- 64 reassem queue, 0 lobby
		for sid in range(4):
			i = 0
			j = sid
			mid = 0
			fsn = 5-1
			self.send_idata(self._tsn+i+j + 20, sid, mid, fsn, 0, 1, 10)
		self.check(1, 0, 49, 0) # <---- 49 reassem queue, 0 lobby
		for sid in range(5):
			j = sid
			mid = 1
			fsn = 9
			ending = 1
			beginning = 0
			self.send_idata(self._tsn+j+20+4+1+50, sid, mid, fsn, beginning, ending, 100)
		self.check(1, 0, 10, 0) # <---- 10 reassem queue, 0 lobby
		sid = 4
		j = sid*10
		mid = 1
		i = 9
		fsn = i - 1
		beginning = 0
		ending = 0
		self.send_idata(self._tsn+i+j+20+4+1, sid, mid, fsn, beginning, ending, 1000)
		self.check(1, 0, 0, 1) # <---- 0 reassem queue, 1 lobby
		self.send_idata(self._tsn+20+4, 4, 0, 0, 1, 1, 1000)
		self.check(1, 0, 0, 0) # <---- 0 reassem queue, 0 lobby
		self.stop()
		return True

		for i in range(10):
			mid = 1
			if i == 0:
				fsn = 0
				ending = 0
				beginning = 1
			elif i == 9:
				fsn = i-1
				ending = 0 
				beginning = 0
			else:
				fsn = i-1
				ending = 0
				beginning = 0
			self.send_idata(self._tsn+i+j+20+4, sid, mid, fsn, beginning, ending, 1000)
		self.check(1, 0, 0, 0) # <---- 0 reassem queue, 0 lobby
		self.stop()
		return True

	def test_f3(self):
		# isock - idata - serial fsn, got assem pd
		self.start_idata(self._target, self._local)
		for sid in range(5):
			j = 11*sid
			for i in range(11):
				if i == 0:
					continue
				mid = 1
				if i == 0:
					fsn = 0
					ending = 0
					beginning = 1
				elif i == 10:
					fsn = i-1
					ending = 1
					beginning = 0
				else:
					fsn = i-1
					ending = 0
					beginning = 0
				self.send_idata(self._tsn+i+j+20+4+5+1, sid, mid, fsn, beginning, ending, 1000, 1)
		self.check(1, 50, 0, 0) # <---- 50 reassem queue uo, 0 lobby
		for sid in range(4):
			j = 5*sid
			for i in range(5):
				mid = 0
				if i == 0:
					fsn = 0
					beginning = 1
				else:
					fsn = i-1
					beginning = 0
				self.send_idata(self._tsn+i+j, sid, mid, fsn, beginning, 0, 100, 1)
		self.check(1, 54, 0, 0) # <---- 54 reassem queue uo, 0 lobby
		for sid in range(4):
			i = 0
			j = sid
			mid = 0
			fsn = 5-1
			self.send_idata(self._tsn+i+j + 20, sid, mid, fsn, 0, 1, 100, 1)
		self.check(1, 49, 0, 0) # <---- 49 reassem queue uo, 0 lobby
		for sid in range(5):
			j = 11*sid
			for i in range(1):
				mid = 1
				if i == 0:
					fsn = 0
					ending = 0
					beginning = 1
				elif i == 10:
					fsn = i-1
					ending = 0 
					beginning = 0
				else:
					fsn = i-1
					ending = 1
					beginning = 0
				self.send_idata(self._tsn+i+j+20+4+5+1, sid, mid, fsn, beginning, ending, 100, 1)
		self.check(1, 0, 0, 0) # <---- 0 reassem queue uo, 0 lobby
		self.send_idata(self._tsn+20+4+5+1+54, 4, 1, 9, 0, 1, 100, 1)
		self.check(1, 0, 0, 0) # <---- 0 reassem queue uo, 0 lobby
		self.send_idata(self._tsn+20+4+5, 4, 0, 0, 1, 1, 100, 1)
		self.check(1, 0, 0, 0) # <---- 0 reassem queue uo, 0 lobby
		self.stop()
		return True
		
	def test_f4(self):
		# isock - idata - serial fsn, got assem pd
		self.start_idata(self._target, self._local)
		for sid in range(5):
			j = 11*sid
			for i in range(11):
				if i == 0:
					continue
				mid = 1
				if i == 0:
					fsn = 0
					ending = 0
					beginning = 1
				elif i == 10:
					fsn = i-1
					ending = 1
					beginning = 0
				else:
					fsn = i-1
					ending = 0
					beginning = 0
				self.send_idata(self._tsn+i+j+20+4+5+1, sid, mid, fsn, beginning, ending, 1000, 1)
		self.check(1, 50, 0, 0) # <---- 50 reassem queue uo, 0 lobby
		for sid in range(4):
			j = 5*sid
			for i in range(5):
				mid = 0
				if i == 0:
					fsn = 0
					beginning = 1
				else:
					fsn = i-1
					beginning = 0
				self.send_idata(self._tsn+i+j, sid, mid, fsn, beginning, 0, 10, 1)
		self.check(1, 64, 0, 0) # <---- 64 reassem queue uo, 0 lobby
		for sid in range(4):
			i = 0
			j = sid
			mid = 0
			fsn = 5-1
			self.send_idata(self._tsn+i+j + 20, sid, mid, fsn, 0, 1, 10, 1)
		self.check(1, 49, 0, 0) # <---- 49 reassem queue uo, 0 lobby
		for sid in range(5):
			j = 11*sid
			for i in range(1):
				mid = 1
				if i == 0:
					fsn = 0
					ending = 0
					beginning = 1
				elif i == 10:
					fsn = i-1
					ending = 0 
					beginning = 0
				else:
					fsn = i-1
					ending = 1
					beginning = 0
				self.send_idata(self._tsn+i+j+20+4+5+1, sid, mid, fsn, beginning, ending, 100, 1)
		self.check(1, 0, 0, 0) # <---- 0 reassem queue uo, 0 lobby
		self.send_idata(self._tsn+20+4+5+1+54, 4, 1, 9, 0, 1, 100, 1)
		self.check(1, 0, 0, 0) # <---- 0 reassem queue uo, 0 lobby
		self.send_idata(self._tsn+20+4+5, 4, 0, 0, 1, 1, 100, 1)
		self.check(1, 0, 0, 0) # <---- 0 reassem queue uo, 0 lobby
		self.stop()
		return True
		


	def test_h1(self):
		self.start_idata(self._target, self._local)
		self.send_idata(self._tsn + 1 , 0, 1, 0, 1, 1, 1000)
		self.send_idata(self._tsn + 3 , 0, 3, 0, 1, 1, 1000)
		self.send_idata(self._tsn + 5 , 0, 5, 0, 1, 1, 1000)
		self.send_idata(self._tsn + 8 , 0, 8, 0, 1, 1, 1000)
		self.send_idata(self._tsn + 9 , 0, 9, 0, 1, 1, 1000)
		self.send_idata(self._tsn +15 , 0, 15,0, 1, 1, 1000)
		self.send_idata(self._tsn +17 , 0, 17,0, 1, 1, 1000)
		self.send_iftsn(self._tsn +4, [(0, 4, 0)])
		self.check(1, 0, 0, 4)  # 4 lobby
		self.send_idata(self._tsn + 7 , 0, 7, 0, 1, 1, 1000)
		self.send_idata(self._tsn + 6 , 0, 6, 0, 1, 1, 1000)
		self.check(1, 0, 0, 2)  # 2 lobby
		self.send_iftsn(self._tsn + 14, [(0, 14, 0)])
		self.check(1, 0, 0, 1)  # 1 lobby
		self.send_idata(self._tsn + 16, 0, 16, 0, 1, 1, 1000)
		self.check(1, 0, 0, 0)  # 0 lobby
		self.stop()
		return True

	def test_h2(self):
		self.start_idata(self._target, self._local)
		self.send_idata(self._tsn+0, 0, 0, 0, 1, 1, 1000)
		self.send_idata(self._tsn+1, 0, 1, 0, 1, 1, 1000)
		#self.send_idata(self._tsn+2, 0, 2, 0, 1, 1, 1000)
		self.send_idata(self._tsn+3, 1, 0, 0, 1, 1, 1000)
		self.send_idata(self._tsn+4, 1, 1, 0, 1, 1, 1000)
		#self.send_idata(self._tsn+5, 2, 0, 0, 1, 1, 1000)
		#self.send_idata(self._tsn+6, 2, 1, 0, 1, 1, 1000)
		self.send_idata(self._tsn+7, 2, 2, 0, 1, 1, 1000)
		self.send_idata(self._tsn+8, 1, 2, 0, 1, 1, 1000)
		#self.send_idata(self._tsn+9, 1, 3, 0, 1, 1, 1000)
		self.send_idata(self._tsn+10, 1, 4, 0, 1, 1, 1000)
		self.send_idata(self._tsn+11, 0, 3, 0, 1, 1, 1000)
		#<---

		#self.send_idata(self._tsn+12, 0, 4, 0, 1, 1, 1000)
		self.send_idata(self._tsn+13, 1, 5, 0, 1, 1, 1000)
		#self.send_idata(self._tsn+14, 1, 6, 0, 1, 1, 1000)
		self.send_idata(self._tsn+15, 1, 7 ,0, 1, 1, 1000)
		#self.send_idata(self._tsn+16, 0, 5, 0, 1, 1, 1000)
		self.send_idata(self._tsn+17, 0, 6, 0, 1, 1, 1000)
		self.send_idata(self._tsn+18, 0, 7 ,0, 1, 1, 1000)
		self.send_idata(self._tsn+19, 2, 3, 0, 1, 1, 1000)
		#self.send_idata(self._tsn+20, 2, 4, 0, 1, 1, 1000)
		self.send_idata(self._tsn+21, 2, 5, 0, 1, 1, 1000)
		#<----

		self.send_idata(self._tsn+22, 0, 8 ,0, 1, 1, 1000)
		self.send_idata(self._tsn+23, 1, 8 ,0, 1, 1, 1000)
		self.send_idata(self._tsn+24, 2, 6, 0, 1, 1, 1000)
		#self.send_idata(self._tsn+25, 2, 7 ,0, 1, 1, 1000)
		self.send_idata(self._tsn+26, 2, 8 ,0, 1, 1, 1000)

		self.check(1, 0, 0, 13)  # 13 lobby
		self.send_iftsn(self._tsn+9, [(0, 2, 0), (1, 3, 0), (2, 1, 0)])
		self.check(1, 0, 0, 8)  # 8 lobby
		self.send_iftsn(self._tsn+20, [(0, 5, 0), (1, 6, 0), (2, 4, 0)])
		self.check(1, 0, 0, 1)  # 1 lobby
		self.send_iftsn(self._tsn+25, [(2, 7, 0)])
		self.check(1, 0, 0, 0)  # 0 lobby
		self.stop()
		return True

	def test_i1(self):
		self.start_idata(self._target, self._local)
		# self.send_idata(self._tsn+0, 0, 0, 0, 1, 1, 100)  # 1  <--
		self.send_idata(self._tsn+1, 0, 1, 0, 1, 0, 100)    # 2
		self.send_idata(self._tsn+2, 0, 1, 0, 0, 0, 100)    # 3
		self.send_idata(self._tsn+3, 0, 1, 1, 0, 0, 100)    # 4
		# self.send_idata(self._tsn+4, 0, 1, 2, 0, 1, 100)  # 5
		# self.send_idata(self._tsn+5, 0, 2, 0, 1, 1, 100)  # 6  <---
		self.send_idata(self._tsn+6, 0, 3, 0, 1, 1, 100)    # 7  <---
		# self.send_idata(self._tsn+7, 0, 4, 0, 1, 1, 100)  # 8  <---
		self.send_idata(self._tsn+8, 0, 5, 0, 1, 0, 100)    # 9
		self.send_idata(self._tsn+9, 0, 5, 0, 0, 0, 100)    # 10
		# self.send_idata(self._tsn+10, 0, 5, 1, 0, 1, 100)  # 11
		# self.send_idata(self._tsn+11, 0, 6, 0, 1, 1, 100)  # 12  <---
		# self.send_idata(self._tsn+12, 0, 7, 0, 1, 1, 100)  # 13  <---
		# self.send_idata(self._tsn+13, 0, 8, 0, 1, 1, 100)  # 14  <---
		self.send_idata(self._tsn+14, 0, 9, 0, 1, 1, 100)    # 15  <---

		self.check(1, 0, 5, 2)  # 5 reasm 2 lobby 
		self.send_iftsn(self._tsn + 5, [(0, 2, 0)])
		self.check(1, 0, 2, 1)  # 2 reasm 1 lobby
		self.send_iftsn(self._tsn + 7, [(0, 4, 0)])
		self.check(1, 0, 2, 1)  # 2 reasm 1 lobby
		self.send_iftsn(self._tsn + 13, [(0, 8, 0)])
		self.check(1, 0, 0, 0)  # 0 reasm 0 lobby

		# self.send_idata(self._tsn+15, 1, 0, 0, 1, 0, 100)  # 1)
		self.send_idata(self._tsn+16, 1, 0, 0, 0, 1, 100)    # 2)
		self.send_idata(self._tsn+17, 1, 1, 0, 1, 0, 100)    # 3)
		# self.send_idata(self._tsn+18, 1, 1, 0, 0, 0, 100)  # 4)
		self.send_idata(self._tsn+19, 1, 1, 1, 0, 0, 100)    # 5)
		self.send_idata(self._tsn+20, 1, 1, 2, 0, 1, 100)    # 6)
		self.send_idata(self._tsn+21, 2, 0, 0, 1, 1, 100)    # A   <---
		# self.send_idata(self._tsn+22, 2, 1, 0, 1, 0, 100)  # B
		self.send_idata(self._tsn+23, 2, 1, 0, 0, 0, 100)    # C
		# self.send_idata(self._tsn+24, 2, 1, 1, 0, 0, 100)  # D
		self.send_idata(self._tsn+25, 2, 1, 2, 0, 1, 100)    # E

		# self.send_idata(self._tsn+26, 1, 2, 0, 1, 1, 100)  # 7)  <---
		# self.send_idata(self._tsn+27, 1, 3, 0, 1, 1, 100)  # 8)  <---
		self.send_idata(self._tsn+28, 1, 4, 0, 1, 1, 100)    # 9)  <---
		self.send_idata(self._tsn+29, 1, 5, 0, 1, 1, 100)    #10)  <---

		self.send_idata(self._tsn+30, 2, 2, 0, 1, 0, 100)    # F
		# self.send_idata(self._tsn+31, 2, 2, 0, 0, 1, 1000)  # G

		self.check(1, 0, 7, 2)  # 7 reasm 2 lobby
		self.send_iftsn(self._tsn + 24, [(1, 1, 0), (2, 1, 0)])
		self.check(1, 0, 2, 2)  # 2 reasm 2 lobby
		self.send_iftsn(self._tsn + 31, [(1, 3, 0), (2, 2, 0)])
		self.check(1, 0, 0, 0)  # 0 reasm 0 lobby

		self.stop()
		return True

	def test_i2(self):
		self.start_idata(self._target, self._local)
		# self.send_idata(self._tsn+0, 0, 0, 0, 1, 1, 100)  # 1  <--
		self.send_idata(self._tsn+1, 0, 1, 0, 1, 0, 100, 1)    # 2
		self.send_idata(self._tsn+2, 0, 1, 0, 0, 0, 100, 1)    # 3
		self.send_idata(self._tsn+3, 0, 1, 1, 0, 0, 100, 1)    # 4
		# self.send_idata(self._tsn+4, 0, 1, 2, 0, 1, 100, 1)  # 5
		# self.send_idata(self._tsn+5, 0, 2, 0, 1, 1, 100, 1)  # 6  <---
		self.send_idata(self._tsn+6, 0, 3, 0, 1, 1, 100, 1)    # 7  <---
		# self.send_idata(self._tsn+7, 0, 4, 0, 1, 1, 100, 1)  # 8  <---
		self.send_idata(self._tsn+8, 0, 5, 0, 1, 0, 100, 1)    # 9
		self.send_idata(self._tsn+9, 0, 5, 0, 0, 0, 100, 1)    # 10
		# self.send_idata(self._tsn+10, 0, 5, 1, 0, 1, 100, 1)  # 11
		# self.send_idata(self._tsn+11, 0, 6, 0, 1, 1, 100, 1)  # 12  <---
		# self.send_idata(self._tsn+12, 0, 7, 0, 1, 1, 100, 1)  # 13  <---
		# self.send_idata(self._tsn+13, 0, 8, 0, 1, 1, 100, 1)  # 14  <---
		self.send_idata(self._tsn+14, 0, 9, 0, 1, 1, 100, 1)    # 15  <---

		self.check(1, 5, 0, 0)  # 5 reasm uo 0 lobby 
		self.send_iftsn(self._tsn + 5, [(0, 2, 1)])
		self.check(1, 2, 0, 0)  # 2 reasm uo 0 lobby
		self.send_iftsn(self._tsn + 7, [(0, 4, 1)])
		self.check(1, 2, 0, 0)  # 2 reasm uo 0 lobby
		self.send_iftsn(self._tsn + 13, [(0, 8, 1)])
		self.check(1, 0, 0, 0)  # 0 reasm uo 0 lobby

		# self.send_idata(self._tsn+15, 1, 0, 0, 1, 0, 100, 1)  # 1)
		self.send_idata(self._tsn+16, 1, 0, 0, 0, 1, 100, 1)    # 2)
		self.send_idata(self._tsn+17, 1, 1, 0, 1, 0, 100, 1)    # 3)
		# self.send_idata(self._tsn+18, 1, 1, 0, 0, 0, 100, 1)  # 4)
		self.send_idata(self._tsn+19, 1, 1, 1, 0, 0, 100, 1)    # 5)
		self.send_idata(self._tsn+20, 1, 1, 2, 0, 1, 100, 1)    # 6)
		self.send_idata(self._tsn+21, 2, 0, 0, 1, 1, 100, 1)    # A   <---
		# self.send_idata(self._tsn+22, 2, 1, 0, 1, 0, 100, 1)  # B
		self.send_idata(self._tsn+23, 2, 1, 0, 0, 0, 100, 1)    # C
		# self.send_idata(self._tsn+24, 2, 1, 1, 0, 0, 100, 1)  # D
		self.send_idata(self._tsn+25, 2, 1, 2, 0, 1, 100, 1)    # E

		# self.send_idata(self._tsn+26, 1, 2, 0, 1, 1, 100, 1)  # 7)  <---
		# self.send_idata(self._tsn+27, 1, 3, 0, 1, 1, 100, 1)  # 8)  <---
		self.send_idata(self._tsn+28, 1, 4, 0, 1, 1, 100, 1)    # 9)  <---
		self.send_idata(self._tsn+29, 1, 5, 0, 1, 1, 100, 1)    #10)  <---

		self.send_idata(self._tsn+30, 2, 2, 0, 1, 0, 100, 1)    # F
		# self.send_idata(self._tsn+31, 2, 2, 0, 0, 1, 1000, 1)  # G

		self.check(1, 7, 0, 0)  # 7 reasm uo 0 lobby
		self.send_iftsn(self._tsn + 24, [(1, 1, 1), (2, 1, 1)])
		self.check(1, 2, 0, 0)  # 2 reasm uo 0 lobby
		self.send_iftsn(self._tsn + 31, [(1, 3, 1), (2, 2, 1)])
		self.check(1, 0, 0, 0)  # 0 reasm uo 0 lobby

		self.stop()
		return True

	def test_i2(self):
		self.start_idata(self._target, self._local)
		self.send_idata(self._tsn+0, 0, 0, 0, 1, 1, 100, 1)    # 1  <--
		self.send_idata(self._tsn+1, 0, 1, 0, 1, 0, 100, 1)    # 2
		self.send_idata(self._tsn+2, 0, 1, 0, 0, 0, 100, 1)    # 3
		self.send_idata(self._tsn+3, 0, 1, 1, 0, 0, 100, 1)    # 4
		#self.send_idata(self._tsn+4, 0, 1, 2, 0, 1, 100, 1)    # 4
		#self.send_idata(self._tsn+5, 0, 2, 0, 1, 1, 100, 1)    # 4

		#self.send_idata(self._tsn+6, 0, 0, 0, 1, 1, 100)    # 4
		self.send_idata(self._tsn+7, 0, 1, 0, 1, 0, 100)    # 4
		self.send_idata(self._tsn+8, 0, 1, 0, 0, 0, 100)    # 4
		#self.send_idata(self._tsn+9, 0, 1, 1, 0, 0, 100)    # 4
		self.send_idata(self._tsn+10, 0, 1, 2, 0, 1, 100)    # 4
		# self.send_idata(self._tsn+11, 0, 2, 0, 1, 1, 100)    # 4
		self.send_idata(self._tsn+12, 0, 3, 0, 1, 1, 100, 1)    # 4
		self.send_idata(self._tsn+13, 0, 3, 0, 1, 1, 100)    # 4
		self.check(1, 3, 3, 1)  # 2 reasm uo 2 reasm 1 lobby
		self.send_iftsn(self._tsn + 5, [(0, 2, 1)])
		self.check(1, 0, 3, 1)  # 0 reasm uo 2 reasm 1 lobby
		self.send_iftsn(self._tsn + 11, [(0, 2, 0)])
		self.check(1, 0, 0, 0)  # 0 reasm uo 0 reasm 0 lobby 
		self.stop()
		return True

	def test_j(self):
		self.start_idata(self._target, self._local)
		self.send_idata(self._tsn+0, 0, 0, 0, 1, 0, 300)    # 1  <--
		self.send_idata(self._tsn+1, 0, 0, 0, 0, 0, 300)    # 1  <--
		self.send_idata(self._tsn+2, 0, 0, 1, 0, 0, 300)    # 1  <--
		# self.send_idata(self._tsn+3, 0, 0, 2, 0, 1, 300)    # 1  <--
		# self.send_idata(self._tsn+4, 0, 1, 0, 1, 1, 300)    # 1  <--
		self.send_idata(self._tsn+5, 0, 2, 0, 1, 1, 300)    # 1  <--
		self.send_idata(self._tsn+6, 0, 3, 0, 1, 1, 300)    # 1  <--
		self.check(1, 0, 0, 2)  # 0 reasm uo 0 reasm 2 lobby 
		self.send_iftsn(self._tsn + 4, [(0, 1, 0)])
		self.check(2)  # event sent 

		# self.send_idata(self._tsn+7, 0, 0, 0, 1, 0, 300, 1)    # 1  <--
		self.send_idata(self._tsn+8, 0, 0, 0, 0, 1, 300, 1)    # 1  <--
		self.send_idata(self._tsn+9, 0, 1, 0, 1, 0, 300, 1)    # 1  <--
		self.send_idata(self._tsn+10, 0, 1, 0, 0, 0, 300, 1)    # 1  <--
		self.send_idata(self._tsn+11, 0, 1, 1, 0, 0, 300, 1)    # 1  <--
		# self.send_idata(self._tsn+12, 0, 1, 2, 0, 1, 300, 1)    # 1  <--
		# self.send_idata(self._tsn+13, 0, 2, 0, 1, 1, 300, 1)    # 1  <--
		self.send_idata(self._tsn+14, 0, 3, 0, 1, 1, 300, 1)    # 1  <--
		self.send_idata(self._tsn+15, 0, 4, 0, 1, 1, 300, 1)    # 1  <--
		self.check(1, 1, 0, 0)  # 1 reasm uo 0 reasm 0 lobby 
		self.send_iftsn(self._tsn + 13, [(0, 2, 1)])
		self.check(2)  # event sent 
		self.stop()
		return True

	def test_all(self):
		if hasattr(SctpStreamInterleaveTest, "test"):
			getattr(SctpStreamInterleaveTest, "test")(self)
			return
		for func in dir(SctpStreamInterleaveTest):
			if callable(getattr(SctpStreamInterleaveTest, func)):
				if func.startswith("test_") and func != "test_all":
					print "- " + func + " Start:"
					getattr(SctpStreamInterleaveTest, func)(self)


	# Tmp codes
	def testx(self):
		self.start_idata(self._target, self._local)
		self.send_idata(self._tsn , 0, 1, 0, 1, 1, 1000)
		self.send_iftsn(2018, [(1, 10, 0)])
		self.stop()
		return True

	def testy(self):
		self.send_idata(self._tsn, 0, 0, 0, 1, 1, 1000)  # 1
		self.send_idata(self._tsn, 0, 1, 0, 1, 0, 1000)  # 2
		self.send_idata(self._tsn, 0, 1, 1, 0, 0, 1000)  # 3
		self.send_idata(self._tsn, 0, 1, 2, 0, 0, 1000)  # 4
		self.send_idata(self._tsn, 0, 1, 3, 0, 1, 1000)  # 5
		self.send_idata(self._tsn, 0, 2, 0, 1, 1, 1000)  # 6
		self.send_idata(self._tsn, 0, 3, 0, 1, 1, 1000)  # 7
		self.send_idata(self._tsn, 0, 4, 0, 1, 1, 1000)  # 8
		self.send_idata(self._tsn, 0, 5, 0, 1, 0, 1000)  # 9
		self.send_idata(self._tsn, 0, 5, 1, 0, 0, 1000)  # 10
		self.send_idata(self._tsn, 0, 5, 2, 0, 1, 1000)  # 11
		self.send_idata(self._tsn, 0, 6, 0, 1, 1, 1000)  # 12
		self.send_idata(self._tsn, 0, 7, 0, 1, 1, 1000)  # 13
		self.send_idata(self._tsn, 0, 8, 0, 1, 1, 1000)  # 14
		self.send_idata(self._tsn, 0, 9, 0, 1, 1, 1000)  # 15

		self.send_idata(self._tsn, 1, 0, 0, 1, 1, 1000)  # 1)
		self.send_idata(self._tsn, 1, 0, 0, 1, 1, 1000)  # 2)
		self.send_idata(self._tsn, 1, 1, 0, 1, 0, 1000)  # 3)
		self.send_idata(self._tsn, 1, 1, 1, 0, 0, 1000)  # 4)
		self.send_idata(self._tsn, 1, 1, 2, 0, 0, 1000)  # 5)
		self.send_idata(self._tsn, 1, 1, 3, 0, 1, 1000)  # 6)
		self.send_idata(self._tsn, 1, 2, 0, 1, 1, 1000)  # 7)
		self.send_idata(self._tsn, 1, 3, 0, 1, 1, 1000)  # 8)
		self.send_idata(self._tsn, 1, 4, 0, 1, 1, 1000)  # 9)
		self.send_idata(self._tsn, 1, 5, 0, 1, 1, 1000)  #10)

		self.send_idata(self._tsn, 2, 0, 0, 1, 1, 1000)  # A
		self.send_idata(self._tsn, 2, 1, 0, 1, 0, 1000)  # B
		self.send_idata(self._tsn, 2, 1, 1, 0, 0, 1000)  # C
		self.send_idata(self._tsn, 2, 1, 2, 0, 0, 1000)  # D
		self.send_idata(self._tsn, 2, 1, 3, 0, 1, 1000)  # E
		self.send_idata(self._tsn, 2, 2, 0, 1, 0, 1000)  # F
		# self.send_idata(self._tsn, 2, 2, 0, 0, 1, 1000)  # G
		

def main():
	opts, _ = getopt.getopt(sys.argv[1:], "l:h:p:", \
				["local", "host", "port"])
	for opt, arg in opts:
		if opt in ("-h", "--host"):
			target_host = arg
		elif opt in ("-l", "--local"):
			local_host = arg
		elif opt in ("-p", "--port"):
			target_port = int(arg)

	target = (target_host, target_port)
	local  = (local_host, randint(0, 2L**16-1))

	ssilt = SctpStreamInterleaveTest()
	ssilt.set_addrs(target, local)
	try:
		ssilt.test_all()
	finally:
		ssilt.stop()

	return True

if __name__ == "__main__":
	main()
