#include <pthread.h>
#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
#include <string.h>
#include <errno.h>

#include "SK.h"

int arg_port;
char *arg_hostname;
pthread_mutex_t lock = PTHREAD_MUTEX_INITIALIZER;
int numlines = 0;
char line[1024] = "This is a stupid test.\n";

void *startup(void *arg) {
	int sock;
	size_t len;
	fd_set rset;
	char buf[1024];
	struct timeval ptm;
	int sel;
	
	while (1) {
		pthread_mutex_lock(&lock);
		numlines++;
		if (numlines > 1000) {
			numlines -= 1000;
			fprintf(stderr, ".");fflush(stderr);
		}
		pthread_mutex_unlock(&lock);
		
		sock = SK_connect(arg_hostname, arg_port, 10);
		if (sock < 0) {
			sleep(3);
		} 
		else 
		{
			
			write(sock, line, 25);
			while (1) {
				FD_ZERO(&rset);
				ptm.tv_usec = 0;
				ptm.tv_sec = 10;
				FD_SET(sock, &rset);
				if ((sel = select(sock + 1, &rset, NULL, NULL, &ptm)) <= 0) {
					fprintf(stderr, "!");fflush(stderr);
					break;
				}
				
				if (read(sock, buf, 1024) <= 0) break;
			}

                        if (close(sock) < 0) {
                                perror("close");
                        }
		}
	}
}

int main(int argc, char **argv) {
	int numthreads, i;
	pthread_attr_t attr;

	if (argc < 4) {
		printf("%s <numthreads> <servername> <serverport>\n\n"
			"Where servername can be a hostname or a v4 or v6 address.\n", argv[0]);
		exit(1);
	}

	numthreads = strtol(argv[1], NULL, 10);
	arg_hostname = argv[2];
	arg_port = strtol(argv[3], NULL, 10);

	pthread_attr_init(&attr);
	pthread_attr_setdetachstate(&attr, PTHREAD_CREATE_DETACHED);
	pthread_attr_setstacksize(&attr, 1048576);
	printf("Creating %d threads, connecting to server at %s:%d...\n", numthreads, arg_hostname, arg_port);

	for (i = 0; i < numthreads; i++) {
		pthread_t dummy;
		int res = pthread_create(&dummy, &attr, startup, NULL);
		if (res != 0) {
			perror("pthread_create");
			exit(1);
		}
	}
	
	printf("Thread creation done. Each . represents 1000 queries. * means a connect() timeout, ! means a read() timeout.\nPress ctrl-c to exit.\n");
	sleep(2147483647);
	return 0;
}
