#include <netinet/in.h>
#include <arpa/inet.h>
#include <linux/if_packet.h>
#include <linux/if_ether.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <poll.h>
#include <sys/mman.h>

#define _GNU_SOURCE

#define BLOCK_SIZE	4096
#define BLOCK_NR	4
#define FRAME_SIZE	2048
#define FRAME_NR	8

#define CR_NUM		16

int main(void)
{
	int fd;
	struct tpacket_req req;
	int size, retval;
	struct pollfd pfd;
	unsigned char *buf;
	int i;

	if ((fd = socket(PF_PACKET, SOCK_RAW, htons(ETH_P_ALL))) < 0) {
		perror("socket()");
		return 1;
	}
	req.tp_block_size = BLOCK_SIZE;
	req.tp_block_nr = BLOCK_NR;
	req.tp_frame_size = FRAME_SIZE;
	req.tp_frame_nr = FRAME_NR;
	setsockopt(fd, SOL_PACKET, PACKET_RX_RING, (char *)&req, sizeof(req));

	size = BLOCK_SIZE * BLOCK_NR;
	buf =
	    (unsigned char *)mmap(0, size, PROT_READ | PROT_WRITE, MAP_SHARED,
				  fd, 0);

	pfd.fd = fd;
	pfd.revents = 0;
	pfd.events = POLLIN | POLLERR;

	retval = poll(&pfd, 1, -1);
	for (i = 0; i < FRAME_SIZE; i++) {
		if ((i % CR_NUM) == 0)
			printf("\n");
		printf("%.2x-", buf[i]);
	}
	printf("\n");
	close(fd);
	return 0;
}
