#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <glade/glade.h>
#include "gtk/dialogs/gtk_source.h"
#include "gtk/dialogs/gtk_about.h"
#include "gtk/gtk_window.h"
#include "gtk/gtk_gui.h"
#include "gtk/gtk_print.h"
#include "gtk/gtk_selection.h"
#include "desktop/netsurf.h"
#include "desktop/print.h"
#include "utils/utils.h"
#include "utils/messages.h"
#include "render/font.h"

struct menu_events {
	const char *widget;
	GCallback handler;
};

static GladeXML * glade_File;
static gchar * glade_Location;
GtkWindow * wndSource;
static struct nsgtk_source_window *nsgtk_source_list = 0;
char source_zoomlevel = 10;

void nsgtk_attach_source_menu_handlers(GladeXML *xml, gpointer g);
void nsgtk_source_file_save(const char * filename, const char * data);
void nsgtk_source_update_zoomlevel(gpointer g);

#define MENUEVENT(x) { #x, G_CALLBACK(nsgtk_on_##x##_activate) }
#define MENUPROTO(x) static gboolean nsgtk_on_##x##_activate( \
					GtkMenuItem *widget, gpointer g)

MENUPROTO(source_save_as);
MENUPROTO(source_print);
MENUPROTO(source_close);
MENUPROTO(source_select_all);
MENUPROTO(source_cut);
MENUPROTO(source_copy);
MENUPROTO(source_paste);
MENUPROTO(source_delete);
MENUPROTO(source_zoom_in);
MENUPROTO(source_zoom_out);
MENUPROTO(source_zoom_normal);
MENUPROTO(source_about);

struct menu_events source_menu_events[] = {
MENUEVENT(source_save_as),
MENUEVENT(source_print),
MENUEVENT(source_close),
MENUEVENT(source_select_all),
MENUEVENT(source_cut),
MENUEVENT(source_copy),
MENUEVENT(source_paste),
MENUEVENT(source_delete),
MENUEVENT(source_zoom_in),
MENUEVENT(source_zoom_out),
MENUEVENT(source_zoom_normal),
MENUEVENT(source_about),
{NULL, NULL}
};

void nsgtk_source_dialog_init(GtkWindow * parent, struct browser_window * bw) {
		
	if (bw->current_content->type == CONTENT_HTML) {
		glade_Location = g_strconcat(res_dir_location, "source.glade", NULL);
		glade_File = glade_xml_new(glade_Location, NULL, NULL);
		if (glade_File) {
			wndSource = GTK_WINDOW(glade_xml_get_widget(glade_File,
					"wndSource"));
			
			GtkWidget *cutbutton = glade_xml_get_widget(glade_File, "source_cut");
			GtkWidget *pastebutton = glade_xml_get_widget(glade_File, "source_paste");
			GtkWidget *deletebutton = glade_xml_get_widget(glade_File, "source_delete");
			gtk_widget_set_sensitive(cutbutton, FALSE);
			gtk_widget_set_sensitive(pastebutton, FALSE);
			gtk_widget_set_sensitive(deletebutton, FALSE);
			
			
			struct nsgtk_source_window *thiswindow = (struct
					nsgtk_source_window *)malloc(sizeof(struct 
					nsgtk_source_window));
			
			thiswindow->url = bw->current_content->url;
			thiswindow->data = bw->current_content->source_data;
			thiswindow->sourcewindow = wndSource;
			thiswindow->bw = bw;
			
			if (nsgtk_source_list) {
				thiswindow->next = nsgtk_source_list;
				nsgtk_source_list->prev = thiswindow;
			}
			nsgtk_source_list = thiswindow;

			char *title = malloc(strlen(bw->current_content->url) + 10);
			strcpy(title, "Source of ");
			strcat(title, bw->current_content->url);
			
			nsgtk_attach_source_menu_handlers(glade_File, thiswindow);
			
			gtk_window_set_title(wndSource, title);
			
			// set sensitivities
			
			GtkTextView * sourceview = GTK_TEXT_VIEW(glade_xml_get_widget(
					glade_File,	"source_view"));
			thiswindow->gv = sourceview;
			GtkTextBuffer * tb = gtk_text_view_get_buffer(sourceview);
			gtk_text_buffer_set_text(tb, bw->current_content->source_data, -1);
			
			gtk_widget_show(GTK_WIDGET(wndSource));
		} else {
			printf("error loading glade tree\n");
		}
	}
}

void nsgtk_attach_source_menu_handlers(GladeXML *xml, gpointer g)
{
	struct menu_events *event = source_menu_events;

	while (event->widget != NULL)
	{
		GtkWidget *w = glade_xml_get_widget(xml, event->widget);
		g_signal_connect(G_OBJECT(w), "activate", event->handler, g);
		event++;
	}
}

gboolean nsgtk_on_source_save_as_activate( GtkMenuItem *widget, gpointer g)
{
	struct nsgtk_source_window * nsg = (struct nsgtk_source_window *)g;
	GtkWidget * fc = gtk_file_chooser_dialog_new("save source", 
			nsg->sourcewindow, GTK_FILE_CHOOSER_ACTION_SAVE, GTK_STOCK_CANCEL,
			GTK_RESPONSE_CANCEL, GTK_STOCK_SAVE, GTK_RESPONSE_ACCEPT, NULL);
	if (gtk_dialog_run(GTK_DIALOG(fc)) == GTK_RESPONSE_ACCEPT) {
		char * filename;
		filename = gtk_file_chooser_get_filename(GTK_FILE_CHOOSER(fc));
		nsgtk_source_file_save(filename, nsg->data);
		g_free(filename);
	}
	gtk_widget_destroy(fc);
	return TRUE;
}

void nsgtk_source_file_save(const char * filename, const char * data) {
	FILE *f;
	f = fopen(filename, "w+");
	fprintf(f, "%s", data);
	fclose(f);
}

gboolean nsgtk_on_source_print_activate( GtkMenuItem *widget, gpointer g)
{
/*	TODO correct printing

	struct nsgtk_source_window * nsg = (struct nsgtk_source_window *)g;
	
	GtkPrintOperation *print_op;
	GtkPageSetup *page_setup;
	GtkPrintSettings *gtk_print_settings;
	GtkPrintOperationResult res;
	struct print_settings *settings;
	
	print_op = gtk_print_operation_new();
	if (print_op == NULL) {
		warn_user(messages_get("NoMemory"), 0);
		return TRUE;
	}
*/
	/* use previously saved settings if any */
/*	gtk_print_settings = gtk_print_settings_new_from_file(
			print_options_file_location, NULL);
	if (gtk_print_settings != NULL) {
		gtk_print_operation_set_print_settings(print_op,
				gtk_print_settings);
*/
		/* We're not interested in the settings any more */
/*		g_object_unref(gtk_print_settings);
	}
*/
	/* nsg->data is raw input for printing; there is a 'page' view held in nsg->gv */
//	content_to_print = nsg->data;
/*	
	page_setup = gtk_print_run_page_setup_dialog(nsg->sourcewindow, NULL, NULL);
	if (page_setup == NULL) {
		warn_user(messages_get("NoMemory"), 0);
		g_object_unref(print_op);
		return TRUE;
	}
	gtk_print_operation_set_default_page_setup(print_op, page_setup);
	
	settings = print_make_settings(PRINT_DEFAULT, NULL, &nsfont);
	
	g_signal_connect(print_op, "begin_print", 
			G_CALLBACK(gtk_print_signal_begin_print), settings);
	g_signal_connect(print_op, "draw_page", 
			G_CALLBACK(gtk_print_signal_draw_page), NULL);
	g_signal_connect(print_op, "end_print", 
			G_CALLBACK(gtk_print_signal_end_print), settings);
	
	res = gtk_print_operation_run(print_op,
				GTK_PRINT_OPERATION_ACTION_PRINT_DIALOG,
    				nsg->sourcewindow,
				NULL);
*/	
	/* if the settings were used save them for future use */
/*	if (res == GTK_PRINT_OPERATION_RESULT_APPLY) {
*/
		/* Don't ref the settings, as we don't want to own them */
/*		gtk_print_settings = gtk_print_operation_get_print_settings(
				print_op);

		gtk_print_settings_to_file(gtk_print_settings,
				print_options_file_location, NULL);
	}
*/
	/* Our print_settings object is destroyed by the end print handler */
/*	g_object_unref(page_setup);
	g_object_unref(print_op);
	
*/	return TRUE;
}


gboolean nsgtk_on_source_close_activate( GtkMenuItem *widget, gpointer g)
{
	struct nsgtk_source_window * nsg = (struct nsgtk_source_window *)g;
	gtk_widget_destroy(GTK_WIDGET(nsg->sourcewindow));
	free(g);
	return TRUE;
}

gboolean nsgtk_on_source_select_all_activate (GtkMenuItem *widget, gpointer g) {
	struct nsgtk_source_window * nsg = (struct nsgtk_source_window *)g;
	GtkTextBuffer *buf = gtk_text_view_get_buffer(nsg->gv);
	GtkTextIter start, end;
	gtk_text_buffer_get_bounds(buf, &start, &end);
	gtk_text_buffer_select_range(buf, &start, &end);
	return TRUE;
}

gboolean nsgtk_on_source_cut_activate( GtkMenuItem *widget, gpointer g)
{
	return TRUE;
}

 gboolean nsgtk_on_source_copy_activate( GtkMenuItem *widget, gpointer g)
{
	struct nsgtk_source_window * nsg = (struct nsgtk_source_window *)g;
	GtkTextBuffer *buf = gtk_text_view_get_buffer(GTK_TEXT_VIEW(nsg->gv));
	gtk_text_buffer_copy_clipboard(buf, gtk_clipboard_get
			(GDK_SELECTION_CLIPBOARD));
	return TRUE;
}

 gboolean nsgtk_on_source_paste_activate( GtkMenuItem *widget, gpointer g)
{
	return TRUE;
}

 gboolean nsgtk_on_source_delete_activate( GtkMenuItem *widget, gpointer g)
{
	return TRUE;
}

 gboolean nsgtk_on_source_zoom_in_activate( GtkMenuItem *widget, gpointer g)
{
	source_zoomlevel++;
	nsgtk_source_update_zoomlevel(g);
	return TRUE;
}

 gboolean nsgtk_on_source_zoom_out_activate( GtkMenuItem *widget, gpointer g)
{
	if (source_zoomlevel > 1) {
		source_zoomlevel--;
		nsgtk_source_update_zoomlevel(g);
	}
	return TRUE;
}

 gboolean nsgtk_on_source_zoom_normal_activate( GtkMenuItem *widget, gpointer g)
{
	source_zoomlevel = 10;
	nsgtk_source_update_zoomlevel(g);
	return TRUE;
}

 gboolean nsgtk_on_source_about_activate( GtkMenuItem *widget, gpointer g)
{
	struct nsgtk_source_window *nsg = (struct nsgtk_source_window *)g;
	nsgtk_about_dialog_init(nsg->sourcewindow, nsg->bw, netsurf_version);
	return TRUE;
}

void nsgtk_source_update_zoomlevel(gpointer g) {
	struct nsgtk_source_window *nsg = (struct nsgtk_source_window *)g;
	GtkTextBuffer *buf = gtk_text_view_get_buffer(nsg->gv);
	GtkTextTagTable * tab = gtk_text_buffer_get_tag_table(buf);
	GtkTextTag *tag;
	tag = gtk_text_tag_table_lookup(tab, "zoomlevel");
	if (!tag) {
		tag = gtk_text_tag_new("zoomlevel");
		gtk_text_tag_table_add(tab, tag);
	}
	gdouble fscale = ((gdouble)source_zoomlevel) / 10;
	printf("%f\n",fscale);
	g_object_set(tag, "scale", fscale, NULL);
	GtkTextIter start, end;
	gtk_text_buffer_get_bounds(buf, &start, &end);
	gtk_text_buffer_remove_all_tags(buf, &start, &end);
	gtk_text_buffer_apply_tag(buf, tag, &start, &end);
}
