#! /bin/sh

export PATH=/var/run/current-system/sw/bin
export FONTCONFIG_FILE=/etc/fonts/fonts.conf

echo "Content-Type: image/png"
echo 

graph=${QUERY_STRING#*[&?]graph=}
graph=${graph%%&*}
graph=${graph#graph=}
numbers=${QUERY_STRING#*[&?]numbers=}
numbers=${numbers%%&*}
numbers=${numbers#numbers=}
numbers=${numbers#\'}
numbers=${numbers%\'}
nums="${numbers//\',\'/ }"

names="$(echo $nums | sed -e 's/ /\n/g' | ./idx2name.sh ${graph%.*}.idx)"

echo Graph: $graph >&2
echo Numbers: $nums >&2
echo Names: "$names" >&2

./neighbourhood.sh $graph "$names" | ./dot2png.sh
