#! /bin/sh

export PATH=/var/run/current-system/sw/bin

echo "Content-Type: text/html"
echo 

graph=${QUERY_STRING#*[&?]graph=}
graph=${graph#graph=}
graph=${graph%%&*}

echo Graph: $graph >&2;

numbers=${QUERY_STRING#*[&?]numbers=}
numbers=${numbers#numbers=}
numbers=${numbers%%&*}

nums="${numbers//+/ }"
nums="${nums//none/}"

echo Numbers: $nums >&2;

if ! echo $QUERY_STRING | egrep "[&?]numbers=" &>/dev/null; then
	mask=${QUERY_STRING#*[&?]search=}
	mask=${mask#mask=}
	mask=${mask%%&*}
	mask=$(echo $mask | /home/raskin/src/c/unhttp/unhttp)
	nums=$( ./select-by-name.sh $graph $mask | ./name2idx.sh ${graph%.*}.idx);
fi;

echo Numbers: $nums >&2;

new_nums="$(./added-vertices.sh $graph $(echo $nums | sed -e 's/ /\n/g' |
	 ./idx2name.sh ${graph%.*}.idx) | ./name2idx.sh ${graph%.*}.idx)";

echo Added numbers: $new_nums >&2;

add_links="";
for i in $new_nums; do 
	add_links="$add_links <a href=\"javascript:addNumber('$i');\">
		add: $(echo $i | sed -e 's/ /\n/g' |
			./idx2name.sh ${graph%.*}.idx ) </a> <br />"; 
done;

remove_links="";
for i in $nums; do 
	remove_links="$remove_links <a href=\"javascript:delNumber('$i');\">
		remove: $(echo $i | sed -e 's/ /\n/g' |
			./idx2name.sh ${graph%.*}.idx ) </a> <br />"; 
done;

echo $add_links >&2
echo $remove_links >&2

cat viewgraph.html | replace-literal -e _NUMBERS_ "'${nums// /','}'" |
	replace-literal -e _GRAPH_ "$graph" |
	replace-literal -e _ADD_LINKS_ "$add_links" |
	replace-literal -e _REMOVE_LINKS_ "$remove_links" 

