"""libANN (Apriximate Nearest Neighbors library) python interface
Copyright (C) 2008, Robert Hetland
"""

classifiers = """\
Development Status :: beta
Environment :: Console
Intended Audience :: Science/Research
Intended Audience :: Developers
License :: MIT
Operating System :: OS Independent
Programming Language :: Python
Topic :: Scientific/Engineering
Topic :: Software Development :: Libraries :: Python Modules
"""

from numpy.distutils.core import Extension

libann_wrap = Extension(name = '_libann_wrap',
                sources = ['ann/ann_wrap.cpp'],
                include_dirs=['/usr/local/include'],
                library_dirs=['/usr/local/lib'],
                libraries=['ANN'])

doclines = __doc__.split("\n")

if __name__ == '__main__':
    from numpy.distutils.core import setup
    setup(name = "ann",
          version = '1.0',
          description = doclines[0],
          long_description = "\n".join(doclines[2:]),
          author = "Robert Hetland",
          author_email = "hetland@tamu.edu",
          packages = ['ann',],
          license = 'MIT',
          platforms = ["any",],
          ext_modules = [libann_wrap,],
          classifiers = filter(None, classifiers.split("\n")),
          )
    