
from numpy import *
from scikits.ann import kdtree
from ann import kd_tree

from time import time

dimensions = 3
k = 5

def scikits_ann(pts, qpts):
    tree = kdtree(pts)
    idx, d2 = tree.knn(qpts, k)
        
    return idx, d2

def ctypes_ann(pts, qpts):
    tree = kd_tree(pts)
    idx, d2 = tree.search(qpts, k)
    
    return idx, d2


if __name__ == '__main__':
    
    N = 50000
    pts = random.rand(N, dimensions)
    
    qpts = random.rand(N, dimensions)
    
    t1 = time()
    idx_sk, d2_sk = kdtree(pts).knn(qpts, k)
    t2 = time()
    idx_ct, d2_ct = kd_tree(pts).search(qpts, k)
    t3 = time()
    
    print 'Ctypes time %f seconds' % (t2-t1)
    print 'Scikits time %f seconds' % (t3-t2)
    print ''
    print 'All distances close: ', allclose(d2_sk, d2_ct)
    print 'All indices close: ', allclose(idx_sk, idx_ct)
    

