
from numpy import *
from ann import kd_tree
from scikits.ann import kdtree

from time import time

dimensions = 3
k = 5

def ctypes_ann(pts, qpts):
    tree = kd_tree(pts)
    idx, d2 = tree.search(qpts, k)
    return idx, d2

def scikits_ann(pts, qpts):
    tree = kdtree(pts)
    idx, d2 = tree.knn(qpts, k)
    return idx, d2

if __name__ == '__main__':
    
    N = 10000
    pts = random.rand(N, dimensions)
    qpts = random.rand(N, dimensions)
    
    for n in range(10000):
        idx_ct, d2_ct = ctypes_ann(pts, qpts)
        # idx_ct, d2_ct = scikits_ann(pts, qpts)


