--**************************************
--                                    
--**************************************
::CLASS RECORDTYPE


/**************************************/
/*                                    */
/**************************************/
::CLASS CERTIFICATE subclass RECORDTYPE Public 
::Attribute CertKey                    -- SITECERT/CERTAUTH.F1WW001 or userid if not type SITE or CERT
::Attribute Type                       -- SITECERT/CERTAUTH or USER
::Attribute Suffix                     -- number or if Type SITE/CERT then key (f1ww, vol****)
::Attribute Serial
::Attribute Subject
::Attribute Altname                   --
::Attribute Issuer      				
::Attribute ValidDates                 -- array of dates (after/before)
::Attribute Keyrings                   -- array of keyrings obj
::Attribute Label
::Attribute Usage
::Attribute Keysize
::Attribute KeyUsage
::Attribute Status
::Attribute PrivateKey
   
::Attribute mode   

--**************************************
--                                    
--**************************************
::Method Init
use arg theKey,label='',usage=''
	self~CertKey    = theKey~strip
	
	self~Keyrings            = .array~new
	self~keyrings~objectname = 'Keyrings'
	
	self~ValidDates = .array~new
	
	parse var theKey myType '.' self~Suffix . 
	if 'SITECERT CERTAUTH'~pos(myType) = 1 then do
		self~Type = myType
   end
  else
    self~Type = 'USER'
    
  self~label = label  
  self~usage = usage
/**************************************/
/*                                    */
/**************************************/
::Method keyringInsertItem public
use arg key,ring
   kr = .keyring~new(key,ring)
   self~Keyrings~append(kr) 
/**************************************/
/*                                    */
/**************************************/
::Method Validfrom public
use arg data
   self~validDates~put(data,1) 

/**************************************/
/*                                    */
/**************************************/
::Method ValidTo public
use arg data
   self~validDates~put(data,2) 

/**************************************/
/*                                    */
/**************************************/
::Method ExpiresInDays
	indate = self~Validdates~at(2)~word(1)~strip
Return(DATE("B",DATE("S",indate,"S","","/"),"S") - date("B"))
/**************************************/
/*                                    */
/**************************************/
::Method name public
use arg data
   return(self~certKey)   
--
--
--
::CLASS KEYRING subclass RECORDTYPE Public
::Attribute name                    -- SITECERT/CERTAUTH.F1WW001 or userid if not type SITE or CERT
::Attribute ringname                    -- SITECERT/CERTAUTH or USER
::Attribute default
::Attribute certificates            -- array of connected certificate obj
::Attribute virtualRings            -- array of virtual rings


::method init
use arg key,ring
	self~name       	= key
	self~objectname 	= 'Keyring'
	
	self~ringname   	       = ring
	self~ringname~objectname = 'Ringname'
	
	self~certificates = .array~new
	self~virtualRings = .array~new
	
	Self~virtualRings~objectname = 'VirtualRings'
	Self~certificates~objectname = 'Certificates'
	
::Method certificateInsertItem
use arg key,label='',usage=''
   obj = .certificate~new(key,label,usage)
   self~certificates~append(obj) 	
   
::Method virtualRingsInsertItem
use arg key
   self~virtualRings~append(key) 	
