/******************************************************************/
/*  OOREXX  ooDialog 4.2                                          */
/*  Volvo IT                                                      */
/*  by hex 2011-01-06                                             */
/*  Show RACF certrecords from flatfile                           */
/******************************************************************/
/******************************************************************/
/* REXX  */
parse source . . s
s = s~reverse; parse var s s "\" . ; s = s~reverse; parse var s program "." .
dialogName = program
version    = "v1.0"
dialog:
.PlainBaseDialog~setDefaultFont("Segoe UI", 9)
.application~useGlobalConstDir("O", dialogName".h")
dlg  = .MyDialog~new(dialogName".rc", IDD_DIALOG1)

if dlg~initCode = 0 then do
   dlg~dialogName = dialogName
   dlg~version    = version
   call HideConsole
   --dlg~addIconResource(IDI_ICON1, "zosteam.ico")
   dlg~execute("SHOWTOP", IDI_ICON1)

end
exit

/************************************************************/
/*                                                          */
/************************************************************/
HideConsole:
/* get an instance of the WindowsManager class */

	winMgr = .WindowsManager~new
	if winMgr~initcode \= 0 then exit
	myConsole = winMgr~consoletitle
	
/* get the windows object for our console */

	myRexx = winMgr~Find(myConsole)
	if myRexx = .nil then
  	 nop
	 else
  	 myrexx~hide

return

::requires "winSystm.cls"
::requires "ooDialog.cls"
::requires certrecords.cls
/************************************************************/
/**                                                         */
/************************************************************/
::class MyDialog subclass rcDialog 
::Attribute dialogName 
::Attribute version

::Attribute listFont

::Attribute List1_selection
::attribute tree1_selection
::attribute destinations
::attribute nodesin
::Attribute Current_Cursor

::Attribute remark
/************************************************************/
/**                                                         */
/************************************************************/
::method InitDialog
expose  CERTtype typeCERT
forward class (super) continue
	self~myMenuBar
	self~myHelpAbout
	self~myFonts
	self~myButtons
	self~myEditFields
	
	OKbutton      = self~newPushButton("IDCANCEL")   
	  
  typeCERTDATA = self~newRadioButton("IDC_TYPE_CERTDATA")
  --typeKEYRING  = self~newRadioButton("IDC_TYPE_KEYRING")
  CERTtype     = .array~of(typeCERTDATA)
  typeCERTDATA~check
  do type over CERTtype
  	if type~checked then do
				typeCERT = type~title
				leave
		end  	
	end  
  self~myMenuItems
	self~myControls
	self~myEvents
	self~myDisableItems
	self~Init_LISTBOX
return
/***************************************************/
/*   define dialog                                 */
/***************************************************/
::method help
NL   = '0d'x
text =       "View CERT records."||NL||NL
text = text||"Read an input file with RACF CERTAUTH and SITE certificate records"||nl||NL
text = text||"Create file from RACF with "||nl
text = text||" RACDCERT CERTAUTH LIST and"||nl
text = text||" RACDCERT SITE LIST"||nl||NL
text = text||" Concatinate the output inte one file (SITE last)"||nl
text = text||" and transfer file to PC and open file in this program"||nl
call infodialog(text)
return
/************************************************************/
/* About menuitem                                           */
/*                                                          */
/************************************************************/
::method About
NL   = '0d'x
text = self~version||NL
text = text||"by Hex (2012) Volvo IT"||NL||NL
text = text||"Requires ooDialog 4.2.0 or greater"||NL
text = text||"http://sourceforge.net/projects/oorexx/"||NL
text = text||"http://www.oorexx.org/"
call infodialog(text)
return

::method cancel unguarded

return 0 --self~cancel:super
/************************************************************/
/*                                                          */
/************************************************************/
::method initAutoDetection
  self~noAutoDetection
--***************************************************
-- Open file and create cert objects
--***************************************************
::METHOD FileOpen 
expose keytable 
	call openfile("Load File")
	if result = 0 then
	   return
	filename = result   
	
	self~processfile(filename)

	self~fill_LISTBOX

--***************************************************
-- Connect all menu items here
--***************************************************
::Method myMenuItems
expose menubar
  menubar~connectCommandEvent(IDM_FILE_OPEN,"FileOpen")
  /*
	self~ConnectMenuItem(IDM_FILE_NEW,"FileNew")
	self~ConnectMenuItem(IDM_FILE_OPEN,"FileOpen")
	self~ConnectMenuItem(IDM_FILE_SAVE,"FileSave")
	self~ConnectMenuItem(IDM_FILE_SAVEAS,"FileSaveAS")
	self~ConnectMenuItem(IDM_EDIT_COPY,"EditCopy")
	self~ConnectMenuItem(IDM_EDIT_Paste,"EditPaste")
*/
	
--***************************************************
-- Connect buttons here
--***************************************************
::Method myButtons


--***************************************************
-- connect edit fields and edit Notify
--***************************************************
::Method myEditFields
	

--***************************************************
-- connect menubar
--***************************************************
::Method myMenuBar
expose menubar
	menubar = .scriptmenubar~new(self~dialogName".rc",IDR_MENU1) 
	menubar~attachto(self)

--***************************************************
-- connect help/about 
--***************************************************
::Method myHelpAbout

	self~connectMenuItem(IDM_HELP,Help)
	self~ConnectHelp(help)                      -- connect to F1 (Windows Help)
	self~ConnectMenuItem(IDM_ABOUT,About)

--***************************************************
-- connect events
--***************************************************
::Method myEvents

	self~connectListViewEvent(IDC_LIST1,   "CLICK", LIST1_Click)

--***************************************************
-- connect fonts
--***************************************************
::Method myFonts

--self~listFont  = self~createFontEx("Lucida Sans Unicode",10)
	--self~listFont  = self~createFontEx("Courier New",10)
	--self~listFont  = self~createFontEx("Consolas",10)
self~listFont  = self~createFontEx("Calibri",10)


--***************************************************
-- Init of controls
--***************************************************
::Method myControls
expose menubar
	menubar~Enable("IDM_FILE_OPEN")
	
--***************************************************
-- Disable Items initial
--***************************************************
::METHOD myDisableItems
	

/************************************************************/
/* Initialize listbox                                       */
/*                                                          */
/************************************************************/ 
::METHOD Init_LISTBOX unguarded
expose list CERTtype typeCERT tree
	List = self~newListView(IDC_LIST1)    
	list~setFont(self~listFont)   
  if tree~isa(.treeview) then do
		tree~deleteAll
	end	  
	if list~isa(.listview) then 
		 list~deleteAll           
				                          
	if List \= .Nil then do    
	  do type over CERTtype
	  	if type~checked then do
					typeCERT = type~title
					leave
			end  	
		end  
	    list~addExtendedStyle("BORDERSELECT")  
	    list~addStyle("SHOWSELALWAYS")                                         
	  	list~setImageList(imageList, .Image~toID(LVSIL_SMALL))    
	  --list~addExtendedStyle("CHECKBOXES FULLROWSELECT")  
		  list~addExtendedStyle("FULLROWSELECT")           
	  -- create columns in report list   
                                
	  	list~InsertColumn(0,"Certificate labels",100,"LEFT")                      
	--	  list~InsertColumn(1,"SYSID",30,"CENTER")  
	--	  list~InsertColumn(2,"Remark",80,"LEFT") 
	end   
return
/************************************************************/
/* Get all key for selected type                            */
/*                                                          */
/************************************************************/ 
::Method fill_LISTBOX unguarded 
expose list keytable tree
	if list~isa(.listview) then 
		 list~deleteAll   
  if tree~isa(.treeview) then do
		tree~deleteAll
	end	  		         
	theKeys = keytable~makearray~sortWith(.CaselessColumnComparator~new(1,40)) 

	do key over theKeys
  	list~addrow(,,keytable~at(key)~label)
	end    



/************************************************************/
/* Listbox is selected                                      */
/*                                                          */
/************************************************************/
::Method LIST1_Click unguarded
expose list keytable 
use arg id, itemIndex, columnIndex, keyState

	if itemindex = -1 then return       -- listitem not clicked
	self~cursorWait
	self~newStatic(IDC_MSG)~setText(" ")
	focusedItem = list~focused
	
	key = list~itemtext(focusedItem,0)
	self~addToTree(keytable~at(key~strip))

	self~cursorNormal

---
-- Add certificate to tree
---
::Method addToTree
expose tree keytable
use arg myObj
  tree = self~newTreeView("IDC_TREE1")
  tree~setFont(self~listFont) 
	tree~deleteAll
  tree~subclassEdit
	tree~add(myObj~label,,,"EXPANDED")
	tree~add(,myObj~Usage,,,"BOLD")
	if myobj~expiresInDays < 1 then	
		tree~add(,"Certificate expired" myobj~expiresInDays "days ago")
	 else
	  if myobj~expiresInDays < 60 then
		  tree~add(,"Certificate expires in" myobj~expiresInDays "days",,,"BOLD")
	tree~add(,"ID")
	tree~add(,,myObj~CertKey)
	tree~add(,"STATUS",,,"EXPANDED")
	tree~add(,,myObj~status)
	tree~add(,"SERIAL")   
	tree~add(,,myObj~serial)
	tree~add(,"SUBJDN")
	tree~add(,,myObj~subject)
	tree~add(,"ISSUER")
	tree~add(,,myObj~issuer)
	
	if myObj~altname <> ' ' then do
		tree~add(,"SUBJECT ALTNAME")
		tree~add(,,myObj~altname)
	end
	
	if myobj~status <> 'NOTRUST' & myObj~keyusage <> ' 'then do
		--tree~add(,"KEY")
		tree~add(,'KEY USAGE =' myObj~keyusage) 
		
		if myobj~keysize <> ' ' then
			tree~add(,'Keysize =' myObj~keysize) 
		if myObj~privateKey <> ' ' then	 
			tree~add(,'Private Key:' myObj~privateKey) 
		
	end	
	
	tree~add(,"VALID")
	tree~add(,,"Not before" myObj~validdates~at(1))
	tree~add(,,"Not after   " myObj~validdates~at(2))

  x = tree~add(,"KEYRINGS",,,"EXPANDED")	 -- just to get last expandmark(+)
  tree~delete(x)
  if myObj~keyrings~items > 0 then do
	  tree~add(,"Connected to keyring",,,"EXPANDED")	
		do keyring over myObj~keyrings
			 tree~add(,,keyring~name)
		   tree~add(,,,"RINGNAME")
		 	 tree~add(,,,,keyring~ringname)
		end	
		x = tree~add(,,' ')                  -- just to get last expandmark(+)
		tree~delete(x)                         -- delete dummy
  end
--
--
--
/************************************************************/
/* Cursor shape                                             */
/*                                                          */
/************************************************************/

::method cursorWait	
expose oldCursor mouse

	mouse = .Mouse~new(self)
	self~Current_Cursor = mouse~getCursorPos
	oldCursor = mouse~wait
	self~Current_Cursor~incr
	mouse~setCursorPos(self~Current_Cursor)

::method cursorNormal
expose oldCursor mouse

-- Restore the cursor.
	self~Current_Cursor~decr
	mouse~restoreCursor(oldCursor)
	mouse~setCursorPos(self~Current_Cursor)
	

---
-- Process infile 
-- parse input
-- build certobj
-- 
---    
::METHOD processFile
arg file
   signal on notready
   f = .stream~new(file)
	 f~open('Read')
   inrecord    = .MutableBuffer~new("")
   workrecord  = .MutableBuffer~new("")
   certrec     = .array~new
   CertType    = 'CERTAUTH'
   CertTypeChanged = .false
   got_record  = .false
   do forever
   	  s = f~linein~strip
   	  if s~pos('Digital certificate information for SITE:') = 1 then
   	    do
   	     CertTypechanged = .true  --we will change when current record is written
   	     iterate
   	    end 
   	  inrecord~Delete(1)
  	  inrecord~Append(s) --~left(80)
  	  
      If inrecord~pos("Label:") > 0 Then do
      	 if got_record then do
      	 	  certrec~append(certType||workrecord~string~translate('. ','..')~strip) 
      	 	  workrecord~delete(1)
            got_record = .false
            if certtypechanged then
               CertType = 'SITECERT'
         end
         got_record = .true
     end     
     if got_record then do
        workrecord~append(inrecord~string~translate('','<')~strip~translate('','>')~strip('L'))   
     end
           
   end
 
notready:
	f~close
	if got_record then 
     certrec~append(certType||workrecord~string~translate('. ','..')~strip) 
     
	self~buildcert(certrec)
	
---
--
---
::Method buildcert
expose keytable
use arg theObj 

	Thecerts = .array~new  -- here we get all certobjects in
	do cert over theObj
  	 thecerts~append(self~parseInputfile(cert))
	end
-- now whe have the cert objects and time to use them

	keytable = .table~new
	do thisCertificate over thecerts 
      keytable~put(thiscertificate,thisCertificate~label)  -- label as key in table
	end

return

---
--
---
::METHOD parseInputfile
use arg record
	CertType = 'CERTAUTH'
	if record~pos('SITE') = 1 then
	   CertType = 'SITECERT'

	Parse var record . 'Label:' w_label 'Certificate ID:' w_certid 'Status:' w_trust 'Start Date:' w_sdate 'End Date:' w_edate 'Serial Number:' w_serial 'Issuer' .
	parse var record . "Issuer's Name:" w_issuer 'Subject' .
	w_keyusage = ''
	w_domain   = ''
	w_keysize  = ''
	w_privatekey = ''

if record~pos('Key Type: RSA') > 0 then do
	if record~pos('AltNames:') > 0 then           
		parse var record . "Subject's Name:" w_subject "Subject's AltNames:" w_domain  'Key Usage:' w_keyusage 'Key Type' .
	 else
	  if record~pos('Key Usage:') > 0 then
	    parse var record . "Subject's Name:" w_subject 'Key Usage:' w_keyusage 'Key Type' .
	   else
	    parse var record . "Subject's Name:" w_subject 'Key Type' .
    
	if record~pos('Key Size') > 0 then  
		parse var record . 'Key Type:' w_keytype 'Key Size:' w_keysize 'Private Key:' w_privateKey 'Ring Associ' .
	 else
	  parse var record . 'Key Type:' w_keytype 'Private Key:' w_privateKey 'Ring Associations' .
end 
 else
 do 
	if record~pos('AltNames:') > 0 then           
		parse var record . "Subject's Name:" w_subject "Subject's AltNames:" w_domain  'Key Usage:' w_keyusage 'Private Key Type' .
	 else
	  if record~pos('Key Usage:') > 0 then
	    parse var record . "Subject's Name:" w_subject 'Key Usage:' w_keyusage 'Private Key Type' .
	   else
	    parse var record . "Subject's Name:" w_subject 'Private Key Type' .
    
	if record~pos('Key Size') > 0 then  
		parse var record . 'Private Key Type:' w_keytype 'Private Key Size:' w_keysize 'Ring Associ' .
	 else
	  parse var record . 'Private Key Type:' w_keytype 'Ring Associations' .
 
 end
 
 
	thisCert          = .certificate~new(w_certid~strip,w_label~strip)
	
	thisCert~serial   = w_serial~strip
	thisCert~issuer   = w_issuer~strip
	thisCert~subject  = w_subject~strip
	thisCert~altname  = w_domain~strip
	thisCert~keyusage = w_keyusage~strip
	thisCert~keysize  = w_keysize~strip
	thisCert~privateKey = w_privatekey
	thisCert~status   = w_trust~strip
	thisCert~validfrom(w_sdate~strip)
	thisCert~validto(w_edate~strip)


	parse var record . 'Ring Associations:' w_rings

	if w_rings~pos('***') = 0 then do
	   tmp = w_rings
	   do w_rings~countStr('Owner:')
	      parse var tmp . 'Owner:' w_owner 'Ring:' w_ring 'Ring Owner:' tmp
	       tmp = 'Ring Owner:'||tmp
	       thisCert~keyringInsertItem(w_owner~strip,w_ring~strip)
	   end
	end  
	thisCert~Usage = CertType
 
return (thisCert)

/***************************************************/
/*                                                 */
/***************************************************/
::Routine OpenFile
--use arg mytitle
    selfile       = '.\'                    -- start in current directory
    parent        = ''                      -- don't need this in this example - just a place holder
    filemask      = 'All Files (*.*)'
    loadorsave    = 'LOAD'                      -- Load is the default
    title         = 'RACF Input file'                 -- See documentation for default
    defExtension  = ''                      -- don't need this in this example - just a place holder
    multiSelect   = ''                      -- don't need this in this example - just a place holder
    sepChar       = ''                      -- don't need this in this example - just a place holder
    filename = FileNameDialog(selfile,parent,filemask,loadorsave,title,defExtension,multiSelect,sepChar)
    return(FileName)	