#!/bin/sh
CFLAGS="-O2"

test()
{
    echo "Testing $1: "
    
    if grep "COMPILE ONLY" $1 > /dev/null; then
        if opencc -fopenmp -c ${CFLAGS} $1; then
            echo "PASS!"
        else
            echo "FAIL!"
        fi
    else
        opencc -fopenmp ${CFLAGS} $1 && ./a.out
    fi
    echo ""
}

for X in *.c; do
    test $X
done

rm -f *.o a.out