#!/bin/sh

.  ./config.sh

(
time \
(

echo "HOST_NAME=${HOST_NAME}"

WITH_ARCH=
case  ${HOST_NAME} in
        x86_64-*-linux*)
          WITH_ARCH="--with-arch_32=i686" ;;
        i686-*-linux*)
          WITH_ARCH="--with-arch=i686" ;;
        *)
          echo "unsupported Linux."
          exit 1 ;;
esac
echo "WITH_ARCH=${WITH_ARCH}"

if [ "${BUILD_IN_PARALLEL_MAKE}" = "yes" ] ;
then
    MAKE_J_OPTION="-j3"
else
    MAKE_J_OPTION=
fi
echo "MAKE_J_OPTION=${MAKE_J_OPTION}"


if [ "${BUILD_ALL}" = "yes" ] ;
then
    ENABLE_LANGUAGES="--enable-languages=c,c++,objc,obj-c++,fortran,ada,go,lto"
else
    ENABLE_LANGUAGES="--enable-languages=c,c++"
fi
echo "ENABLE_LANGUAGES=${ENABLE_LANGUAGES}"




if [ "${BUILD_AND_INSTALL_AGAIN}" = "yes" ] ;
then
    true
else
    rm -rf "${BUILD_DIR}" "${INSTALL_DIR}"  \
    && mkdir -p "${BUILD_DIR}"
fi  \
\
\
\
&& pushd  "${BUILD_DIR}"  \
&& if [ "${BUILD_AND_INSTALL_AGAIN}" = "yes" ] ;
   then
       true
   else
       ../${SRC_DIR}/configure \
       --prefix=/usr/local  \
       --enable-bootstrap  \
       --enable-shared --enable-threads=posix \
       --enable-checking=release \
       --with-system-zlib --enable-__cxa_atexit \
       --disable-libunwind-exceptions --enable-gnu-unique-object --enable-linker-build-id \
       ${ENABLE_LANGUAGES} \
       --enable-plugin --enable-java-awt=gtk \
       --disable-dssi --with-java-home=/usr/lib/jvm/java-1.5.0-gcj-1.5.0.0/jre \
       --enable-libgcj-multifile \
       --enable-java-maintainer-mode \
       --with-ecj-jar=/usr/share/java/eclipse-ecj.jar \
       --disable-libjava-multilib \
       \
       \
       --with-tune=generic \
       "${WITH_ARCH}" \
       --build=${HOST_NAME} \
       #--with-ppl --with-cloog
   fi  \
&& make STAGE1_CFLAGS="-O2 -g" ${MAKE_J_OPTION}  \
&& rm -rf "../${INSTALL_DIR}" && mkdir -p "../${INSTALL_DIR}"  \
&& make install-strip DESTDIR="`pwd`/../${INSTALL_DIR}"  \
&& popd \
\
&& pushd "${INSTALL_DIR}/usr/local"  \
&& tar -cjf  "../../../${BIN_TAR_BALL_NAME}"   *  \
&& popd

)

) 2>&1 | tee  "${OUTPUT_FILE_NAME}"
