#!/bin/sh

.  ./config.sh

(
time \
(

echo "HOST_NAME=${HOST_NAME}"



if [ "${BUILD_IN_PARALLEL_MAKE}" = "yes" ] ;
then
    MAKE_J_OPTION="-j3"
else
    MAKE_J_OPTION=
fi
echo "MAKE_J_OPTION=${MAKE_J_OPTION}"

if [ "${BUILD_ALL}" = "yes" ] ;
then
    DISABLE_FORTRAN=
else
    DISABLE_FORTRAN="--disable-fortran"
fi
echo "DISABLE_FORTRAN=${DISABLE_FORTRAN}"



if [ "${BUILD_AND_INSTALL_AGAIN}" = "yes" ] ;
then
    true
else
    rm -rf "${BUILD_DIR}" "${INSTALL_DIR}"  \
    && mkdir -p "${BUILD_DIR}"
fi  \
\
\
\
&& pushd  "${BUILD_DIR}"  \
&& if [ "${BUILD_AND_INSTALL_AGAIN}" = "yes" ] ;
   then
       true
   else
       ../${SRC_DIR}/configure  \
       ${DISABLE_FORTRAN} \
       --disable-host_bdver1-support \
       --with-build-optimize=DEFAULT \
       --with-build-compiler=GNU \
       --prefix="`cd .. && pwd`/${INSTALL_DIR}/usr/local"
   fi  \
&& make ${MAKE_J_OPTION}  \
&& rm -rf "../${INSTALL_DIR}" && mkdir -p "../${INSTALL_DIR}"  \
&& make install \
&& popd \
\
&& pushd "${INSTALL_DIR}/usr/local"  \
&& tar -cjf  "../../../${BIN_TAR_BALL_NAME}"   *  \
&& popd

)

) 2>&1 | tee  "${OUTPUT_FILE_NAME}"
