#include <rx/xdr.h>
#include <afs/auth.h>
#include <afs/kautils.h>

#include <stdio.h>
#include <stdlib.h>

#include <curses.h>

WINDOW * init_curses() { /* Init curses */
	WINDOW * terminal;
	terminal = initscr();

	/* disable flush output when interrupt key */
	intrflush(terminal, FALSE);

	/* don't clear screen on refresh */
	clearok(terminal, FALSE);

	noecho();

	return terminal;
}

void cleanup (WINDOW *scr) { /* End curses */
	endwin();
}

void obtaintokens(char * uname, char *pw, char *cell) {

	int lifetime;
	int code, local;

	char *reason; /* error string */
	afs_int32 password_expires = -1;

	lifetime=0;
	code = ka_CellToRealm(cell, cell, &local);

	/* init ka */
	code = ka_Init(0);
	if (code) {
		rx_Finalize();
		return;
	}

	/* Authenticate */
	code = ka_UserAuthenticateGeneral(KA_USERAUTH_VERSION, uname, "", cell, pw, lifetime, &password_expires, 0, &reason);

	/* End */
	rx_Finalize();
}


void main (void) {
	WINDOW *scr;
	char *myCell;

	char *uname;
	char *pw;


	uname = malloc(1024);
	pw = malloc(1024);
	myCell = malloc(1024);

	scr = init_curses();

	printw("\n\nYou should start a \"watch tokens\" command in another terminal to see the results\n\n");

	while (1) {
		echo();


		printw("\nCell name: ");
		scanw("%s", myCell);

		printw("\nUsername: ");
		scanw("%s", uname);
		
		printw("Password: ");
		noecho();
		scanw("%s", pw);

		obtaintokens(uname, pw, myCell);
	}
	cleanup(scr);


}
