# Before `make install' is performed this script should be runnable with
# `make test'. After `make install' it should work as `perl 1.t'

#########################

# change 'tests => 2' to 'tests => last_test_to_print';

use Test;
BEGIN { plan tests => 2 };
use OpenCA::OpenSSL::Fast;
ok(1); # If we made it this far, we're ok.


my $fail;
foreach my $constname (qw(
	CTX_TEST EXFLAG_BCONS EXFLAG_CA EXFLAG_INVALID EXFLAG_KUSAGE
	EXFLAG_NSCERT EXFLAG_SET EXFLAG_SS EXFLAG_V1 EXFLAG_XKUSAGE EXT_END
	GEN_DIRNAME GEN_DNS GEN_EDIPARTY GEN_EMAIL GEN_IPADD GEN_OTHERNAME
	GEN_RID GEN_URI GEN_X400 KU_CRL_SIGN KU_DATA_ENCIPHERMENT
	KU_DECIPHER_ONLY KU_DIGITAL_SIGNATURE KU_ENCIPHER_ONLY KU_KEY_AGREEMENT
	KU_KEY_CERT_SIGN KU_KEY_ENCIPHERMENT KU_NON_REPUDIATION NS_OBJSIGN
	NS_OBJSIGN_CA NS_SMIME NS_SMIME_CA NS_SSL_CA NS_SSL_CLIENT
	NS_SSL_SERVER X509V3_EXT_CTX_DEP X509V3_EXT_DYNAMIC
	X509V3_EXT_MULTILINE X509V3_F_COPY_EMAIL X509V3_F_COPY_ISSUER
	X509V3_F_DO_EXT_CONF X509V3_F_DO_EXT_I2D X509V3_F_HEX_TO_STRING
	X509V3_F_I2S_ASN1_ENUMERATED X509V3_F_I2S_ASN1_INTEGER
	X509V3_F_I2V_AUTHORITY_INFO_ACCESS X509V3_F_NOTICE_SECTION
	X509V3_F_NREF_NOS X509V3_F_POLICY_SECTION X509V3_F_R2I_CERTPOL
	X509V3_F_S2I_ASN1_IA5STRING X509V3_F_S2I_ASN1_INTEGER
	X509V3_F_S2I_ASN1_OCTET_STRING X509V3_F_S2I_ASN1_SKEY_ID
	X509V3_F_S2I_S2I_SKEY_ID X509V3_F_STRING_TO_HEX X509V3_F_SXNET_ADD_ASC
	X509V3_F_SXNET_ADD_ID_INTEGER X509V3_F_SXNET_ADD_ID_ULONG
	X509V3_F_SXNET_GET_ID_ASC X509V3_F_SXNET_GET_ID_ULONG
	X509V3_F_V2I_ACCESS_DESCRIPTION X509V3_F_V2I_ASN1_BIT_STRING
	X509V3_F_V2I_AUTHORITY_KEYID X509V3_F_V2I_BASIC_CONSTRAINTS
	X509V3_F_V2I_CRLD X509V3_F_V2I_EXT_KU X509V3_F_V2I_GENERAL_NAME
	X509V3_F_V2I_GENERAL_NAMES X509V3_F_V3_GENERIC_EXTENSION
	X509V3_F_X509V3_ADD_VALUE X509V3_F_X509V3_EXT_ADD
	X509V3_F_X509V3_EXT_ADD_ALIAS X509V3_F_X509V3_EXT_CONF
	X509V3_F_X509V3_EXT_I2D X509V3_F_X509V3_GET_VALUE_BOOL
	X509V3_F_X509V3_PARSE_LIST X509V3_F_X509_PURPOSE_ADD
	X509V3_R_BAD_IP_ADDRESS X509V3_R_BAD_OBJECT X509V3_R_BN_DEC2BN_ERROR
	X509V3_R_BN_TO_ASN1_INTEGER_ERROR X509V3_R_DUPLICATE_ZONE_ID
	X509V3_R_ERROR_CONVERTING_ZONE X509V3_R_ERROR_IN_EXTENSION
	X509V3_R_EXPECTED_A_SECTION_NAME X509V3_R_EXTENSION_NAME_ERROR
	X509V3_R_EXTENSION_NOT_FOUND X509V3_R_EXTENSION_SETTING_NOT_SUPPORTED
	X509V3_R_EXTENSION_VALUE_ERROR X509V3_R_ILLEGAL_HEX_DIGIT
	X509V3_R_INVALID_BOOLEAN_STRING X509V3_R_INVALID_EXTENSION_STRING
	X509V3_R_INVALID_NAME X509V3_R_INVALID_NULL_ARGUMENT
	X509V3_R_INVALID_NULL_NAME X509V3_R_INVALID_NULL_VALUE
	X509V3_R_INVALID_NUMBER X509V3_R_INVALID_NUMBERS
	X509V3_R_INVALID_OBJECT_IDENTIFIER X509V3_R_INVALID_OPTION
	X509V3_R_INVALID_POLICY_IDENTIFIER X509V3_R_INVALID_SECTION
	X509V3_R_INVALID_SYNTAX X509V3_R_ISSUER_DECODE_ERROR
	X509V3_R_MISSING_VALUE X509V3_R_NEED_ORGANIZATION_AND_NUMBERS
	X509V3_R_NO_CONFIG_DATABASE X509V3_R_NO_ISSUER_CERTIFICATE
	X509V3_R_NO_ISSUER_DETAILS X509V3_R_NO_POLICY_IDENTIFIER
	X509V3_R_NO_PUBLIC_KEY X509V3_R_NO_SUBJECT_DETAILS
	X509V3_R_ODD_NUMBER_OF_DIGITS X509V3_R_UNABLE_TO_GET_ISSUER_DETAILS
	X509V3_R_UNABLE_TO_GET_ISSUER_KEYID
	X509V3_R_UNKNOWN_BIT_STRING_ARGUMENT X509V3_R_UNKNOWN_EXTENSION
	X509V3_R_UNKNOWN_EXTENSION_NAME X509V3_R_UNKNOWN_OPTION
	X509V3_R_UNSUPPORTED_OPTION X509V3_R_USER_TOO_LONG X509_PURPOSE_ANY
	X509_PURPOSE_CRL_SIGN X509_PURPOSE_DYNAMIC X509_PURPOSE_DYNAMIC_NAME
	X509_PURPOSE_MAX X509_PURPOSE_MIN X509_PURPOSE_NS_SSL_SERVER
	X509_PURPOSE_SMIME_ENCRYPT X509_PURPOSE_SMIME_SIGN
	X509_PURPOSE_SSL_CLIENT X509_PURPOSE_SSL_SERVER XKU_CODE_SIGN XKU_SGC
	XKU_SMIME XKU_SSL_CLIENT XKU_SSL_SERVER)) {
  next if (eval "my \$a = $constname; 1");
  if ($@ =~ /^Your vendor has not defined OpenCA::OpenSSL::Fast macro $constname/) {
    print "# pass: $@";
  } else {
    print "# fail: $@";
    $fail = 1;    
  }
}
if ($fail) {
  print "not ok 2\n";
} else {
  print "ok 2\n";
}

#########################

# Insert your test code below, the Test::More module is use()ed here so read
# its man page ( perldoc Test::More ) for help writing this test script.

