#!/usr/bin/perl
# Test script to add entries to LDAP with a 0.5 second delay between adds, then once it has added 1000 in a row it removes them in reverse order, from newest to oldest.  It then repeats, going for up to 1000 rounds of adds and removes.
# It will open and close connections after a random number of operations has been performed.
use DBI;
use Net::LDAP;

my $ldap;
my $opencon = 0;
my $rand = 0;

for (my $j = 1; $j <= 1000; ++$j) {
  print "#### Round $j ####\n";

  # Add 1000 records.
  for (my $i = 0; $i < 1000; ++$i) {
    if ($opencon == 0) {
      $ldap = Net::LDAP->new( 'localhost', port => 389 ) or die 'Failed to connect to server.';
      $mesg = $ldap->bind("cn=Manager,dc=example,dc=net",password => "secret!");
      $opencon = 1;
      $rand = int(rand(10));
      print "\tOpen Connection.\n";
    } # end if
  
    $dn = 'uid=testaddldap'.$i.',ou=people,dc=example,dc=net';
  
    $result = $ldap->add($dn, 'attr' => [
        'uid' => 'testaddldap'.$i,
        'cn' => 'testaddldap'.$i,
        'sn' => 'testaddldap'.$i,
        'userPassword' => '{SSHA}$1$IJEFjixjlvixjlijero$9403450',
        'gidNumber' => 1,
        'uidNumber' => 999999991,
        'homeDirectory' => '/mailstore/testaddldap'.$i,
        'loginShell' => '/bin/false',
        'objectClass' => ['top', 'posixAccount', 'person', 'shadowAccount']
      ]
    );
  
    print 'testaddldap'.$i."\n";
    $result->code && warn "\tfailed to add entry testaddldap".$i.": ", $result->error;
    sleep 0.5;
  
    if ($opencon == 1) {
      if ($rand == 0) {
        $ldap->unbind();
        $opencon = 0;
        print "\tClose Connection.\n";
      } # end if
      else {
        --$rand;
      } # end else
    } # end if
  } # end for
  
  if ($opencon == 1) {
    $ldap->unbind();
    print "\tClose Connection.\n";
    $opencon = 0;
  } # end if

  # Remove the 1000 records just added.
  for (my $i = 999; $i >= 0; --$i) {
    if ($opencon == 0) {
      $ldap = Net::LDAP->new( 'localhost', port => 389 ) or die 'Failed to connect to server.';
      $mesg = $ldap->bind("cn=Manager,dc=example,dc=net",password => "secret!");
      $opencon = 1;
      $rand = int(rand(10));
      print "\tOpen Connection.\n";
    } # end if
  
    $dn = 'uid=testaddldap'.$i.',ou=people,dc=example,dc=net';
  
    $result = $ldap->delete($dn);
    print 'testaddldap'.$i."\n";
    $result->code && warn "\tfailed to delete entry testaddldap".$i.": ", $result->error;
    sleep 0.5;
  
    if ($opencon == 1) {
      if ($rand == 0) {
        $ldap->unbind();
        $opencon = 0;
        print "\tClose Connection.\n";
      } # end if
      else {
        --$rand;
      } # end else
    } # end if
  } # end for
  
  if ($opencon == 1) {
    $ldap->unbind();
    print "\tClose Connection.\n";
    $opencon = 0;
  } # end if

} # end outermost for
