##
##  ez-ipupdate.spec -- OpenPKG RPM Specification
##  Copyright (c) 2000-2003 The OpenPKG Project <http://www.openpkg.org/>
##  Copyright (c) 2000-2003 Ralf S. Engelschall <rse@engelschall.com>
##  Copyright (c) 2000-2003 Cable & Wireless <http://www.cw.com/>
##
##  Permission to use, copy, modify, and distribute this software for
##  any purpose with or without fee is hereby granted, provided that
##  the above copyright notice and this permission notice appear in all
##  copies.
##
##  THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
##  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
##  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
##  IN NO EVENT SHALL THE AUTHORS AND COPYRIGHT HOLDERS AND THEIR
##  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
##  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
##  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
##  USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
##  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
##  OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
##  OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
##  SUCH DAMAGE.
##

#   package information
Name:         ez-ipupdate
Summary:      Updating host name for many dynamic DNS services
URL:          http://www.gusnet.cx/proj/ez-ipupdate/
Vendor:       Angus Mackay
Packager:     The OpenPKG Project
Distribution: OpenPKG [EVAL]
Group:        DNS
License:      GPL
Version:      3.0.11b8
Release:      20030730

#   list of sources
Source0:      ftp://mirror/pub/networking/tools/ez-ipupdate/ez-ipupdate-%{version}.tar.gz
#Source0:      http://gusnet.cx/proj/ez-ipupdate/dist/ez-ipupdate-%{version}.tar.gz
Source1:      ez-ipupdate.conf

#   build information
Prefix:       %{l_prefix}
BuildRoot:    %{l_buildroot}
BuildPreReq:  OpenPKG, openpkg >= 20020206, gcc, getopt
PreReq:       OpenPKG, openpkg >= 20020206
AutoReq:      no
AutoReqProv:  no

%description
    A client for automaticly updating your EZ-IP.net, justlinux.com,
    dhs.org, dyndns.org, ods.org, gnudip.cheapnet.net, tzo.com,
    easydns.com dynamic hostname parameters. Includes daemon support
    that only sends updates if your IP address changes.

%prep
    %setup -q

%build
    #   config package
    CC="%{l_cc}" \
    CFLAGS="%{l_cflags -O} `getopt-config --cflags`" \
    CPPFLAGS="%{l_cppflags}" \
    LDFLAGS="%{l_ldflags} `getopt-config --ldflags`" \
    LIBS="`getopt-config --libs`" \
    ./configure --prefix=%{l_prefix}
    #   build package
    %{l_make} %{l_mflags}

%install
    rm -rf $RPM_BUILD_ROOT
    %{l_shtool} mkdir -f -p -m 755 $RPM_BUILD_ROOT%{l_prefix}/sbin
    %{l_shtool} mkdir -f -p -m 755 $RPM_BUILD_ROOT%{l_prefix}/etc/ez-ipupdate
    %{l_shtool} install -c -s ez-ipupdate $RPM_BUILD_ROOT%{l_prefix}/sbin/
    %{l_shtool} install -c -m 644 %{SOURCE ez-ipupdate.conf} $RPM_BUILD_ROOT%{l_prefix}/etc/ez-ipupdate/
    %{l_rpmtool} files -v -ofiles -r$RPM_BUILD_ROOT \
        %{l_files_std} \
	'%config %{l_prefix}/etc/ez-ipupdate/ez-ipupdate.conf'

%files -f files

%clean
    rm -rf $RPM_BUILD_ROOT

