##
##  top.spec -- OpenPKG RPM Specification
##  Copyright (c) 2000-2003 The OpenPKG Project <http://www.openpkg.org/>
##  Copyright (c) 2000-2003 Ralf S. Engelschall <rse@engelschall.com>
##  Copyright (c) 2000-2003 Cable & Wireless <http://www.cw.com/>
##
##  Permission to use, copy, modify, and distribute this software for
##  any purpose with or without fee is hereby granted, provided that
##  the above copyright notice and this permission notice appear in all
##  copies.
##
##  THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
##  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
##  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
##  IN NO EVENT SHALL THE AUTHORS AND COPYRIGHT HOLDERS AND THEIR
##  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
##  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
##  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
##  USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
##  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
##  OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
##  OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
##  SUCH DAMAGE.
##

#   package information
Name:         top
Summary:      A top process listing
URL:          http://www.groupsys.com/top/
Vendor:       William LeFebvre
Packager:     The OpenPKG Project
Distribution: OpenPKG [EVAL]
Group:        Filesystem
License:      unknown
Version:      3.5beta12
Release:      20030720

#   list of sources
Source0:      ftp://mirror/pub/tools/top/top-3.5beta12.tar.bz2
#Source0:      ftp://ftp.groupsys.com/pub/top/top-3.5beta12.tar.bz2

#   build information
Prefix:       %{l_prefix}
BuildRoot:    %{l_buildroot}
BuildPreReq:  OpenPKG, openpkg >= 20020206, gcc
PreReq:       OpenPKG, openpkg >= 20020206
AutoReq:      no
AutoReqProv:  no

%description
    "top" is a program that will give continual reports about the state of
    the system, including a list of the top cpu using processes.  Version 3
    of "top" has three primary design goals: provide an accurate snapshot of
    the system and process state, not be one of the top processes itself, be
    as portable as possible.

%prep
    %setup -q -n top-%{version}

%build
    case "%{l_target}" in
        *-freebsd* ) platform="freebsd-20" ;;
        *-linux* )   platform="linux"   ;;
        *-solaris* ) platform="sunos5" ;;
        * ) echo "Platform %{l_target} not supported" 1>&2; exit 1 ;;
    esac
    (
    echo "$platform"
    echo "yes"
    echo ""
    echo "nawk"
    echo "%{l_cc}"
    echo ""
    echo "%{l_cflags}"
    echo ""
    echo "-1"
    echo ""
    echo "5"
    echo "no"
    echo ""
    echo "%{l_susr}"
    echo ""
    echo ""
    echo "%{l_prefix}/bin"
    echo "%{l_prefix}/man/man1"
    echo "1"
    echo ""
    ) | ./Configure
    %{l_make} %{l_mflags}

%install
    rm -rf $RPM_BUILD_ROOT
    %{l_shtool} mkdir -f -p -m 755 $RPM_BUILD_ROOT%{l_prefix}/bin
    %{l_shtool} mkdir -f -p -m 755 $RPM_BUILD_ROOT%{l_prefix}/man/man1
    %{l_shtool} install -c -s top $RPM_BUILD_ROOT%{l_prefix}/bin/
    %{l_shtool} install -c top.1 $RPM_BUILD_ROOT%{l_prefix}/man/man1/
    setgid=""
    case "%{l_target}" in
        *-freebsd* ) setgid="kmem" ;;
        *-linux* )   setgid="kmem" ;;
        *-solaris* ) setgid="sys"  ;;
    esac
    %{l_rpmtool} files -v -ofiles -r$RPM_BUILD_ROOT \
        %{l_files_std} \
        "%attr(2755,%{l_musr},$setgid) %{l_prefix}/bin/top"

%files -f files

%clean
    rm -rf $RPM_BUILD_ROOT

