##
##  ant.spec -- OpenPKG RPM Package Specification
##  Copyright (c) 2000-2005 OpenPKG Foundation e.V. <http://openpkg.net/>
##  Copyright (c) 2000-2005 Ralf S. Engelschall <http://engelschall.com/>
##
##  Permission to use, copy, modify, and distribute this software for
##  any purpose with or without fee is hereby granted, provided that
##  the above copyright notice and this permission notice appear in all
##  copies.
##
##  THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
##  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
##  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
##  IN NO EVENT SHALL THE AUTHORS AND COPYRIGHT HOLDERS AND THEIR
##  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
##  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
##  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
##  USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
##  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
##  OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
##  OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
##  SUCH DAMAGE.
##

#   package version
%define       V_real  1.6.3
%define       V_opkg  1.6.3

#   package information
Name:         ant
Summary:      A Java based build tool
URL:          http://ant.apache.org/
Vendor:       Apache Software Foundation
Packager:     OpenPKG
Distribution: OpenPKG
Class:        EVAL
Group:        Development
License:      Apache Software License
Version:      %{V_opkg}
Release:      20050508

#   list of sources
Source0:      http://www.apache.org/dist/ant/binaries/apache-ant-%{V_real}-bin.tar.bz2
Source1:      ant.conf
Source2:      rc.ant

#   build information
Prefix:       %{l_prefix}
BuildRoot:    %{l_buildroot}
BuildPreReq:  OpenPKG, openpkg >= 20040130
PreReq:       OpenPKG, openpkg >= 20040130, JRE
AutoReq:      no
AutoReqProv:  no

%description
    Apache Ant is a Java based build tool. In theory it is kind of like make
    without make's wrinkles. In practice it has it's own wrinkles.

%track
    prog ant = {
        version   = %{version}
        url       = http://www.apache.org/dist/ant/binaries/
        regex     = apache-ant-(__VER__)-bin\.tar\.bz2
    }

%prep
    %setup -q -n apache-ant-%{V_real}

%build
    #   Note that there is nothing to build since the Ant binary distribution
    #   is used. The reason for that is that a Ant build would require other
    #   tools which build procedures depend on Ant which leads to a chicken
    #   and egg problem. But in the end this doesn't hurt very much since we
    #   are talking about Java byte code and shell scripts which are portable
    #   anyway.

%install
    rm -rf $RPM_BUILD_ROOT
    %{l_shtool} mkdir -f -p -m 755 \
        $RPM_BUILD_ROOT%{l_prefix}/bin \
        $RPM_BUILD_ROOT%{l_prefix}/etc/ant \
        $RPM_BUILD_ROOT%{l_prefix}/etc/rc.d \
        $RPM_BUILD_ROOT%{l_prefix}/share/ant \
        $RPM_BUILD_ROOT%{l_prefix}/share/ant/doc \
        $RPM_BUILD_ROOT%{l_prefix}/share/ant/html
    %{l_shtool} install -m 644 [A-Z]* welcome.html \
	$RPM_BUILD_ROOT%{l_prefix}/share/ant/doc
    tar cf - lib |
        (cd $RPM_BUILD_ROOT%{l_prefix}/share/ant && tar xf -)
    (cd docs; tar cf - . |
        (cd $RPM_BUILD_ROOT%{l_prefix}/share/ant/html && tar xf -))
    %{l_shtool} install -c -m 755 \
        -e 's;/etc/ant.conf;%{l_prefix}/etc/ant/ant.conf;' \
        bin/ant $RPM_BUILD_ROOT%{l_prefix}/bin/
    %{l_shtool} install -c -m 644 \
        -e 's;@l_prefix@;%{l_prefix};' \
        %{SOURCE ant.conf} $RPM_BUILD_ROOT%{l_prefix}/etc/ant/
    %{l_shtool} install -c -m 755 \
        -e 's;@l_prefix@;%{l_prefix};' \
        %{SOURCE rc.ant} $RPM_BUILD_ROOT%{l_prefix}/etc/rc.d/
    %{l_rpmtool} files -v -ofiles -r$RPM_BUILD_ROOT %{l_files_std} \
        '%config %{l_prefix}/etc/ant/ant.conf'

%files -f files
    %docdir %{l_prefix}/share/ant/doc
    %docdir %{l_prefix}/share/ant/html

%clean
    rm -rf $RPM_BUILD_ROOT

