#!/bin/sh
#                 Sun Public License Notice
# 
# The contents of this file are subject to the Sun Public License
# Version 1.0 (the "License"). You may not use this file except in
# compliance with the License. A copy of the License is available at
# http://www.sun.com/
# 
# The Original Code is NetBeans. The Initial Developer of the Original
# Code is Sun Microsystems, Inc. Portions Copyright 1997-2004 Sun
# Microsystems, Inc. All Rights Reserved.

l_prefix="@l_prefix@"
NB_HOME="$l_prefix/share/netbeans"

if [ -f $l_prefix/etc/netbeans/netbeans.conf ] ; then
    . $l_prefix/etc/netbeans/netbeans.conf
fi

args="$@"

userdir=${netbeans_default_userdir}
while [ $# -gt 0 ] ; do
    case "$1" in
        --userdir) shift; if [ $# -gt 0 ] ; then userdir=$1; fi
            ;;
    esac
    shift
done

if [ -f "${userdir}"/etc/netbeans.conf ] ; then
    . "${userdir}"/etc/netbeans.conf
fi

netbeans_clusters=""
for i in nb4.1 ide5 enterprise1 profiler1 mobility7.1 extra ; do
    if [ -d "$NB_HOME/$i" ] ; then
        netbeans_clusters="$netbeans_clusters:$NB_HOME/$i"
    fi
done

if [ ! -z "$netbeans_extraclusters" ] ; then
    netbeans_clusters="$netbeans_clusters:$netbeans_extraclusters"
fi

nbexec="$NB_HOME/platform5/lib/nbexec"

case "`uname`" in
    Darwin*)
        "$nbexec" \
            --jdkhome "$netbeans_jdkhome" \
            -J-Dcom.apple.mrj.application.apple.menu.about.name=NetBeans \
            -J-Xdock:name=NetBeans \
            "-J-Xdock:icon=$NB_HOME/nb4.1/netbeans.icns" \
            --branding nb \
            --clusters "$netbeans_clusters" \
            --userdir "${userdir}" \
            -J-Dnetbeans.importclass=org.netbeans.upgrade.AutoUpgrade \
            ${netbeans_default_options} \
            $args &
        ;;
    *)
        "$nbexec" \
            --jdkhome "$netbeans_jdkhome" \
            --branding nb \
            --clusters "$netbeans_clusters" \
            --userdir "${userdir}" \
            -J-Dnetbeans.importclass=org.netbeans.upgrade.AutoUpgrade \
            ${netbeans_default_options} \
            $args &
        ;;
esac
