/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class FCPtrAttributeMap!
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/


#define OSG_COMPILEFCPTRATTRIBUTEMAPINST

#include <stdlib.h>
#include <stdio.h>

#include <OSGConfig.h>

#include "OSGFCPtrAttributeMapBase.h"
#include "OSGFCPtrAttributeMap.h"


OSG_USING_NAMESPACE

const OSG::BitVector  FCPtrAttributeMapBase::KeysFieldMask = 
    (TypeTraits<BitVector>::One << FCPtrAttributeMapBase::KeysFieldId);

const OSG::BitVector  FCPtrAttributeMapBase::ValuesFieldMask = 
    (TypeTraits<BitVector>::One << FCPtrAttributeMapBase::ValuesFieldId);

const OSG::BitVector FCPtrAttributeMapBase::MTInfluenceMask = 
    (Inherited::MTInfluenceMask) | 
    (static_cast<BitVector>(0x0) << Inherited::NextFieldId); 


// Field descriptions

/*! \var std::string     FCPtrAttributeMapBase::_mfKeys
    
*/
/*! \var FieldContainerPtr FCPtrAttributeMapBase::_mfValues
    
*/

//! FCPtrAttributeMap description

FieldDescription *FCPtrAttributeMapBase::_desc[] = 
{
    new FieldDescription(MFString::getClassType(), 
                     "keys", 
                     KeysFieldId, KeysFieldMask,
                     false,
                     (FieldAccessMethod) &FCPtrAttributeMapBase::getMFKeys),
    new FieldDescription(MFFieldContainerPtr::getClassType(), 
                     "values", 
                     ValuesFieldId, ValuesFieldMask,
                     false,
                     (FieldAccessMethod) &FCPtrAttributeMapBase::getMFValues)
};


FieldContainerType FCPtrAttributeMapBase::_type(
    "FCPtrAttributeMap",
    "Attachment",
    NULL,
    (PrototypeCreateF) &FCPtrAttributeMapBase::createEmpty,
    FCPtrAttributeMap::initMethod,
    _desc,
    sizeof(_desc));

//OSG_FIELD_CONTAINER_DEF(FCPtrAttributeMapBase, FCPtrAttributeMapPtr)

/*------------------------------ get -----------------------------------*/

FieldContainerType &FCPtrAttributeMapBase::getType(void) 
{
    return _type; 
} 

const FieldContainerType &FCPtrAttributeMapBase::getType(void) const 
{
    return _type;
} 


FieldContainerPtr FCPtrAttributeMapBase::shallowCopy(void) const 
{ 
    FCPtrAttributeMapPtr returnValue; 

    newPtr(returnValue, dynamic_cast<const FCPtrAttributeMap *>(this)); 

    return returnValue; 
}

UInt32 FCPtrAttributeMapBase::getContainerSize(void) const 
{ 
    return sizeof(FCPtrAttributeMap); 
}


#if !defined(OSG_FIXED_MFIELDSYNC)
void FCPtrAttributeMapBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField)
{
    this->executeSyncImpl((FCPtrAttributeMapBase *) &other, whichField);
}
#else
void FCPtrAttributeMapBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField,                                    const SyncInfo       &sInfo     )
{
    this->executeSyncImpl((FCPtrAttributeMapBase *) &other, whichField, sInfo);
}
void FCPtrAttributeMapBase::execBeginEdit(const BitVector &whichField, 
                                            UInt32     uiAspect,
                                            UInt32     uiContainerSize) 
{
    this->execBeginEditImpl(whichField, uiAspect, uiContainerSize);
}

void FCPtrAttributeMapBase::onDestroyAspect(UInt32 uiId, UInt32 uiAspect)
{
    Inherited::onDestroyAspect(uiId, uiAspect);

    _mfKeys.terminateShare(uiAspect, this->getContainerSize());
    _mfValues.terminateShare(uiAspect, this->getContainerSize());
}
#endif

/*------------------------- constructors ----------------------------------*/

#ifdef OSG_WIN32_ICL
#pragma warning (disable : 383)
#endif

FCPtrAttributeMapBase::FCPtrAttributeMapBase(void) :
    _mfKeys                   (), 
    _mfValues                 (), 
    Inherited() 
{
}

#ifdef OSG_WIN32_ICL
#pragma warning (default : 383)
#endif

FCPtrAttributeMapBase::FCPtrAttributeMapBase(const FCPtrAttributeMapBase &source) :
    _mfKeys                   (source._mfKeys                   ), 
    _mfValues                 (source._mfValues                 ), 
    Inherited                 (source)
{
}

/*-------------------------- destructors ----------------------------------*/

FCPtrAttributeMapBase::~FCPtrAttributeMapBase(void)
{
}

/*------------------------------ access -----------------------------------*/

UInt32 FCPtrAttributeMapBase::getBinSize(const BitVector &whichField)
{
    UInt32 returnValue = Inherited::getBinSize(whichField);

    if(FieldBits::NoField != (KeysFieldMask & whichField))
    {
        returnValue += _mfKeys.getBinSize();
    }

    if(FieldBits::NoField != (ValuesFieldMask & whichField))
    {
        returnValue += _mfValues.getBinSize();
    }


    return returnValue;
}

void FCPtrAttributeMapBase::copyToBin(      BinaryDataHandler &pMem,
                                  const BitVector         &whichField)
{
    Inherited::copyToBin(pMem, whichField);

    if(FieldBits::NoField != (KeysFieldMask & whichField))
    {
        _mfKeys.copyToBin(pMem);
    }

    if(FieldBits::NoField != (ValuesFieldMask & whichField))
    {
        _mfValues.copyToBin(pMem);
    }


}

void FCPtrAttributeMapBase::copyFromBin(      BinaryDataHandler &pMem,
                                    const BitVector    &whichField)
{
    Inherited::copyFromBin(pMem, whichField);

    if(FieldBits::NoField != (KeysFieldMask & whichField))
    {
        _mfKeys.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (ValuesFieldMask & whichField))
    {
        _mfValues.copyFromBin(pMem);
    }


}

#if !defined(OSG_FIXED_MFIELDSYNC)
void FCPtrAttributeMapBase::executeSyncImpl(      FCPtrAttributeMapBase *pOther,
                                        const BitVector         &whichField)
{

    Inherited::executeSyncImpl(pOther, whichField);

    if(FieldBits::NoField != (KeysFieldMask & whichField))
        _mfKeys.syncWith(pOther->_mfKeys);

    if(FieldBits::NoField != (ValuesFieldMask & whichField))
        _mfValues.syncWith(pOther->_mfValues);


}
#else
void FCPtrAttributeMapBase::executeSyncImpl(      FCPtrAttributeMapBase *pOther,
                                        const BitVector         &whichField,
                                        const SyncInfo          &sInfo      )
{

    Inherited::executeSyncImpl(pOther, whichField, sInfo);


    if(FieldBits::NoField != (KeysFieldMask & whichField))
        _mfKeys.syncWith(pOther->_mfKeys, sInfo);

    if(FieldBits::NoField != (ValuesFieldMask & whichField))
        _mfValues.syncWith(pOther->_mfValues, sInfo);


}

void FCPtrAttributeMapBase::execBeginEditImpl (const BitVector &whichField, 
                                                 UInt32     uiAspect,
                                                 UInt32     uiContainerSize)
{
    Inherited::execBeginEditImpl(whichField, uiAspect, uiContainerSize);

    if(FieldBits::NoField != (KeysFieldMask & whichField))
        _mfKeys.beginEdit(uiAspect, uiContainerSize);

    if(FieldBits::NoField != (ValuesFieldMask & whichField))
        _mfValues.beginEdit(uiAspect, uiContainerSize);

}
#endif



#include <OSGSFieldTypeDef.inl>

OSG_BEGIN_NAMESPACE

#if !defined(OSG_DO_DOC) || defined(OSG_DOC_DEV)
DataType FieldDataTraits<FCPtrAttributeMapPtr>::_type("FCPtrAttributeMapPtr", "AttachmentPtr");
#endif

OSG_DLLEXPORT_SFIELD_DEF1(FCPtrAttributeMapPtr, OSG_SYSTEMLIB_DLLTMPLMAPPING);

OSG_END_NAMESPACE


/*------------------------------------------------------------------------*/
/*                              cvs id's                                  */

#ifdef OSG_SGI_CC
#pragma set woff 1174
#endif

#ifdef OSG_LINUX_ICC
#pragma warning( disable : 177 )
#endif

namespace
{
    static Char8 cvsid_cpp       [] = "@(#)$Id: FCBaseTemplate_cpp.h,v 1.45 2005/07/20 00:10:14 vossg Exp $";
    static Char8 cvsid_hpp       [] = OSGFCPTRATTRIBUTEMAPBASE_HEADER_CVSID;
    static Char8 cvsid_inl       [] = OSGFCPTRATTRIBUTEMAPBASE_INLINE_CVSID;

    static Char8 cvsid_fields_hpp[] = OSGFCPTRATTRIBUTEMAPFIELDS_HEADER_CVSID;
}

