#ifndef HEADER_ESS_H
#define HEADER_ESS_H

#ifdef  __cplusplus
extern "C" {
#endif

#include "stack.h"
#include "asn1.h"
#include "x509.h"

typedef struct signing_certificate_st
        {
	STACK /* ESS_CERT_ID */ *certs;
	STACK /* POLICY_INFO */ *policies; /* OPTIONAL */
        } SIGNING_CERTIFICATE;

typedef struct issuer_serial_st
        {
	STACK /* GENERAL_NAME */ *issuer;
	ASN1_INTEGER *serialNumber;
        } ISSUER_SERIAL;

typedef struct ess_cert_id_st
        {
	ASN1_OCTET_STRING *certHash;
	ISSUER_SERIAL *issuerSerial; /* OPTIONAL */
        } ESS_CERT_ID;

#define SIGNING_CERTIFICATE_cmp(a,b)\
  ASN1_cmp(i2d_SIGNING_CERTIFICATE,((char*)(a)),((char*)(b)))

#ifndef NOPROTO
int ASN1_cmp(int (*i2d)(), char* a, char *b);
SIGNING_CERTIFICATE *SIGNING_CERTIFICATE_new();
void SIGNING_CERTIFICATE_free(SIGNING_CERTIFICATE *a);
SIGNING_CERTIFICATE *SIGNING_CERTIFICATE_set(SIGNING_CERTIFICATE *c, X509* x);
int i2d_SIGNING_CERTIFICATE(SIGNING_CERTIFICATE *a, unsigned char **pp);
SIGNING_CERTIFICATE *d2i_SIGNING_CERTIFICATE(SIGNING_CERTIFICATE **a, unsigned char **pp, long length);
int i2a_SIGNING_CERTIFICATE(BIO *bp, SIGNING_CERTIFICATE* a);

ISSUER_SERIAL *ISSUER_SERIAL_new();
void ISSUER_SERIAL_free(ISSUER_SERIAL *a);
ISSUER_SERIAL *ISSUER_SERIAL_set(ISSUER_SERIAL* is, X509* x);
int i2d_ISSUER_SERIAL(ISSUER_SERIAL *a, unsigned char **pp);
ISSUER_SERIAL *d2i_ISSUER_SERIAL(ISSUER_SERIAL **a, unsigned char **pp, long length);
int i2a_ISSUER_SERIAL(BIO *bp, ISSUER_SERIAL* a);

ESS_CERT_ID *ESS_CERT_ID_new();
ESS_CERT_ID *ESS_CERT_ID_set(ESS_CERT_ID* cid, X509* x);
void ESS_CERT_ID_free(ESS_CERT_ID *a);
int i2d_ESS_CERT_ID(ESS_CERT_ID *a, unsigned char **pp);
ESS_CERT_ID *d2i_ESS_CERT_ID(ESS_CERT_ID **a, unsigned char **pp, long length);
int i2a_ESS_CERT_ID(BIO *bp, ESS_CERT_ID* a);

#else

int ASN1_cmp();
SIGNING_CERTIFICATE *SIGNING_CERTIFICATE_new();
void SIGNING_CERTIFICATE_free();
SIGNING_CERTIFICATE *SIGNING_CERTIFICATE_set();
int i2d_SIGNING_CERTIFICATE();
SIGNING_CERTIFICATE *d2i_SIGNING_CERTIFICATE();
int i2a_SIGNING_CERTIFICATE();

ISSUER_SERIAL *ISSUER_SERIAL_new();
void ISSUER_SERIAL_free();
ISSUER_SERIAL *ISSUER_SERIAL_set();
int i2d_ISSUER_SERIAL();
ISSUER_SERIAL *d2i_ISSUER_SERIAL();
int i2a_ISSUER_SERIAL();

ESS_CERT_ID *ESS_CERT_ID_new();
ESS_CERT_ID *ESS_CERT_ID_set();
int ESS_CERT_ID_set();
void ESS_CERT_ID_free();
int i2d_ESS_CERT_ID();
ESS_CERT_ID *d2i_ESS_CERT_ID();
int i2a_ESS_CERT_ID();
#endif
#endif

