#include <unix.h>
#include <sys/stat.h>
#include <openssl/rsa.h>
#include <openssl/evp.h>
#include <openssl/bn.h>

int
main( int argc, char **argv )
{
	RSA *rsa;

	EVP_PKEY *pkey;

	EVP_MD_CTX mdctx;
	EVP_MD *md;
	unsigned char md_value[EVP_MAX_MD_SIZE];
	int md_len;

	BIGNUM k; /* user-supplied private key store */
	BIGNUM z;

	int c, fd;
	char tobesigned[80], nowsigned[80], priv_key[80];
	char md_algo[16];
	unsigned char mess[2048];
	int mess_len;
    unsigned char m[2048];
	unsigned int m_len;
	unsigned char sigret[2048];
	unsigned int siglen=0;
	unsigned char p_k[2048];
	int p_k_len;

	if( argc <= 1 )
	{
		printf( "wrong parameter count\n\n" );
		exit( EXIT_FAILURE );
	}

	strcpy( md_algo, "md5" );

	while( -1 != ( c = getopt( argc, argv, "i:o:k:t:" ) ) )
	{
		switch( c )
		{
			case 'i':
				sscanf( optarg, "%s", tobesigned );
				break;
			case 'o':
				sscanf( optarg, "%s", nowsigned );
				break;
			case 'k': /* user-supplied private key filename */
				sscanf( optarg, "%s", priv_key );
				break;
			case 't':
				sscanf( optarg, "%s", md_algo );
				break;
		}
	}

	memset( sigret, 0, sizeof( sigret ) );
	memset( p_k,    0, sizeof( p_k ) );
	memset( m,      0, sizeof( m ) );

	BN_init( &z );
	BN_bin2bn( p_k, sizeof( p_k ), &z ); /* I want to have a zero in BN */
//	printf( "z==%s\n", BN_bn2hex( &z ) );

	fd = open( tobesigned, O_RDONLY );
	if( -1 == fd )
	{
		printf( "input file not found '%s'\n", tobesigned );
		exit( EXIT_FAILURE );
	}
	mess_len = read( fd, mess, sizeof( mess ) );
	if( -1 == mess_len )
	{
		printf( "error reading '%s'\n", tobesigned );
		exit( EXIT_FAILURE );
	}
	printf( "input: %d bytes read\n", mess_len );
	close( fd ); /* data to be signed */

	fd = open( priv_key, O_RDONLY );
	if( -1 == fd )
	{
		printf( "private key file not found '%s'\n", priv_key );
		exit( EXIT_FAILURE );
	}
	p_k_len = read( fd, p_k, sizeof( p_k ) );
	if( -1 == p_k_len )
	{
		printf( "error reading '%s'\n", priv_key );
		exit( EXIT_FAILURE );
	}
	printf( "key: %d bytes read\n", p_k_len );
	close( fd ); /* private key file */

	BN_init( &k );
	BN_bin2bn( p_k, p_k_len, &k ); /* the replacement private key as BN */
//	printf( "p_k==%s\n", BN_bn2hex( &k ) );

try_again:
	rsa = RSA_generate_key( 1024, RSA_F4, NULL, NULL );
	if( NULL == rsa)
	{
		printf( "RSA_generate_key() failed\n");
		exit( EXIT_FAILURE );
	}

	c = RSA_check_key( rsa );
	if( !c )
	{
		printf( "RSA key is unusable\n");
		goto try_again;
	} else {
		printf( "RSA key is usable\n");
//		printf( "p==%s\nq==%s\nn==%s\ne==%s\nd==%s\n",
//		 BN_bn2dec( rsa->p ),
//		 BN_bn2dec( rsa->q ),
//		 BN_bn2dec( rsa->n ),
//		 BN_bn2dec( rsa->e ),
//		 BN_bn2dec( rsa->d ) );
	}

/* Now attempt to force our external private key. */
//	BN_copy( rsa->p, &z );
//	BN_copy( rsa->q, &z );
//	BN_copy( rsa->n, &z );
//	BN_copy( rsa->e, &z );
	BN_copy( rsa->d, &k ); /* attempt to substitute the private key */
//	printf( "key==%s\n", BN_bn2hex( rsa->d ) );

	OpenSSL_add_all_digests();
	md = EVP_get_digestbyname( md_algo );
	if( !md )
	{
		printf( "unknown digest\n");
		exit( EXIT_FAILURE );
	}

#if 1 /* trying the EVP_Sign* family */

	printf( "an EVP_Sign* way...\n" );

	pkey = EVP_PKEY_new();
	if( NULL == pkey )
	{
		printf( "EVP_PKEY_new() failed\n");
		exit( EXIT_FAILURE );
	}
	EVP_PKEY_assign_RSA( pkey, rsa );
	EVP_MD_CTX_init( &mdctx );
	EVP_SignInit( &mdctx, EVP_md5() );
	c = EVP_SignUpdate( &mdctx, mess, mess_len );
	if( !c )
	{
		printf( "EVP_SignUpdate() failed\n" );
		exit( EXIT_FAILURE );
	}
	c = EVP_SignFinal( &mdctx, sigret, &siglen, pkey );
	if( c )
	{
		printf( "Done, siglen==%d\n", siglen );
	} else {
		printf( "Failed, siglen==%d\n", siglen );
	}

#else /* using EVP_Digest* family */

	printf( "an EVP_Digest* way...\n" );

	EVP_MD_CTX_init( &mdctx );
	c = EVP_DigestInit_ex( &mdctx, md, NULL );
	if( !c )
	{
		printf( "EVP_DigestInit_ex() failed\n" );
		exit( EXIT_FAILURE );
	}
	c = EVP_DigestUpdate( &mdctx, mess, mess_len );
	if( !c )
	{
		printf( "EVP_DigestUpdate() failed\n" );
		exit( EXIT_FAILURE );
	}
	c = EVP_DigestFinal_ex( &mdctx, m, &m_len );
	if( !c )
	{
		printf( "EVP_DigestFinal_ex() failed\n" );
		exit( EXIT_FAILURE );
	}
	EVP_MD_CTX_cleanup( &mdctx );

	printf( "%s==", md_algo );
	for( c = 0; c < m_len; c++)
		printf( "%02x", m[c]);
	printf( ", m_len==%d\n", m_len);

	printf( "RSA_size==%d\n", RSA_size( rsa ) );

	c = RSA_sign( NID_md5, m, m_len, sigret, &siglen, rsa );
	if( c )
	{
		printf( "Done, siglen==%d\n", siglen );
	} else {
		printf( "Failed, siglen==%d\n", siglen );
	}

#endif /* either EVP_Sign* or EVP_Digest* method */

	if( siglen )
	{
		fd = open( nowsigned, O_WRONLY | O_CREAT | O_TRUNC | S_IRUSR | S_IWUSR );
		if( -1 == fd )
		{
			printf( "could not create '%s'\n", nowsigned );
			exit( EXIT_FAILURE );
		}
		if( -1 == fchmod( fd, S_IRUSR | S_IWUSR | S_IRGRP | S_IROTH ) )
		{
			printf( "could not fchmod() '%s'\n", nowsigned );
			exit( EXIT_FAILURE );
		}
	    write( fd, sigret, siglen );
		close( fd );
	}
	return EXIT_SUCCESS;
}
