import java.io.*;

import org.orbeon.oxf.pipeline.api.PipelineContext;
import org.orbeon.oxf.common.OXFException;
import org.orbeon.oxf.processor.ProcessorInputOutputInfo;

import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.AttributesImpl;

import java.util.Map;
import java.util.Set;
import java.util.Iterator;

public class ListInput extends org.orbeon.oxf.processor.SimpleProcessor { 

  private static org.apache.log4j.Logger logger =
    org.orbeon.oxf.util.LoggerFactory.createLogger( ListInput.class );

  public ListInput() {
    addInputInfo( new ProcessorInputOutputInfo( "required-input" ) );
    addOutputInfo( new ProcessorInputOutputInfo( "list" ) );
  }

  public void generateList( PipelineContext pipelineContext,
			    ContentHandler contentHandler ) {
    try {
      Map inputMap = getInputs();
      Set keySet = inputMap.keySet();
      Iterator it = keySet.iterator();
      contentHandler.startDocument();
      contentHandler.startElement( "", "inputs", "inputs", new AttributesImpl() );
      while ( it.hasNext() ) {
	addStringElement( contentHandler, "input", (String)it.next() );
      }
      contentHandler.endElement( "", "inputs", "inputs" );
      contentHandler.endDocument();
    } catch ( Exception e ) {
      throw new OXFException( e );
    }
  }

  public static void addStringElement(ContentHandler contentHandler, String name, String value)
    throws org.xml.sax.SAXException
  {
    contentHandler.startElement( "", name, name, new AttributesImpl() );
    contentHandler.characters( value.toCharArray(), 0, value.length() );
    contentHandler.endElement( "", name, name );
  }
}
