import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 
 * 
 * @author Steve Coughlan
 *
 */
public class Schema {

	final private VarInt8 version;
	final private String clazz;
	
	final private List<SchemaField> fields;
	
	//replace this with trove IntObjectMap
	final private Map<Integer, SchemaField> fieldIndex = new HashMap();
	

	/**
	 * fields should always be ordered with fixed length fields first.
	 * @param version
	 * @param clazz
	 * @param fields
	 */
	public Schema(VarInt8 version, String clazz, List<SchemaField> fields) {
		super();
		this.version = version;
		this.clazz = clazz;
		this.fields = fields;
		calculateOffsets();
	}
	
	private void calculateOffsets() {
		
		//calculate fixed field offsets and save them in each
		//SchemaField
		int offset = version.getBytesLength();
		for (SchemaField field: fields) {
			fieldIndex.put(field.getNameId(), field);
			if (field.getType().isFixedLength()) {
				field.setDataOffset(offset);
				field.setDataLength(field.getType().getLength());
				offset += field.getDataLength();
			} else {
				//unknown has to be read from record header.
				field.setDataOffset(-1); 
				field.setDataLength(-1);
			}
		}
	}
	
	/**
	 * The length of the part of the header that contains schema fields.  Does not include
	 * the version and headerLength fields as these are variable per record.
	 * @return
	 */
	int schemaLessHeaderOffset() {
		return -1;
	}

	/**
	 * Index of the last field that is fixed length.
	 * @return
	 */
	public int lastFixedLengthIndex() {
		return -1;
	}

	public SchemaField getField(int nameId) {
		return fieldIndex.get(nameId);
	}
	

}
