
public class SchemaField {

	private FieldType type;
	
	/**
	 * This should be retrieved from FieldIds.nameFor(nameId) to ensure the same instance
	 * of each String is always used (faster map lookups)
	 */
	private String name;
	
	private int nameId;
	
	/*
	 * User defined order.  Internally fields will be rearranged to group fixed dataLength fields first.
	 */
	private int order;
	
	/*
	 * Index in the parent schema.
	 */
	private int index;
	
	/**
	 * Offset within the header of the dataOffset and dataLength fields. 
	 * This is used for variable length fields declared in schema.  To read
	 * a field we start at headerOffset and read two varints the first is
	 * offset and the second is length.  The header offset can be calculated
	 * when the schema is initialized as it will remain fixed through the life
	 * of the schema (IF you use fixed lengths to store the offset/length)
	 */
	private int headerOffset;
	
	/**
	 * offset and length of the data within the parent version of the schema.
	 * This is only stored for fixed length fields.
	 */
	private int dataOffset;
	private int dataLength;
	
	
	
	public SchemaField() {
	}

	/**
	 * @return the type
	 */
	public FieldType getType() {
		return type;
	}

	/**
	 * @param type the type to set
	 */
	public void setType(FieldType type) {
		this.type = type;
	}

	/**
	 * @return the name
	 */
	public String getName() {
		return name;
	}

	/**
	 * @param name the name to set
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * @return the nameId
	 */
	public int getNameId() {
		return nameId;
	}

	/**
	 * @param nameId the nameId to set
	 */
	public void setNameId(int nameId) {
		this.nameId = nameId;
	}

	/**
	 * @return the order
	 */
	public int getOrder() {
		return order;
	}

	/**
	 * @param order the order to set
	 */
	public void setOrder(int order) {
		this.order = order;
	}

	/**
	 * @return the index
	 */
	public int getIndex() {
		return index;
	}

	/**
	 * @param index the index to set
	 */
	public void setIndex(int index) {
		this.index = index;
	}

	/**
	 * @return the headerOffset
	 */
	public int getHeaderOffset() {
		return headerOffset;
	}

	/**
	 * @param headerOffset the headerOffset to set
	 */
	public void setHeaderOffset(int headerOffset) {
		this.headerOffset = headerOffset;
	}

	/**
	 * @return the dataOffset
	 */
	public int getDataOffset() {
		return dataOffset;
	}

	/**
	 * @param dataOffset the dataOffset to set
	 */
	public void setDataOffset(int dataOffset) {
		this.dataOffset = dataOffset;
	}

	/**
	 * @return the dataLength
	 */
	public int getDataLength() {
		return dataLength;
	}

	/**
	 * @param dataLength the dataLength to set
	 */
	public void setDataLength(int dataLength) {
		this.dataLength = dataLength;
	}

	
	
}
