import java.util.List;


/**
 * A set of Schemas of different versions that belong to one class.   This class provides fast lookup
 * so that when a Record's first 'version' byte is read the correct Schema can be obtained to read the
 * rest of the record.
 * 
 * @author Steve Coughlan
 *
 */
public class SchemaSet {

	final private String clazz;
	final private Schema[] versions;
	final private Schema current;
	
	
	/**
	 * Schemas should be in order of version.  i.e. version 0 should be at index 0 of the list.
	 * @param clazz
	 * @param schemas
	 */
	public SchemaSet(String clazz, List<Schema> schemas) {
		this.clazz = clazz;
		this.versions = schemas.toArray(new Schema[schemas.size()]);
		this.current = versions[versions.length - 1];
	}

	public Schema getSchema(int version) {
		return versions[version];
	}
	
	public Schema currentSchema() {
		return current;
	}
	
}
