/*
 * Decompiled with CFR 0.152.
 */
package org.as2lib.ant;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.as2lib.ant.Mtasc;
import org.as2lib.ant.Swfmill;

public class Swf
extends Mtasc {
    public static final String XML = "swfmill.xml";
    public static final String CLASSES = "classes.swf";
    private Swfmill swfmill = new Swfmill();
    private int width;
    private int height;
    private int framerate;
    private String backgroundColor;
    private File classes;
    private Clip clip;
    private Font font;
    private Import imp;

    public Swf() {
        this.setSplit(false);
        this.setMain(true);
        this.setWidth(800);
        this.setHeight(600);
        this.setFramerate(31);
        this.setBackgroundColor("FFFFFF");
    }

    public String getSwfmill() {
        return this.swfmill.getSwfmill();
    }

    public void setSwfmill(String string) {
        this.swfmill.setSwfmill(string);
    }

    public void setDest(File file) {
        super.setSwf(file);
        this.swfmill.setDest(file);
    }

    public File getDest() {
        return super.getSwf();
    }

    public void setDestination(File file) {
        this.setDest(file);
    }

    public File getDestination() {
        return this.getDest();
    }

    public void setSwf(File file) {
        this.setDest(file);
    }

    public File getSwf() {
        return this.getDest();
    }

    public void setSource(File file) {
        this.setSrc(file);
    }

    public File getSource() {
        return this.getSrc();
    }

    public void setClazz(File file) {
        this.setSrc(file);
    }

    public void setClass(File file) {
        this.setSrc(file);
    }

    public File getClazz() {
        return this.getSrc();
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public int getWidth() {
        return this.width;
    }

    public void setHeight(int n) {
        this.height = n;
    }

    public int getHeight() {
        return this.height;
    }

    public void setFps(int n) {
        this.framerate = n;
    }

    public int getFps() {
        return this.framerate;
    }

    public void setFramerate(int n) {
        this.setFps(n);
    }

    public int getFramerate() {
        return this.getFps();
    }

    public void setBgColor(String string) {
        this.backgroundColor = string;
    }

    public String getBgColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(String string) {
        this.setBgColor(string);
    }

    public String getBackgroundColor() {
        return this.getBgColor();
    }

    public void setBg(String string) {
        this.setBgColor(string);
    }

    public String getBg() {
        return this.getBgColor();
    }

    public void setColor(String string) {
        this.setBgColor(string);
    }

    public String getColor() {
        return this.getBgColor();
    }

    public void setClasses(File file) {
        this.classes = file;
    }

    public File getClasses() {
        return this.classes;
    }

    public Clip createClip() {
        if (this.clip == null) {
            this.clip = new Clip();
        }
        return this.clip;
    }

    public Clip getClip() {
        return this.clip;
    }

    public Font createFont() {
        if (this.font == null) {
            this.font = new Font();
        }
        return this.font;
    }

    public Font getFont() {
        return this.font;
    }

    public Import createImport() {
        if (this.imp == null) {
            this.imp = new Import();
        }
        return this.imp;
    }

    public Import getImport() {
        return this.imp;
    }

    public void setHelp(boolean bl) {
        super.setHelp(bl);
        this.swfmill.setHelp(bl);
    }

    public void setVerbose(boolean bl) {
        super.setVerbose(bl);
        this.swfmill.setVerbose(bl);
    }

    public void setExtraVerbose(boolean bl) {
        super.setVerbose(bl);
        this.swfmill.setExtraVerbose(bl);
    }

    public void setHeader(String string) {
        String[] stringArray = string.split(":");
        switch (stringArray.length) {
            case 4: {
                this.setBackgroundColor(stringArray[3]);
            }
            case 3: {
                this.setFramerate(new Integer(stringArray[2]));
            }
            case 2: {
                this.setHeight(new Integer(stringArray[1]));
            }
            case 1: {
                this.setWidth(new Integer(stringArray[0]));
            }
        }
    }

    public void addConfiguredXml(Xml xml) {
        this.swfmill.addText(xml.getText());
    }

    public String getXml() {
        return this.swfmill.getText();
    }

    public void execute() throws BuildException {
        this.swfmill.setProject(this.getProject());
        this.swfmill.setTaskName(this.getTaskName());
        this.swfmill.setTaskType(this.getTaskType());
        this.swfmill.setLocation(this.getLocation());
        this.swfmill.setCommand(new Swfmill.Command("simple"));
        if (this.swfmill.getText() == null) {
            this.createXmlFile();
            this.swfmill.setSrc(new File(this.getProject().getBaseDir() + "/" + XML));
        }
        this.swfmill.execute();
        if (this.checkParameters()) {
            super.execute();
        }
    }

    private void createXmlFile() {
        try {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(this.getProject().getBaseDir() + "/" + XML));
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(bufferedOutputStream);
            outputStreamWriter.write("<?xml version=\"1.0\" encoding=\"iso-8859-1\" ?>\n\n");
            outputStreamWriter.write("<movie");
            outputStreamWriter.write(" width=\"" + new Integer(this.width).toString() + "\"");
            outputStreamWriter.write(" height=\"" + new Integer(this.height).toString() + "\"");
            outputStreamWriter.write(" framerate=\"" + new Integer(this.framerate).toString() + "\"");
            if (this.getVersion() != null) {
                outputStreamWriter.write(" version=\"" + new Integer(this.getVersion()).toString() + "\"");
            }
            outputStreamWriter.write(">\n");
            if (this.backgroundColor != null) {
                outputStreamWriter.write("  <background color='#" + this.backgroundColor + "'/>\n");
            }
            outputStreamWriter.write("  <frame>\n");
            if (this.clip != null || this.font != null || this.imp != null) {
                int n;
                Object[] objectArray;
                if (this.classes != null) {
                    outputStreamWriter.write("    <clip import=\"" + this.classes + "\"/>\n");
                }
                outputStreamWriter.write("    <library>\n");
                if (this.clip != null) {
                    this.writeClip(this.clip, outputStreamWriter);
                    objectArray = this.clip.getIncludes();
                    for (n = 0; n < objectArray.length; ++n) {
                        this.writeClip((Clip)objectArray[n], outputStreamWriter);
                    }
                }
                if (this.font != null) {
                    this.writeFont(this.font, outputStreamWriter);
                    objectArray = this.font.getIncludes();
                    for (n = 0; n < objectArray.length; ++n) {
                        this.writeFont((Font)objectArray[n], outputStreamWriter);
                    }
                }
                if (this.imp != null) {
                    this.writeImport(this.imp, outputStreamWriter);
                    objectArray = this.imp.getIncludes();
                    for (n = 0; n < objectArray.length; ++n) {
                        this.writeImport((Import)objectArray[n], outputStreamWriter);
                    }
                }
                outputStreamWriter.write("    </library>\n");
            }
            outputStreamWriter.write("  </frame>\n");
            outputStreamWriter.write("</movie>");
            outputStreamWriter.flush();
            outputStreamWriter.close();
        }
        catch (IOException iOException) {
            throw new BuildException("Problem on generating 'swfmill.xml'.", (Throwable)iOException, this.getLocation());
        }
    }

    private void writeClip(Clip clip, OutputStreamWriter outputStreamWriter) throws IOException {
        if (clip != null && (clip.getId() != null || clip.getImport() != null || clip.getClazz() != null)) {
            outputStreamWriter.write("      <clip");
            if (clip.getId() != null) {
                outputStreamWriter.write(" id=\"" + clip.getId() + "\"");
            }
            if (clip.getImport() != null) {
                String string = clip.getImport().toString();
                if (string.toLowerCase().endsWith(".svg")) {
                    string = string.replace('\\', '/');
                }
                outputStreamWriter.write(" import=\"" + string + "\"");
            }
            if (clip.getClazz() != null) {
                outputStreamWriter.write(" class=\"" + clip.getClazz() + "\"");
            }
            outputStreamWriter.write("/>\n");
        }
    }

    private void writeFont(Font font, OutputStreamWriter outputStreamWriter) throws IOException {
        if (font != null && (font.getId() != null || font.getImport() != null || font.getGlyphs() != null)) {
            outputStreamWriter.write("      <font");
            if (font.getId() != null) {
                outputStreamWriter.write(" id=\"" + font.getId() + "\"");
            }
            if (font.getImport() != null) {
                outputStreamWriter.write(" import=\"" + font.getImport() + "\"");
            }
            if (font.getGlyphs() != null) {
                outputStreamWriter.write(" glyphs=\"" + font.getGlyphs() + "\"");
            }
            if (font.getName() != null) {
                outputStreamWriter.write(" name=\"" + font.getName() + "\"");
            }
            outputStreamWriter.write("/>\n");
        }
    }

    private void writeImport(Import import_, OutputStreamWriter outputStreamWriter) throws IOException {
        if (import_ != null && (import_.getFile() != null || import_.getUrl() != null)) {
            outputStreamWriter.write("      <import");
            if (import_.getFile() != null) {
                outputStreamWriter.write(" file=\"" + import_.getFile() + "\"");
            }
            if (import_.getUrl() != null) {
                outputStreamWriter.write(" url=\"" + import_.getUrl() + "\"");
            }
            outputStreamWriter.write("/>\n");
        }
    }

    public static class Xml {
        private String text;

        public void addText(String string) {
            this.text = string;
        }

        public String getText() {
            return this.text;
        }
    }

    public static class Import {
        private File file;
        private URI url;
        private List includes = new ArrayList();

        public void setFile(File file) {
            this.file = file;
        }

        public File getFile() {
            return this.file;
        }

        public void setUrl(URI uRI) {
            this.url = uRI;
        }

        public URI getUrl() {
            return this.url;
        }

        public Import createInclude() {
            Import import_ = new Import();
            this.includes.add(import_);
            return import_;
        }

        public Import[] getIncludes() {
            return this.includes.toArray(new Import[0]);
        }
    }

    public static class Font
    extends Symbol {
        private String name;
        private String glyphs;
        private List includes = new ArrayList();

        public void setName(String string) {
            this.name = string;
        }

        public String getName() {
            return this.name;
        }

        public void setGlyphs(String string) {
            this.glyphs = string;
        }

        public String getGlyphs() {
            return this.glyphs;
        }

        public Font createInclude() {
            Font font = new Font();
            this.includes.add(font);
            return font;
        }

        public Font[] getIncludes() {
            return this.includes.toArray(new Font[0]);
        }
    }

    public static class Clip
    extends Symbol {
        private List includes = new ArrayList();
        private String clazz;

        public void setClass(String string) {
            this.clazz = string;
        }

        public void setClazz(String string) {
            this.setClass(string);
        }

        public String getClazz() {
            return this.clazz;
        }

        public Clip createInclude() {
            Clip clip = new Clip();
            this.includes.add(clip);
            return clip;
        }

        public Clip[] getIncludes() {
            return this.includes.toArray(new Clip[0]);
        }
    }

    public static class Symbol {
        private String id;
        private File path;

        public void setImport(File file) {
            this.path = file;
        }

        public File getImport() {
            return this.path;
        }

        public void setId(String string) {
            this.id = string;
        }

        public String getId() {
            return this.id;
        }
    }
}

