/*
 * Decompiled with CFR 0.152.
 */
package org.as2lib.ant;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.PumpStreamHandler;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.EnumeratedAttribute;

public class Swfmill
extends Task {
    public static final String SWFMILL = "swfmill";
    public static final String SWF2XML = "swf2xml";
    public static final String XML2SWF = "xml2swf";
    public static final String SIMPLE = "simple";
    public static final String XSLT = "xslt";
    public static final String HELP = "-h";
    public static final String QUIET = "-q";
    public static final String VERBOSE = "-v";
    public static final String EXTRA_VERBOSE = "-V";
    public static final String DUMP = "-d";
    public static final String STDIN = "stdin";
    private String swfmill = "swfmill";
    private File source;
    private File destination;
    private File xsl;
    private String command;
    private String xml;
    private boolean help = false;
    private boolean quiet = false;
    private boolean verbose = false;
    private boolean extraVerbose = false;
    private boolean dump = false;

    public String getSwfmill() {
        return this.swfmill;
    }

    public void setSwfmill(String string) {
        this.swfmill = string;
    }

    public void setSrc(File file) {
        this.source = file;
    }

    public File getSrc() {
        return this.source;
    }

    public void setSource(File file) {
        this.setSrc(file);
    }

    public File getSource() {
        return this.getSrc();
    }

    public void setIn(File file) {
        this.setSrc(file);
    }

    public File getIn() {
        return this.getSrc();
    }

    public void setDest(File file) {
        this.destination = file;
    }

    public File getDest() {
        return this.destination;
    }

    public void setDestination(File file) {
        this.setDest(file);
    }

    public File getDestination() {
        return this.getDest();
    }

    public void setOut(File file) {
        this.setDest(file);
    }

    public File getOut() {
        return this.getDest();
    }

    public void setXsl(File file) {
        this.xsl = file;
    }

    public File getXsl() {
        return this.xsl;
    }

    public void setCmd(Command command) {
        this.command = command.getValue();
    }

    public String getCmd() {
        return this.command;
    }

    public void setCommand(Command command) {
        this.setCmd(command);
    }

    public String getCommand() {
        return this.getCmd();
    }

    public void setHelp(boolean bl) {
        this.help = bl;
    }

    public boolean getHelp() {
        return this.help;
    }

    public void setQuiet(boolean bl) {
        this.quiet = bl;
    }

    public boolean getQuiet() {
        return this.quiet;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    public void setExtraVerbose(boolean bl) {
        this.extraVerbose = bl;
    }

    public boolean getExtraVerbose() {
        return this.extraVerbose;
    }

    public void setDump(boolean bl) {
        this.dump = bl;
    }

    public boolean getDump() {
        return this.dump;
    }

    public void addText(String string) {
        if (!(string = string.trim()).equals("")) {
            this.xml = string;
        }
    }

    public String getText() {
        return this.xml;
    }

    public void execute() throws BuildException {
        this.checkParameters();
        Commandline commandline = this.setupCommand();
        this.executeCommand(commandline);
    }

    private void checkParameters() throws BuildException {
        if (this.source == null && this.xml == null) {
            throw new BuildException("'src', 'source' or 'in' attribute or inline xml must be specified.", this.getLocation());
        }
        if (this.source != null && this.xml != null) {
            throw new BuildException("Specify either 'src' ('source', 'in') or inline xml, not both.", this.getLocation());
        }
    }

    private Commandline setupCommand() {
        Commandline commandline = new Commandline();
        commandline.setExecutable(this.getSwfmill());
        this.setupCommandSwitches(commandline);
        String string = this.evaluateCommand();
        commandline.createArgument().setValue(string);
        if (string.equals(XSLT)) {
            commandline.createArgument().setFile(this.xsl);
        }
        if (this.source != null) {
            commandline.createArgument().setFile(this.source);
        } else {
            commandline.createArgument().setValue(STDIN);
        }
        if (this.destination != null) {
            commandline.createArgument().setFile(this.destination);
        }
        return commandline;
    }

    private void setupCommandSwitches(Commandline commandline) {
        if (this.help) {
            commandline.createArgument().setValue(HELP);
        }
        if (this.quiet) {
            commandline.createArgument().setValue(QUIET);
        }
        if (this.verbose) {
            commandline.createArgument().setValue(VERBOSE);
        }
        if (this.extraVerbose) {
            commandline.createArgument().setValue(EXTRA_VERBOSE);
        }
        if (this.dump) {
            commandline.createArgument().setValue(DUMP);
        }
    }

    private String evaluateCommand() {
        if (this.command != null) {
            return this.command;
        }
        if (this.xsl != null) {
            return XSLT;
        }
        if (this.isXmlFile(this.source)) {
            return XML2SWF;
        }
        if (this.isSwfFile(this.source)) {
            return SWF2XML;
        }
        return SIMPLE;
    }

    private boolean isXmlFile(File file) {
        return file != null && this.getFileExtension(file).equals("xml");
    }

    private boolean isSwfFile(File file) {
        return file != null && this.getFileExtension(file).equals("swf");
    }

    private String getFileExtension(File file) {
        String string = file.getName();
        String string2 = "";
        int n = string.lastIndexOf(".");
        if (0 < n && n <= string.length() - 2) {
            string2 = string.substring(n + 1);
        }
        return string2;
    }

    private void executeCommand(Commandline commandline) {
        try {
            Execute execute;
            if (this.xml != null) {
                String string = this.getProject().replaceProperties(this.xml);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
                PumpStreamHandler pumpStreamHandler = new PumpStreamHandler((OutputStream)System.out, (OutputStream)System.err, (InputStream)byteArrayInputStream);
                execute = new Execute((ExecuteStreamHandler)pumpStreamHandler);
            } else {
                execute = new Execute();
            }
            execute.setAntRun(this.getProject());
            execute.setWorkingDirectory(this.getProject().getBaseDir());
            execute.setCommandline(commandline.getCommandline());
            this.log(commandline.toString());
            int n = execute.execute();
            if (n != 0) {
                throw new BuildException("Processing error!", this.getLocation());
            }
        }
        catch (IOException iOException) {
            throw new BuildException("Error running " + commandline.getCommandline()[0] + " compiler.", (Throwable)iOException, this.getLocation());
        }
    }

    public static class Command
    extends EnumeratedAttribute {
        public Command() {
        }

        public Command(String string) {
            this.setValue(string);
        }

        public String[] getValues() {
            return new String[]{Swfmill.SWF2XML, Swfmill.XML2SWF, Swfmill.SIMPLE, Swfmill.XSLT};
        }
    }
}

