/*
 * Decompiled with CFR 0.152.
 */
package org.as2lib.ant;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.Socket;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.types.Commandline;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class UnitTestForMacAndPC
extends Task {
    public static final String START_ELEMENT = "start";
    public static final String UPDATE_ELEMENT = "update";
    public static final String PAUSE_ELEMENT = "pause";
    public static final String RESUME_ELEMENT = "resume";
    public static final String ERROR_ELEMENT = "error";
    public static final String FAILURE_ELEMENT = "failure";
    public static final String FINISH_ELEMENT = "finish";
    public static final String HAS_ERRORS_ATTRIBUTE = "hasErrors";
    public static final String TRUE_VALUE = "true";
    private File swf;
    private File flashPlayer;
    private int port = 3212;
    private boolean isFinished = false;
    private boolean hasFailed = false;

    public void setSwf(File swf) {
        this.swf = swf;
    }

    public File getSwf() {
        return this.swf;
    }

    public void setFlashPlayer(File flashPlayer) {
        this.flashPlayer = flashPlayer;
    }

    public File getFlashPlayer() {
        return this.flashPlayer;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isFinished() {
        return this.isFinished;
    }

    public void setFinished(boolean isFinished) {
        this.isFinished = isFinished;
    }

    public void setHasFailed(boolean hasFailed) {
        this.hasFailed = hasFailed;
    }

    public void execute() throws BuildException {
        if (this.swf == null) {
            throw new BuildException("A unit test swf must be supplied.", this.getLocation());
        }
        if (this.flashPlayer == null) {
            throw new BuildException("A flash player must be supplied.", this.getLocation());
        }
        Commandline command = new Commandline();
        boolean isAMac = System.getProperty("os.name").equals("Mac OS X");
        if (isAMac) {
            command.setExecutable("open");
        } else {
            command.setExecutable(this.flashPlayer.getPath());
        }
        command.createArgument().setFile(this.swf);
        Receiver receiver = new Receiver(this);
        receiver.startServer(this.port);
        try {
            this.log(command.toString());
            Process process = Execute.launch((Project)this.getProject(), (String[])command.getCommandline(), null, (File)this.getProject().getBaseDir(), (boolean)true);
            receiver.setProcess(process);
            process.waitFor();
            if (isAMac) {
                while (!this.isFinished) {
                    Thread.sleep(4L);
                }
                this.killMacFlashPlayer();
                if (this.hasFailed) {
                    throw new BuildException("The build failed because a unit test did not pass.");
                }
            } else if (this.hasFailed) {
                throw new BuildException("The build failed because a unit test did not pass.");
            }
        }
        catch (IOException e) {
            throw new BuildException("Error running unit tests.", (Throwable)e, this.getLocation());
        }
        catch (InterruptedException e) {
            throw new BuildException("Error running unit tests.", (Throwable)e, this.getLocation());
        }
        receiver.stopServer();
    }

    private void killMacFlashPlayer() throws IOException {
        Commandline command = new Commandline();
        command.setExecutable("killall");
        command.createArgument().setValue("SAFlashPlayer");
        Execute.launch((Project)this.getProject(), (String[])command.getCommandline(), null, (File)this.getProject().getBaseDir(), (boolean)true);
    }

    private static class Receiver
    extends Thread {
        private UnitTestForMacAndPC task;
        private ServerSocket server;
        private BufferedReader in;
        private Process process;

        public Receiver(UnitTestForMacAndPC task) {
            this.task = task;
        }

        public void setProcess(Process process) {
            this.process = process;
        }

        public void run() {
            try {
                this.task.log("-\n-");
                this.task.log("running");
                String previousNodeName = "";
                block4: while (true) {
                    Socket socket = this.server.accept();
                    this.in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                    char[] charBuffer = new char[1];
                    while (true) {
                        if (this.in.read(charBuffer, 0, 1) == -1) continue block4;
                        StringBuffer stringBuffer = new StringBuffer(8192);
                        while (charBuffer[0] != '\u0000') {
                            stringBuffer.append(charBuffer[0]);
                            this.in.read(charBuffer, 0, 1);
                        }
                        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                        DocumentBuilder builder = factory.newDocumentBuilder();
                        Document document = builder.parse(new ByteArrayInputStream(stringBuffer.toString().getBytes()));
                        Element element = document.getDocumentElement();
                        String message = element.getFirstChild().getNodeValue();
                        String nodeName = element.getNodeName();
                        if (nodeName.equals(UnitTestForMacAndPC.START_ELEMENT)) {
                            this.task.log(String.valueOf(message) + "\n-");
                        } else if (nodeName.equals(UnitTestForMacAndPC.UPDATE_ELEMENT)) {
                            this.task.log(message);
                        } else if (nodeName.equals(UnitTestForMacAndPC.PAUSE_ELEMENT)) {
                            this.task.log("-\n" + message);
                        } else if (nodeName.equals(UnitTestForMacAndPC.RESUME_ELEMENT)) {
                            this.task.log(String.valueOf(message) + "\n-");
                        } else if (nodeName.equals(UnitTestForMacAndPC.ERROR_ELEMENT) || nodeName.equals(UnitTestForMacAndPC.FAILURE_ELEMENT)) {
                            this.task.setHasFailed(true);
                            this.task.log(message, 0);
                        } else {
                            if (nodeName.equals(UnitTestForMacAndPC.FINISH_ELEMENT)) {
                                if (!previousNodeName.equals(UnitTestForMacAndPC.START_ELEMENT) && !previousNodeName.equals(UnitTestForMacAndPC.RESUME_ELEMENT)) {
                                    this.task.log("-");
                                }
                                if (element.getAttribute(UnitTestForMacAndPC.HAS_ERRORS_ATTRIBUTE).equals(UnitTestForMacAndPC.TRUE_VALUE)) {
                                    this.task.log(message, 0);
                                } else {
                                    this.task.log(message);
                                }
                                this.task.log("-\n-");
                                this.task.setFinished(true);
                                this.process.destroy();
                                return;
                            }
                            this.task.log(message);
                        }
                        previousNodeName = nodeName;
                    }
                    break;
                }
            }
            catch (IOException e) {
                throw new BuildException("Error on reading result.", (Throwable)e, this.task.getLocation());
            }
            catch (ParserConfigurationException e) {
                throw new BuildException("Error on reading result.", (Throwable)e, this.task.getLocation());
            }
            catch (SAXException e) {
                throw new BuildException("Error on reading result.", (Throwable)e, this.task.getLocation());
            }
        }

        public void startServer(int port) {
            try {
                this.server = new ServerSocket(port);
                super.start();
            }
            catch (IOException e) {
                this.stopServer();
                throw new BuildException("Error on starting server.", (Throwable)e, this.task.getLocation());
            }
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void stopServer() {
            try {
                try {
                    if (this.server != null) {
                        this.server.close();
                    }
                }
                catch (IOException e) {
                    throw new BuildException("Error on stopping server.", (Throwable)e, this.task.getLocation());
                }
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                try {
                    if (this.in == null) throw throwable;
                    this.in.close();
                    throw throwable;
                }
                catch (IOException e) {
                    throw new BuildException("Error on stopping server.", (Throwable)e, this.task.getLocation());
                }
            }
            {
                Object var2_4 = null;
            }
            try {}
            catch (IOException e) {
                throw new BuildException("Error on stopping server.", (Throwable)e, this.task.getLocation());
            }
            if (this.in == null) return;
            this.in.close();
        }
    }
}

