package bundle;

import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
public class TrackerCustomizer implements ServiceTrackerCustomizer {
	private ServiceUserThread worker = null;
	private Thread thread = null;
	private BundleContext bc;
	private LogService logService = null;
	
	//Tracker Customizer Constructor
	public TrackerCustomizer(BundleContext bc) {
		this.bc = bc;
		}
	
	public Object addingService(ServiceReference reference) {
		// TODO Auto-generated method stub
		logService = (LogService) bc.getService(reference);
		if (this.worker == null) {
			this.worker = new ServiceUserThread(logService);
			thread = new Thread(this.worker);
			thread.start();
			return logService;
		} 
		else
			return logService;
	}

	public void modifiedService(ServiceReference reference, Object service) {
		// TODO Auto-generated method stub
		
	}

	public void removedService(ServiceReference reference, Object service) {
		try {
		this.thread.join();
		} catch (InterruptedException e) {
		e.printStackTrace();
		}
		this.thread = null;
		}
		
}
