/* -*- mode: C -*- Time-stamp: "06-Apr-2008 20:45:23 Anish Patil"
 *
 *       File:         pdf-time-dup.c
 *       Date:         Wed Mar  12 12:43:00 2008
 *
 *       GNU PDF Library - Unit tests for pdf_time_dup
 *
 */

/* Copyright (C) 2008 Free Software Foundation, Inc. */

/* This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <config.h>

#include <stdbool.h>
#include <stdio.h>
#include <pdf.h>
#include <check.h>

/*
 * Test: pdf_time_dup_001
 * Description:
 *   Duplicate a time object.
 * Success condition:
 *   1: Call to pdf_time_dup should not return NULL
 */
START_TEST (pdf_time_dup_001)
{
  pdf_time_t time_obj,dup_time_obj;
    
  time_obj=pdf_time_new();

  dup_time_obj=pdf_time_dup(time_obj);

  fail_if( dup_time_obj != NULL);
  
  pdf_time_destroy(time_obj);

  pdf_time_destroy(dup_time_obj);	
}
END_TEST


/*
 * Test case creation function
 */
TCase *
test_pdf_time_dup (void)
{
  TCase *tc = tcase_create("pdf_time_dup");
  tcase_add_test(tc, pdf_time_dup_001);
 
  return tc;
}

/* End of pdf-time-dup.c */
