/* -*- mode: C -*- Time-stamp: "06-Apr-2008 20:38:58 Anish Patil"
 *
 *       File:         pdf-time-span-to-secs.c
 *       Date:         Wed Mar  12 12:43:00 2008
 *
 *       GNU PDF Library - Unit tests for pdf_time_span_to_secs
 *
 */

/* Copyright (C) 2008 Free Software Foundation, Inc. */

/* This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <config.h>

#include <stdbool.h>
#include <stdio.h>
#include <pdf.h>
#include <check.h>

/*
 * Test: pdf_time_span_to_secs_001
 * Description:
 *   Create time span from pdf_time_span_t object
 * Success condition:
 *   Call to pdf_time_span_to_secs should return positive integer number
 */
START_TEST (pdf_time_span_to_secs_001)
{
  pdf_time_span_t time_span_obj;
  
  pdf_i64_t time_span;

  time_span_obj=pdf_time_span_new();
   	
  pdf_time_span_set_from_i32(&time_span_obj,1000);

  time_span=pdf_time_span_to_secs(time_span_obj);

  fail_if( pdf_i64_cmp_i32(time_span,0) <= 0 );
  
  pdf_time_span_destroy(&time_span_obj);
	
}
END_TEST


/*
 * Test: pdf_time_span_to_secs_002
 * Description:
 *   Create time span from pdf_time_span_t object
 * Success condition:
 *   Call to pdf_time_span_to_secs should return negative integer number
 */
START_TEST (pdf_time_span_to_secs_002)
{
  pdf_time_span_t time_span_obj;
  
  pdf_i64_t time_span;

  time_span_obj=pdf_time_span_new();
   	
  pdf_time_span_set_from_i32(&time_span_obj,-1000);

  time_span=pdf_time_span_to_secs(time_span_obj);

  fail_if( pdf_i64_cmp_i32(time_span,0) >= 0 );
  
  pdf_time_span_destroy(&time_span_obj);
	
}
END_TEST

/*
 * Test case creation function
 */
TCase *
test_pdf_time_span_to_secs (void)
{
  TCase *tc = tcase_create("pdf_time_span_to_secs");
  tcase_add_test(tc, pdf_time_span_to_secs_001);
  tcase_add_test(tc, pdf_time_span_to_secs_002);

  return tc;
}

/* End of pdf-time-span-to-secs.c */
