/*
 * kpfm_test1.c
 *
 * Copyright (c) 2006 Red Hat
 * 		Contributions by William Cohen <wcohen@redhat.com>
 *
 * A simple program to exercise the perfmon2 kabi
 *
 */
#include <linux/kernel.h>
#include <linux/types.h>
#include <linux/module.h>
#include <linux/config.h>
#include <linux/init.h>
#include <linux/smp.h>
#include <linux/sysctl.h>

#include <linux/perfmon.h>

MODULE_AUTHOR("William Cohen <wcohen@redhat.com>");
MODULE_DESCRIPTION("kpfm_test1 module to exercise perfmon2 KABI");
MODULE_LICENSE("GPL");

static struct pfarg_ctx req;
static struct completion c;
static void *desc;
static struct pfarg_load load_args;
static struct pfarg_start start_args;

/* set things up for AMD64 */
#define USR_BIT (1<<16)
#define OS_BIT (1<<17)
#define E_BIT (1<<18)
#define PC_BIT (1<<19)
#define INT_BIT (1<<20)
#define EN_BIT (1<<22)
#define INV_BIT (1<<23)
#define NUM_PMD 1
static struct pfarg_pmd pd[] = {
	{.reg_num=0, .reg_value=0}
};
static int num_pfm_pmd = NUM_PMD;
#define NUM_PMC 1
static struct pfarg_pmc pc[] = {
	{.reg_num=0, .reg_value=(0x76|USR_BIT|OS_BIT|EN_BIT|INT_BIT)}
};
static int num_pfm_pmc = NUM_PMC;


int pfm_register_setup(void)
{
	/* for the time being hard coded the events to monitor */
	int err = 0;

	err = pfmk_write_pmcs(desc, pc, num_pfm_pmc);
	if (err) return err;
	
	err = pfmk_write_pmds(desc, pd, num_pfm_pmd);
	if (err) return err;
	
	return 0;
}

static int cpu_pfm_init(void)
{
	int err = 0;

	/* set up context information */
	/* only does system-wide contexts */
	req.ctx_flags |= PFM_FL_SYSTEM_WIDE;

	/* create a context */
	err =  pfmk_create_context(&req, NULL, 0, &c, &desc, NULL);
	if (err) goto cleanup;

	/* set up the counters */
	err = pfm_register_setup();
	if (err) goto cleanup2;

	/* start measuring */
	err = pfmk_load_context(desc, &load_args);
	if (err) {
		printk("pfmk_load_context error\n");
		goto cleanup2;
	}
	err = pfmk_start(desc, &start_args);
	if (err) {
		printk("pfmk_start error\n");
		goto cleanup3;
	}

	return err;

cleanup3: pfmk_unload_context(desc);
cleanup2: pfmk_close(desc);
cleanup: return err;
}

static int kpfm_test1_init_module(void)
{
	return cpu_pfm_init();
}

static void cpu_pfm_cleanup(void)
{
	int i;

	/* stop the counters */
	if (pfmk_stop(desc)) printk("pfmk_stop error\n");
	/* read and print out the information to /var/log/messages */
	if (pfmk_read_pmds(desc, pd, num_pfm_pmd))
		printk( "pfm_read_pmds error\n");
	for (i=0; i< num_pfm_pmd; ++i) {
		printk ("pd[%d] = %lld\n", pd[i].reg_num, pd[i].reg_value);
	}
	if (pfmk_unload_context(desc)) printk ("pfmk_unload_context error\n");
	if (pfmk_close(desc)) printk ("pfmk_unload_context error\n");;
}

static void kpfm_test1_cleanup_module(void)
{
	cpu_pfm_cleanup();
	return;
}

module_init(kpfm_test1_init_module);
module_exit(kpfm_test1_cleanup_module);
