/*
 * This file contains the POWER4 PMU register description tables
 * and pmc checker used by perfmon.c.
 *
 * Copyright (c) 2005 David Gibson, IBM Corporation.
 *
 * Based on perfmon_p6.c:
 * Copyright (c) 2005-2006 Hewlett-Packard Development Company, L.P.
 * Contributed by Stephane Eranian <eranian@hpl.hp.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of version 2 of the GNU General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 * 02111-1307 USA
  */
#include <linux/module.h>
#include <linux/perfmon.h>

MODULE_AUTHOR("David Gibson <dwg@au1.ibm.com>");
MODULE_DESCRIPTION("POWER4 PMU description table");
MODULE_LICENSE("GPL");

static struct pfm_reg_desc pfm_power5_pmc_desc[]={
/* mmcr0 */ PMC_D(PFM_REG_I, "MMCR0", MMCR0_FC, 0, 0, 0),
/* mmcr1 */ PMC_D(PFM_REG_I, "MMCR1", 0x0, 0, 0, 0),
/* mmcra */ PMC_D(PFM_REG_I, "MMCRA", 0x0, 0, 0, 0)
};
#define PFM_PM_NUM_PMCS	(sizeof(pfm_power5_pmc_desc)/sizeof(struct pfm_reg_desc))

static struct pfm_reg_desc pfm_power5_pmd_desc[]={
/* tb    */ PMD_D(PFM_REG_C, "TB"  , 0), /* rsvd_msk = -1 */
/* pmd1  */ PMD_D(PFM_REG_C, "PMC1", 0),
/* pmd2  */ PMD_D(PFM_REG_C, "PMC2", 0),
/* pmd3  */ PMD_D(PFM_REG_C, "PMC3", 0),
/* pmd4  */ PMD_D(PFM_REG_C, "PMC4", 0),
/* pmd5  */ PMD_D(PFM_REG_C, "PMC5", 0),
/* pmd6  */ PMD_D(PFM_REG_C, "PMC6", 0)
};
#define PFM_PM_NUM_PMDS	(sizeof(pfm_power5_pmd_desc)/sizeof(struct pfm_reg_desc))

static int pfm_power5_probe_pmu(void)
{
	unsigned long pvr = mfspr(SPRN_PVR);

	if (PVR_VER(pvr) != PV_POWER5)
		return -1;

	return 0;
}

/*
 * impl_pmcs, impl_pmds are computed at runtime to minimize errors!
 */
static struct pfm_pmu_config pfm_power5_pmu_conf = {
	.pmu_name = "POWER5",
	.counter_width = 31,
	.pmd_desc = pfm_power5_pmd_desc,
	.pmc_desc = pfm_power5_pmc_desc,
	.num_pmc_entries = PFM_PM_NUM_PMCS,
	.num_pmd_entries = PFM_PM_NUM_PMDS,
	.probe_pmu  = pfm_power5_probe_pmu,
	.flags = PFM_PMU_BUILTIN_FLAG,
	.owner = THIS_MODULE
};
	
static int __init pfm_power5_pmu_init_module(void)
{
	return pfm_pmu_register(&pfm_power5_pmu_conf);
}

static void __exit pfm_power5_pmu_cleanup_module(void)
{
	pfm_pmu_unregister(&pfm_power5_pmu_conf);
}

module_init(pfm_power5_pmu_init_module);
module_exit(pfm_power5_pmu_cleanup_module);
