/* events.h
    Copyright (C) 2006 Red Hat, Inc.

  This file is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.



  This file contains events event triggering code specific to the
  various processors.

*/

#ifndef __EVENTS_H__
#define __EVENTS_H__

#define DEFAULT_TRIGGER_COUNT 1000
#define DEFAULT_ITERATIONS 10
#define DEFAULT_ERROR 0.05


/* FIXME events specific to AMD64 */
#if defined(CONFIG_PFMLIB_AMD64)

char *event_names[]={"MISALIGNED_ACCESSES", NULL};

struct misaligned {
	char a;
	long b;
} __attribute__((__packed__));

volatile struct misaligned one;
volatile long x=0;


static void trigger_event(int count)
{
	int i;

	for(i=0; i<count; ++i)
		x=one.b;
}

#endif

/* FIXME events specific to Pentium4 */

#endif /* __EVENTS_H */
