/* events.h
    Copyright (C) 2006 Red Hat, Inc.

  This file is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.



  This file contains events event triggering code specific to the
  various processors.

*/

#ifndef __EVENTS_H__
#define __EVENTS_H__

#define DEFAULT_TRIGGER_COUNT 1000000
#define DEFAULT_ITERATIONS 10
#define DEFAULT_ERROR 0.05


#if defined(CONFIG_PFMLIB_ITANIUM2) || defined(CONFIG_PFMLIB_MONTECITO)

char *event_names[]={"FP_OPS_RETIRED", NULL};

static double a = 1.0;
static double b = 0.0;

static void trigger_event(int count)
{
	int i;

	for(i=0; i<count; ++i)
		b += a;
}

#endif

#if defined(CONFIG_PFMLIB_AMD64)

char *event_names[]={"MISALIGNED_ACCESSES", NULL};

struct misaligned {
	char a;
	long b;
} __attribute__((__packed__));

volatile struct misaligned one;
volatile long x=0;


static void trigger_event(int count)
{
	int i;

	for(i=0; i<count; ++i)
		x=one.b;
}

#endif

/* FIXME correct events specific to Pentium4 */
#if defined(CONFIG_PFMLIB_PENTIUM4)

char *event_names[]={"FP_OPS_RETIRED", NULL};

static double a = 1.0;
static double b = 0.0;

static void trigger_event(int count)
{
	int i;

	for(i=0; i<count; ++i)
		b += a;
}

#endif


#if defined(CONFIG_PFMLIB_I386_P6)

char *event_names[]={"FLOPS", NULL};

static double a = 1.0;
static double b = 0.0;

static void trigger_event(int count)
{
	int i;

	for(i=0; i<count; ++i)
		b += a;
}

#endif

/* FIXME add events for the Intel core/duo processors */
#if defined(CONFIG_PFMLIB_GEN_IA32)

char *event_names[]={"FLOPS", NULL};

static double a = 1.0;
static double b = 0.0;

static void trigger_event(int count)
{
	int i;

	for(i=0; i<count; ++i)
		b += a;
}

#endif

/* FIXME add events specific for various MIPS64 processor */

#endif /* __EVENTS_H */
