package iThread;

use 5.6.1;
use strict;
use warnings;

require Exporter;
require DynaLoader;

our @ISA = qw(Exporter DynaLoader);

# Items to export into callers namespace by default. Note: do not export
# names by default without a very good reason. Use EXPORT_OK instead.
# Do not simply export all your public functions/methods/constants.

# This allows declaration	use iThread ':all';
# If you do not need this, moving things directly into @EXPORT or @EXPORT_OK
# will save memory.
our %EXPORT_TAGS = ( 'all' => [ qw(
	
) ] );

our @EXPORT_OK = ( @{ $EXPORT_TAGS{'all'} } );

our @EXPORT = qw(
	
);
our $VERSION = '0.01';

sub new {
    my $class = shift;
    return $class->create(@_);
}

bootstrap iThread $VERSION;

# Preloaded methods go here.

1;
__END__
# Below is stub documentation for your module. You better edit it!

=head1 NAME

iThread - Perl extension allowing use of interpreter based threads from perl

=head1 SYNOPSIS

  use iThread;

  sub start_thread {
      print "Thread started\n";
  }
  my $thread = iThread->new("start_thread","argument");
  $thread->new(sub { print "I am a thread"},"argument");
  $thread->join();
  $thread->detach();

=head1 DESCRIPTION

Perl 5.6 has something called interpreter threads, interpreter threads are built on MULTIPLICITY and allows for several different perl interpreters to run in different threads. This has been used in win32 perl to fake forks, it has also been avaible to people embedding perl. 

I came across a situation where I needed a global cache of data and multiple threads working on a set of data using the cache for non changing data, so I decided to expose ithreads to the perl level, that is were we realy need them.

iThreads are a bit different from what people normall thing of as threads, these threads do not share any memory at all, in the future it will be possible to explicitly share data.

I have tried to mimick pthreads thread interface more than the old Thread.pm, first of all there can be no compatiblity between the old Thread.pm and iThread.pm, they work too differently, second I like pthreads, they are simple.




=head1 TODO

=over

=item Fix so detach works

=item Fix so the return value is returned when you join

=item Add join_all

=item Fix so you can send in any number of any kind of arguments to the function being created, this is hardcoded to one!

=item Fix memory handling!

=item Add iThread::mutexes

=item Add iThread::Semaphore

=item Add iThread::Queue

=item Add iThread::SharedHash (?)

=item Add sharing of a SV

=back

=head1 AUTHOR and COPYRIGHT

Artur Bergman <lt>artur at contiller.se<gt>

iThread is released under the same license as Perl

Thanks to 

Richard Soderberg <lt>rs at crystalflame.net<gt> 
Helping me out tons, trying to find reasons for races and other wierd bugs!

Simon Cozens <lt>simon at brecon.co.uk<gt>
Being there to answer zillions of annoying questions 

Rocco Caputo <lt>troc at netrus.net<gt>

=head1 BUGS

Plenty of bugs!

Memory consumtion is down, but you cannot pass a variable number of arguments, you must pass one and this is annoying.

Also it sucks memory big big big big time!

=head1 SEE ALSO

L<perl>, L<perlcall>, L<perlembed>, L<perlguts>

=cut


