#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"
#include <pthread.h>
#include <stdio.h>
#include <stdlib.h>





typedef struct {
   PerlInterpreter *interp;
   SV* thread_function_start;
	SV* init_params;
	pthread_t tid;
	pthread_mutex_t main_mutex;
   int active;
   int detached;	
} myperl_iThread;

pthread_mutex_t *global_create_mutex = NULL;

void execute_function (myperl_iThread* thread) {
	dTHXa(thread->interp);
	dSP;
	ENTER;
	SAVETMPS;
	PUSHMARK(SP);
	XPUSHs(thread->init_params);	
	PUTBACK;
 	call_sv(thread->thread_function_start, G_DISCARD);
	FREETMPS;
	LEAVE;
}

void run_thread(myperl_iThread* thread) {
	PERL_SET_CONTEXT(thread->interp);
   execute_function(thread);
   perl_destruct(thread->interp);
   perl_free(thread->interp);
   pthread_exit(0);
}



SV* create(char* class, SV* function_to_call, SV* params) {
	myperl_iThread* thread = malloc(sizeof(myperl_iThread));
   SV*      obj_ref;
   SV*      obj;

	SV*		temp_store;

   PerlInterpreter *current_perl;
	void *retval;



	if(!global_create_mutex) {
		global_create_mutex = (pthread_mutex_t*) malloc(sizeof(pthread_mutex_t));
		pthread_mutex_init(global_create_mutex,NULL);
	}
	pthread_mutex_lock(global_create_mutex);
	obj_ref = newSViv(0);
	obj = newSVrv(obj_ref, class);
   sv_setiv(obj, (IV)thread);
   SvREADONLY_on(obj);




   current_perl = Perl_get_context();	


   temp_store = Perl_get_sv(current_perl, "iThread::paramtempstore", TRUE | GV_ADDMULTI);
	Perl_sv_setsv(current_perl, temp_store,params);
	params = NULL;
	temp_store = NULL;

	temp_store = Perl_get_sv(current_perl, "iThread::calltempstore", TRUE | GV_ADDMULTI);
	Perl_sv_setsv(current_perl,temp_store, function_to_call);
	function_to_call = NULL;
	temp_store = NULL;

	thread->interp = perl_clone(current_perl,0);


	thread->thread_function_start = newSVsv(Perl_get_sv(thread->interp, "iThread::calltempstore",FALSE));
	thread->init_params = newSVsv(Perl_get_sv(thread->interp, "iThread::paramtempstore",FALSE));


	temp_store = Perl_get_sv(current_perl,"iThread::paramtempstore",FALSE);
	Perl_sv_setsv(current_perl, temp_store, &PL_sv_undef);
	temp_store = Perl_get_sv(thread->interp,"iThread::paramtempstore",FALSE);
	Perl_sv_setsv(thread->interp,temp_store, &PL_sv_undef);

	temp_store = Perl_get_sv(current_perl,"iThread::calltempstore",FALSE);
	Perl_sv_setsv(current_perl, temp_store, &PL_sv_undef);
	temp_store = Perl_get_sv(thread->interp,"iThread::calltempstore",FALSE);
	Perl_sv_setsv(thread->interp,temp_store, &PL_sv_undef);



	PERL_SET_CONTEXT(current_perl);



	pthread_mutex_unlock(global_create_mutex);	
	pthread_mutex_init(&thread->main_mutex,NULL);
	pthread_create( &thread->tid, NULL, (void *) &run_thread, thread);




  return obj_ref;
}



void join_thread(SV* obj) {
    void *retval;
    myperl_iThread* thread = (myperl_iThread*)SvIV(SvRV(obj));

    pthread_join(thread->tid, &retval);

}

void detach_thread(SV* obj) {
	myperl_iThread* thread = (myperl_iThread*)SvIV(SvRV(obj));
	//thread->detached = 1;
	//pthread_detach(thread->tid);
}

void DESTROY (SV* obj) {
	myperl_iThread* thread = (myperl_iThread*)SvIV(SvRV(obj));
	return;
	//printf("%s\n", "calling DESTROY");	
	if(thread->detached == 1) {
		return;
	}	
	if(thread->active == 1) {
//		thread->detached = 1;
		detach_thread(obj);
	} else {
		printf("%s\n", "freeing stuff");
		/// we are neither detached nor active, time to clean up
//		free(thread->thread_function_start);
//		free(thread->interp);
//		free(thread);
	}
}

MODULE = iThread		PACKAGE = iThread		


PROTOTYPES: DISABLE

SV *
create (class, function_to_call, params)
        char *  class
        SV *    function_to_call
		  SV *    params
	

void
join (obj)
        SV *    obj
        PREINIT:
        I32* temp;
        PPCODE:
        temp = PL_markstack_ptr++;
        join_thread(obj);
        if (PL_markstack_ptr != temp) {
          /* truly void, because dXSARGS not invoked */
          PL_markstack_ptr = temp;
          XSRETURN_EMPTY; /* return empty stack */
        }
        /* must have used dXSARGS; list context implied */
        return; /* assume stack size is correct */

void
detach (obj)
        SV *    obj
        PREINIT:
        I32* temp;
        PPCODE:
        temp = PL_markstack_ptr++;
        detach_thread(obj);
        if (PL_markstack_ptr != temp) {
          /* truly void, because dXSARGS not invoked */
          PL_markstack_ptr = temp;
          XSRETURN_EMPTY; /* return empty stack */
        }
        /* must have used dXSARGS; list context implied */
        return; /* assume stack size is correct */

void
run (obj)
        SV *    obj
        PREINIT:
        I32* temp;
        PPCODE:
        temp = PL_markstack_ptr++;
        run_thread_user(obj);
        if (PL_markstack_ptr != temp) {
          /* truly void, because dXSARGS not invoked */
          PL_markstack_ptr = temp;
          XSRETURN_EMPTY; /* return empty stack */
        }
        /* must have used dXSARGS; list context implied */
        return; /* assume stack size is correct */




void
DESTROY (obj)
        SV *    obj
        PREINIT:
        I32* temp;
        PPCODE:
        temp = PL_markstack_ptr++;
        DESTROY(obj);
        if (PL_markstack_ptr != temp) {
          /* truly void, because dXSARGS not invoked */
          PL_markstack_ptr = temp;
          XSRETURN_EMPTY; /* return empty stack */
        }
        /* must have used dXSARGS; list context implied */
        return; /* assume stack size is correct */















